/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.SystemInfo;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/util/TerminalEnvironment;", "", "()V", "LC_CTYPE", "", "setCharacterEncoding", "", "env", "", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEnvironment.kt\norg/jetbrains/plugins/terminal/util/TerminalEnvironment\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,25:1\n10#2:26\n*S KotlinDebug\n*F\n+ 1 TerminalEnvironment.kt\norg/jetbrains/plugins/terminal/util/TerminalEnvironment\n*L\n16#1:26\n*E\n"})
public final class TerminalEnvironment {
    @NotNull
    public static final TerminalEnvironment INSTANCE = new TerminalEnvironment();
    @NotNull
    private static final String LC_CTYPE = "LC_CTYPE";

    private TerminalEnvironment() {
    }

    public final void setCharacterEncoding(@NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        if (SystemInfo.isMac) {
            Object object;
            String charsetName = AdvancedSettings.Companion.getString("terminal.character.encoding");
            try {
                Charset charset = Charset.forName(charsetName);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                object = charset;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalEnvironment.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot find " + charsetName + " encoding", (Throwable)e);
                object = Charsets.UTF_8;
            }
            Charset charset = object;
            object = env;
            String string = LC_CTYPE;
            String string2 = charset.name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
            String string3 = string2;
            object.put(string, string3);
        }
    }
}

