/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalController;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u000bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "eventsHandler", "Lorg/jetbrains/plugins/terminal/exp/TerminalEventsHandler;", "withVerticalScroll", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalEventsHandler;Z)V", "charSize", "Ljava/awt/Dimension;", "getCharSize", "()Ljava/awt/Dimension;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController;", "getController", "()Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "terminalWidth", "", "getTerminalWidth", "()I", "createEditor", "dispose", "", "isFocused", "SimpleTerminalPanel", "intellij.terminal"})
public final class SimpleTerminalView
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    private final boolean withVerticalScroll;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final SimpleTerminalController controller;
    @NotNull
    private final JComponent component;

    public SimpleTerminalView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalSession session2, @NotNull TerminalEventsHandler eventsHandler, boolean withVerticalScroll) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        this.project = project;
        this.settings = settings;
        this.withVerticalScroll = withVerticalScroll;
        this.editor = this.createEditor();
        this.controller = new SimpleTerminalController(this.settings, session2, (EditorEx)this.editor, eventsHandler);
        this.component = new SimpleTerminalPanel();
        this.editor.addFocusListener(new FocusChangeListener(){

            public void focusGained(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getController().setFocused(true);
            }

            public void focusLost(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getController().setFocused(false);
            }
        });
    }

    public /* synthetic */ SimpleTerminalView(Project project, JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase, TerminalSession terminalSession, TerminalEventsHandler terminalEventsHandler, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(project, jBTerminalSystemSettingsProviderBase, terminalSession, terminalEventsHandler, bl);
    }

    @NotNull
    public final SimpleTerminalController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    public final int getTerminalWidth() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int scrollBarWidth = this.editor.getScrollPane().getVerticalScrollBar().getWidth();
        return visibleArea.width - scrollBarWidth;
    }

    @NotNull
    public final Dimension getCharSize() {
        return new Dimension(this.editor.getCharHeight(), this.editor.getLineHeight());
    }

    private final EditorImpl createEditor() {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = TerminalUiUtils.INSTANCE.createOutputEditor((Document)document, this.project, this.settings);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getScrollPane().setVerticalScrollBarPolicy(this.withVerticalScroll ? 20 : 21);
        return editor;
    }

    public final boolean isFocused() {
        return this.editor.getContentComponent().hasFocus();
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        Disposer.dispose((Disposable)this.controller);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalView$SimpleTerminalPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalView;)V", "getData", "", "dataId", "", "intellij.terminal"})
    private final class SimpleTerminalPanel
    extends JPanel
    implements DataProvider {
        public SimpleTerminalPanel() {
            this.setBackground(TerminalUi.INSTANCE.getTerminalBackground());
            this.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
            this.setLayout(new BorderLayout());
            this.add((Component)SimpleTerminalView.this.editor.getComponent(), "Center");
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return CommonDataKeys.EDITOR.is(dataId) ? SimpleTerminalView.this.editor : null;
        }
    }
}

