/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TerminalWidgetKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.DefaultTerminalRunnerFactory;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabLeftAction;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabRightAction;
import org.jetbrains.plugins.terminal.action.RenameTerminalSessionAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalCommandHistoryManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public final class TerminalToolWindowManager
implements Disposable {
    private static final Key<TerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private static final Logger LOG = Logger.getInstance(TerminalToolWindowManager.class);
    private static final Key<AbstractTerminalRunner<?>> RUNNER_KEY = Key.create((String)"RUNNER_KEY");
    private ToolWindow myToolWindow;
    private final Project myProject;
    private final AbstractTerminalRunner<?> myTerminalRunner;
    private TerminalDockContainer myDockContainer;
    private final Map<TerminalWidget, TerminalContainer> myContainerByWidgetMap;
    private final List<Consumer<TerminalWidget>> myTerminalSetupHandlers;

    @NotNull
    public AbstractTerminalRunner<?> getTerminalRunner() {
        AbstractTerminalRunner<?> abstractTerminalRunner = this.myTerminalRunner;
        if (abstractTerminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(0);
        }
        return abstractTerminalRunner;
    }

    public ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public TerminalToolWindowManager(@NotNull Project project) {
        if (project == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(1);
        }
        this.myContainerByWidgetMap = new HashMap<TerminalWidget, TerminalContainer>();
        this.myTerminalSetupHandlers = new CopyOnWriteArrayList<Consumer<TerminalWidget>>();
        this.myProject = project;
        this.myTerminalRunner = ((DefaultTerminalRunnerFactory)ApplicationManager.getApplication().getService(DefaultTerminalRunnerFactory.class)).create(project);
    }

    public void dispose() {
    }

    @Deprecated
    public Set<JBTerminalWidget> getWidgets() {
        return ContainerUtil.map2SetNotNull(this.myContainerByWidgetMap.keySet(), widget -> JBTerminalWidget.asJediTermWidget((TerminalWidget)widget));
    }

    @NotNull
    public Set<TerminalWidget> getTerminalWidgets() {
        Set<TerminalWidget> set = Collections.unmodifiableSet(this.myContainerByWidgetMap.keySet());
        if (set == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void addNewTerminalSetupHandler(@NotNull Consumer<TerminalWidget> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(4);
        }
        this.myTerminalSetupHandlers.add(listener);
        if (!Disposer.tryRegister((Disposable)parentDisposable, () -> this.myTerminalSetupHandlers.remove(listener))) {
            this.myTerminalSetupHandlers.remove(listener);
        }
    }

    public static TerminalToolWindowManager getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(5);
        }
        return (TerminalToolWindowManager)project.getService(TerminalToolWindowManager.class);
    }

    void initToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(6);
        }
        if (this.myToolWindow != null) {
            LOG.error("Terminal tool window already initialized");
            return;
        }
        this.myToolWindow = toolWindow;
        toolWindow.setTabActions(new AnAction[]{ActionManager.getInstance().getAction("TerminalToolwindowActionGroup")});
        toolWindow.setTabDoubleClickActions(Collections.singletonList(new RenameTerminalSessionAction()));
        this.myProject.getMessageBus().connect(toolWindow.getDisposable()).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                if (toolWindow == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && TerminalToolWindowManager.this.myToolWindow == toolWindow && toolWindow.isVisible() && toolWindow.getContentManager().isEmpty()) {
                    TerminalToolWindowManager.this.createNewSession(TerminalToolWindowManager.this.myTerminalRunner, null, true, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "org/jetbrains/plugins/terminal/TerminalToolWindowManager$1", "toolWindowShown"));
            }
        });
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer();
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer, toolWindow.getDisposable());
        }
    }

    void restoreTabs(@Nullable TerminalArrangementState arrangementState) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                this.createNewSession(this.myTerminalRunner, tabState, false, true);
            }
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(7);
        }
        this.createNewSession(terminalRunner, null);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(8);
        }
        this.createNewSession(terminalRunner, tabState, true);
    }

    @NotNull
    public TerminalWidget createNewSession() {
        return this.createNewSession(this.myTerminalRunner, null, true, true);
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName) {
        ShellTerminalWidget shellTerminalWidget = this.createLocalShellWidget(workingDirectory, tabName, true, true);
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(9);
        }
        return shellTerminalWidget;
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus) {
        ShellTerminalWidget shellTerminalWidget = this.createLocalShellWidget(workingDirectory, tabName, requestFocus, true);
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(10);
        }
        return shellTerminalWidget;
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        TerminalTabState tabState = new TerminalTabState();
        tabState.myTabName = tabName;
        tabState.myWorkingDirectory = workingDirectory;
        TerminalWidget widget = this.createNewSession(this.myTerminalRunner, tabState, requestFocus, deferSessionStartUntilUiShown);
        ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)Objects.requireNonNull(JBTerminalWidget.asJediTermWidget((TerminalWidget)widget));
        if (shellTerminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(11);
        }
        return shellTerminalWidget;
    }

    private void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, boolean requestFocus) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(12);
        }
        this.createNewSession(terminalRunner, tabState, requestFocus, true);
    }

    @NotNull
    private TerminalWidget createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(13);
        }
        ToolWindow toolWindow = this.getOrInitToolWindow();
        Content content = this.createNewTab(null, terminalRunner, toolWindow, tabState, requestFocus, deferSessionStartUntilUiShown);
        TerminalWidget terminalWidget = Objects.requireNonNull((TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY));
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(14);
        }
        return terminalWidget;
    }

    @NotNull
    private ToolWindow getOrInitToolWindow() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
            Objects.requireNonNull(toolWindow).getContentManager();
            LOG.assertTrue(toolWindow == this.myToolWindow);
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(15);
        }
        return toolWindow2;
    }

    @NotNull
    public Content newTab(@NotNull ToolWindow toolWindow, @Nullable TerminalWidget terminalWidget) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(16);
        }
        return this.createNewTab(terminalWidget, this.myTerminalRunner, toolWindow, null, true, true);
    }

    @NotNull
    private Content createNewTab(@Nullable TerminalWidget terminalWidget, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable TerminalTabState tabState, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(17);
        }
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(18);
        }
        Content content = this.createTerminalContent(terminalRunner, toolWindow, terminalWidget, tabState, deferSessionStartUntilUiShown);
        content.putUserData(RUNNER_KEY, terminalRunner);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        new TerminalTabCloseListener(content, this.myProject, this);
        Runnable selectRunnable = () -> contentManager.setSelectedContent(content, requestFocus);
        if (requestFocus && !toolWindow.isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activating " + toolWindow.getId() + " tool window");
            }
            toolWindow.activate(selectRunnable, true, true);
        } else {
            selectRunnable.run();
        }
        Content content2 = content;
        if (content2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(19);
        }
        return content2;
    }

    @Nls
    private static String generateUniqueName(@Nls String suggestedName, List<@Nls String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    @NotNull
    private Content createTerminalContent(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable TerminalWidget terminalWidget, @Nullable TerminalTabState tabState, boolean deferSessionStartUntilUiShown) {
        if (terminalRunner == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(20);
        }
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(21);
        }
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel(PropertiesComponent.getInstance((Project)this.myProject), toolWindow);
        Content content = ContentFactory.getInstance().createContent((JComponent)((Object)panel), null, false);
        TerminalWidget widget = terminalWidget;
        if (widget == null) {
            String currentWorkingDir = terminalRunner.getCurrentWorkingDir(tabState);
            NullableLazyValue commandHistoryFileLazyValue = NullableLazyValue.atomicLazyNullable(() -> TerminalCommandHistoryManager.getInstance().getOrCreateCommandHistoryFile(tabState != null ? tabState.myCommandHistoryFileName : null, this.myProject));
            ShellStartupOptions startupOptions = new ShellStartupOptions.Builder().workingDirectory(currentWorkingDir).shellCommand(tabState != null ? tabState.myShellCommand : null).commandHistoryFileProvider((Function0<? extends Path>)((Function0)() -> (Path)commandHistoryFileLazyValue.getValue())).build();
            widget = terminalRunner.startShellTerminalWidget((Disposable)content, startupOptions, deferSessionStartUntilUiShown);
            widget.getTerminalTitle().change(state -> {
                if (state.getDefaultTitle() == null) {
                    state.setDefaultTitle(terminalRunner.getDefaultTabTitle());
                }
                return Unit.INSTANCE;
            });
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            TerminalWidgetKt.setNewParentDisposable((TerminalWidget)terminalWidget, (Disposable)content);
        }
        if (tabState != null && tabState.myTabName != null) {
            widget.getTerminalTitle().change(state -> {
                if (tabState.myIsUserDefinedTabTitle) {
                    state.setUserDefinedTitle(tabState.myTabName);
                } else {
                    state.setDefaultTitle(tabState.myTabName);
                }
                return null;
            });
        }
        TerminalToolWindowManager.updateTabTitle(widget.getTerminalTitle(), toolWindow, content);
        this.setupTerminalWidget(toolWindow, widget, content);
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)widget);
        TerminalContainer container = new TerminalContainer(this.myProject, content, widget, this);
        panel.setContent(container.getWrapperPanel());
        panel.addFocusListener(TerminalToolWindowManager.createFocusListener(toolWindow));
        TerminalWidget finalWidget = widget;
        this.myTerminalSetupHandlers.forEach(consumer2 -> consumer2.accept(finalWidget));
        panel.updateDFState();
        content.setPreferredFocusedComponent(() -> finalWidget.getPreferredFocusableComponent());
        Content content2 = content;
        if (content2 == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(22);
        }
        return content2;
    }

    private void setupTerminalWidget(final @NotNull ToolWindow toolWindow, final @NotNull TerminalWidget widget, final @NotNull Content content) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(23);
        }
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(24);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(25);
        }
        final MoveTerminalToolWindowTabLeftAction moveTabLeftAction = new MoveTerminalToolWindowTabLeftAction();
        final MoveTerminalToolWindowTabRightAction moveTabRightAction = new MoveTerminalToolWindowTabRightAction();
        widget.getTerminalTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                if (terminalTitle == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> TerminalToolWindowManager.updateTabTitle(terminalTitle, toolWindow, content), TerminalToolWindowManager.this.myProject.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalTitle", "org/jetbrains/plugins/terminal/TerminalToolWindowManager$2", "onTitleChanged"));
            }
        }, (Disposable)content);
        final JBTerminalWidget terminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)widget);
        if (terminalWidget == null) {
            return;
        }
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalToolWindowManager.this.newTab(toolWindow, null);
            }

            public void onTerminalStarted() {
            }

            public void onPreviousTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectNextContent();
                }
            }

            public void onSessionClosed() {
                TerminalToolWindowManager.this.getContainer(terminalWidget).closeAndHide();
            }

            public void showTabs() {
                ShowContentAction action = new ShowContentAction(toolWindow, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)toolWindow.getComponent());
                KeyEvent fakeKeyEvent = new KeyEvent(toolWindow.getComponent(), 1001, System.currentTimeMillis(), 0, 0, '\u0000');
                AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)fakeKeyEvent, (String)"unknown", null, (DataContext)dataContext);
                action.actionPerformed(event);
            }

            public void moveTabRight() {
                moveTabRightAction.move(content, TerminalToolWindowManager.this.myProject);
            }

            public void moveTabLeft() {
                moveTabLeftAction.move(content, TerminalToolWindowManager.this.myProject);
            }

            public boolean canMoveTabRight() {
                return moveTabRightAction.isAvailable(content);
            }

            public boolean canMoveTabLeft() {
                return moveTabLeftAction.isAvailable(content);
            }

            public boolean canSplit(boolean vertically) {
                return true;
            }

            public void split(boolean vertically) {
                TerminalToolWindowManager.this.split(widget, vertically);
            }

            public boolean isGotoNextSplitTerminalAvailable() {
                return TerminalToolWindowManager.this.isSplitTerminal(terminalWidget);
            }

            public void gotoNextSplitTerminal(boolean forward) {
                TerminalToolWindowManager.this.gotoNextSplitTerminal(widget, forward);
            }
        });
    }

    private static void updateTabTitle(@NotNull TerminalTitle terminalTitle, @NotNull ToolWindow toolWindow, @NotNull Content content) {
        if (terminalTitle == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(26);
        }
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(27);
        }
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(28);
        }
        String title = terminalTitle.buildTitle();
        List<String> tabs = Arrays.stream(toolWindow.getContentManager().getContents()).filter(c -> c != content).map(c -> c.getDisplayName()).toList();
        content.setDisplayName(TerminalToolWindowManager.generateUniqueName(title, tabs));
    }

    public boolean isSplitTerminal(@NotNull JBTerminalWidget widget) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(29);
        }
        TerminalContainer container = this.getContainer(widget);
        return container.isSplitTerminal();
    }

    public boolean isSplitTerminal(@NotNull TerminalWidget widget) {
        TerminalContainer container;
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(30);
        }
        return (container = this.getContainer(widget)) != null && container.isSplitTerminal();
    }

    public void gotoNextSplitTerminal(@NotNull TerminalWidget widget, boolean forward) {
        TerminalWidget next;
        TerminalContainer container;
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(31);
        }
        if ((container = this.getContainer(widget)) != null && (next = container.getNextSplitTerminal(forward)) != null) {
            next.requestFocus();
        }
    }

    public void split(@NotNull TerminalWidget widget, boolean vertically) {
        TerminalContainer container;
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(32);
        }
        if ((container = this.getContainer(widget)) != null) {
            String workingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget);
            ShellStartupOptions startupOptions = ShellStartupOptionsKt.shellStartupOptions(workingDirectory);
            TerminalWidget newWidget = this.myTerminalRunner.startShellTerminalWidget((Disposable)container.getContent(), startupOptions, true);
            this.setupTerminalWidget(this.myToolWindow, newWidget, container.getContent());
            container.split(!vertically, newWidget);
        }
    }

    public void register(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(33);
        }
        this.myContainerByWidgetMap.put(terminalContainer.getTerminalWidget(), terminalContainer);
    }

    public void unregister(@NotNull TerminalContainer terminalContainer) {
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(34);
        }
        this.myContainerByWidgetMap.remove(terminalContainer.getTerminalWidget());
        if (terminalContainer.getContent().getUserData(TERMINAL_WIDGET_KEY) == terminalContainer.getTerminalWidget()) {
            terminalContainer.getContent().putUserData(TERMINAL_WIDGET_KEY, (Object)this.findWidgetForContent(terminalContainer.getContent()));
        }
    }

    @Nullable
    private TerminalWidget findWidgetForContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(35);
        }
        TerminalWidget any = null;
        for (Map.Entry<TerminalWidget, TerminalContainer> entry : this.myContainerByWidgetMap.entrySet()) {
            TerminalWidget terminalWidget;
            if (entry.getValue().getContent() != content) continue;
            any = terminalWidget = entry.getKey();
            if (!terminalWidget.hasFocus()) continue;
            return terminalWidget;
        }
        return any;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TerminalContainer getContainer(@NotNull JBTerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(36);
        }
        TerminalContainer terminalContainer = Objects.requireNonNull(this.getContainer(terminalWidget.asNewWidget()));
        if (terminalContainer == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(37);
        }
        return terminalContainer;
    }

    @Nullable
    public TerminalContainer getContainer(@NotNull TerminalWidget terminalWidget) {
        if (terminalWidget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(38);
        }
        return this.myContainerByWidgetMap.get(terminalWidget);
    }

    public void closeTab(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(39);
        }
        this.myToolWindow.getContentManager().removeContent(content, true, true, true);
    }

    @NotNull
    private static FocusListener createFocusListener(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(40);
        }
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component2 = TerminalToolWindowManager.getComponentToFocus(toolWindow);
                if (component2 != null) {
                    component2.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    @Nullable
    private static JComponent getComponentToFocus(@NotNull ToolWindow toolWindow) {
        Content selectedContent;
        if (toolWindow == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(41);
        }
        if ((selectedContent = toolWindow.getContentManager().getSelectedContent()) != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return toolWindow.getComponent();
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        VirtualFile parentDirectory;
        TerminalTabState state = new TerminalTabState();
        VirtualFile virtualFile = parentDirectory = fileToOpen != null && !fileToOpen.isDirectory() ? fileToOpen.getParent() : fileToOpen;
        if (parentDirectory != null) {
            state.myWorkingDirectory = parentDirectory.getPath();
        }
        this.createNewSession(this.myTerminalRunner, state);
    }

    @Nullable
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        TerminalWidget data;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(42);
        }
        return (data = (TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY)) != null ? JBTerminalWidget.asJediTermWidget((TerminalWidget)data) : null;
    }

    @Nullable
    public static TerminalWidget findWidgetByContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(43);
        }
        return (TerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY);
    }

    @Nullable
    public static AbstractTerminalRunner<?> getRunnerByContent(@NotNull Content content) {
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(44);
        }
        return (AbstractTerminalRunner)content.getUserData(RUNNER_KEY);
    }

    public void detachWidgetAndRemoveContent(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(45);
        }
        LOG.assertTrue((contentManager = this.myToolWindow.getContentManager()).getIndexOfContent(content) >= 0, (Object)"Not a terminal content");
        TerminalTabCloseListener.Companion.executeContentOperationSilently(content, (Function0<Unit>)((Function0)() -> {
            contentManager.removeContent(content, true);
            return Unit.INSTANCE;
        }));
        content.putUserData(TERMINAL_WIDGET_KEY, null);
    }

    public static boolean isInTerminalToolWindow(@NotNull JBTerminalWidget widget) {
        if (widget == null) {
            TerminalToolWindowManager.$$$reportNull$$$0(46);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getTerminalPanel());
        ToolWindow toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW);
        return TerminalToolWindowManager.isTerminalToolWindow(toolWindow);
    }

    public static boolean isTerminalToolWindow(@Nullable ToolWindow toolWindow) {
        return toolWindow != null && "Terminal".equals(toolWindow.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 12, 13, 16, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 46 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 27: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 25: 
            case 28: 
            case 35: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalTitle";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalContainer";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalRunner";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalWidgets";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalShellWidget";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewSession";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitToolWindow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalContent";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewTerminalSetupHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNewSession";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newTab";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createNewTab";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalContent";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setupTerminalWidget";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateTabTitle";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isSplitTerminal";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "gotoNextSplitTerminal";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetForContent";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createFocusListener";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getComponentToFocus";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetByContent";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetByContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerByContent";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "detachWidgetAndRemoveContent";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isInTerminalToolWindow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 12, 13, 16, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 46 -> new IllegalArgumentException(string);
        };
    }

    private final class TerminalDockContainer
    implements DockContainer {
        private TerminalDockContainer() {
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(TerminalToolWindowManager.this.myToolWindow.getComponent());
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(0);
            }
            DockContainer.ContentResponse contentResponse = TerminalDockContainer.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                TerminalDockContainer.$$$reportNull$$$0(1);
            }
            return contentResponse;
        }

        @NotNull
        public JComponent getContainerComponent() {
            JComponent jComponent = TerminalToolWindowManager.this.myToolWindow.getComponent();
            if (jComponent == null) {
                TerminalDockContainer.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(3);
            }
            if (TerminalDockContainer.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                String name = terminalFile.getName();
                Content newContent = TerminalToolWindowManager.this.newTab(TerminalToolWindowManager.this.myToolWindow, terminalFile.getTerminalWidget());
                newContent.setDisplayName(name);
            }
        }

        private static boolean isTerminalSessionContent(@NotNull DockableContent<?> content) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(4);
            }
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager$TerminalDockContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowManager$TerminalDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainerComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isTerminalSessionContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

