/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\t\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0002H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/BoundedIntEventField;", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "name", "", "bounds", "", "(Ljava/lang/String;[I)V", "getBounds", "()[I", "getName", "()Ljava/lang/String;", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nBaseEventFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseEventFields.kt\ncom/intellij/internal/statistic/eventLog/events/BoundedIntEventField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,494:1\n1747#2,3:495\n*S KotlinDebug\n*F\n+ 1 BaseEventFields.kt\ncom/intellij/internal/statistic/eventLog/events/BoundedIntEventField\n*L\n120#1:495,3\n*E\n"})
public final class BoundedIntEventField
extends PrimitiveEventField<Integer> {
    @NotNull
    private final String name;
    @NotNull
    private final int[] bounds;

    public BoundedIntEventField(@NotNull String name, @NotNull int[] bounds) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            this.name = name;
            this.bounds = bounds;
            if (this.bounds.length == 0) {
                throw new InvalidParameterException("Bounds array should not be empty");
            }
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)1, (int)this.bounds.length);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.bounds[it] <= this.bounds[it - 1])) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new InvalidParameterException("Bounds array should be sorted in ascending order and all values should be unique");
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final int[] getBounds() {
        return this.bounds;
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        return CollectionsKt.listOf((Object)"{regexp#integer}");
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, int value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        fuData.addData(this.getName(), StatisticsUtil.roundToUpperBoundInternal$intellij_platform_statistics(value, this.bounds));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final int[] component2() {
        return this.bounds;
    }

    @NotNull
    public final BoundedIntEventField copy(@NotNull String name, @NotNull int[] bounds) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return new BoundedIntEventField(name, bounds);
    }

    public static /* synthetic */ BoundedIntEventField copy$default(BoundedIntEventField boundedIntEventField, String string, int[] nArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = boundedIntEventField.name;
        }
        if ((n & 2) != 0) {
            nArray = boundedIntEventField.bounds;
        }
        return boundedIntEventField.copy(string, nArray);
    }

    @NotNull
    public String toString() {
        return "BoundedIntEventField(name=" + this.name + ", bounds=" + Arrays.toString(this.bounds) + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Arrays.hashCode(this.bounds);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BoundedIntEventField)) {
            return false;
        }
        BoundedIntEventField boundedIntEventField = (BoundedIntEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)boundedIntEventField.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bounds, (Object)boundedIntEventField.bounds);
    }
}

