/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.index.SchemaTypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLValidator;
import org.jetbrains.annotations.NotNull;

public final class XsdComplexTypeInfoBuilder
implements NanoXmlBuilder {
    private static final String SIGN = "";
    public static final String HTTP_WWW_W3_ORG_2001_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final MultiMap<SchemaTypeInfo, SchemaTypeInfo> myMap = new MultiMap();
    private NameSpaceHelper myNameSpaceHelper;
    private String myCurrentElementName;
    private String myCurrentComplexTypeName;
    private String myCurrentSimpleTypeName;
    private boolean myInsideSchema;
    private boolean myInsideRestriction;
    private boolean myInsideExtension;
    private boolean myInsideContent;

    public void setNameSpaceHelper(NameSpaceHelper nameSpaceHelper) {
        this.myNameSpaceHelper = nameSpaceHelper;
    }

    public static MultiMap<SchemaTypeInfo, SchemaTypeInfo> parse(InputStream is) {
        return XsdComplexTypeInfoBuilder.parse(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static MultiMap<SchemaTypeInfo, SchemaTypeInfo> parse(@NotNull Reader reader) {
        MultiMap<SchemaTypeInfo, SchemaTypeInfo> multiMap;
        block9: {
            if (reader == null) {
                XsdComplexTypeInfoBuilder.$$$reportNull$$$0(0);
            }
            Reader reader2 = reader;
            try {
                XsdComplexTypeInfoBuilder builder2 = new XsdComplexTypeInfoBuilder();
                NameSpaceHelper helper = new NameSpaceHelper();
                builder2.setNameSpaceHelper(helper);
                NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)builder2, (IXMLValidator)helper);
                multiMap = builder2.getMap();
                if (reader2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader2 != null) {
                        try {
                            reader2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader2.close();
        }
        return multiMap;
    }

    private XsdComplexTypeInfoBuilder() {
    }

    public MultiMap<SchemaTypeInfo, SchemaTypeInfo> getMap() {
        return this.myMap;
    }

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        if (!HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        this.myInsideSchema = false;
        if ("schema".equals(name)) {
            this.myInsideSchema = true;
        } else if ("complexType".equals(name)) {
            this.myCurrentComplexTypeName = SIGN;
        } else if ("simpleType".equals(name)) {
            this.myCurrentSimpleTypeName = SIGN;
        } else if ("element".equals(name)) {
            this.myCurrentElementName = SIGN;
        } else if ("restriction".equals(name)) {
            this.myInsideRestriction = true;
        } else if ("extension".equals(name)) {
            this.myInsideExtension = true;
        } else if ("simpleContent".equals(name) || "complexContent".equals(name)) {
            this.myInsideContent = true;
        }
    }

    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        if (!HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        if ("schema".equals(name)) {
            this.myInsideSchema = false;
        } else if ("complexType".equals(name)) {
            this.myCurrentComplexTypeName = null;
        } else if ("simpleType".equals(name)) {
            this.myCurrentSimpleTypeName = null;
        } else if ("element".equals(name)) {
            this.myCurrentElementName = null;
        } else if ("restriction".equals(name)) {
            this.myInsideRestriction = false;
        } else if ("extension".equals(name)) {
            this.myInsideExtension = false;
        } else if ("simpleContent".equals(name) || "complexContent".equals(name)) {
            this.myInsideContent = false;
        }
    }

    public void addAttribute(String key2, String nsPrefix, String nsURI, String value2, String type2) throws Exception {
        if (!StringUtil.isEmptyOrSpaces((String)nsURI) && !HTTP_WWW_W3_ORG_2001_XMLSCHEMA.equals(nsURI)) {
            return;
        }
        if ("base".equals(key2)) {
            if (this.myCurrentComplexTypeName != null && this.myInsideContent && (this.myInsideExtension || this.myInsideRestriction)) {
                this.putTypeDataToMap(value2, this.myCurrentComplexTypeName);
            } else if (this.myCurrentSimpleTypeName != null && this.myInsideRestriction) {
                this.putTypeDataToMap(value2, this.myCurrentSimpleTypeName);
            }
        } else if (!this.myInsideSchema && ("name".equals(key2) || "ref".equals(key2))) {
            if (SIGN.equals(this.myCurrentElementName) && !this.myInsideContent && !this.myInsideExtension && !this.myInsideRestriction && this.myCurrentComplexTypeName == null && this.myCurrentSimpleTypeName == null) {
                this.myCurrentElementName = value2;
            } else if (SIGN.equals(this.myCurrentComplexTypeName) && !this.myInsideContent && !this.myInsideExtension && !this.myInsideRestriction && this.myCurrentSimpleTypeName == null) {
                this.myCurrentComplexTypeName = value2;
            } else if (SIGN.equals(this.myCurrentSimpleTypeName) && !this.myInsideContent && !this.myInsideExtension && !this.myInsideRestriction && this.myCurrentComplexTypeName == null) {
                this.myCurrentSimpleTypeName = value2;
            }
        }
    }

    private void putTypeDataToMap(String value2, String typeName) {
        boolean isAnonymous = SIGN.equals(typeName);
        if (isAnonymous && this.myCurrentElementName != null) {
            this.myMap.putValue((Object)this.createSchemaTypeInfo(value2, true), (Object)this.createSchemaTypeInfo(this.myCurrentElementName, false));
        } else {
            this.myMap.putValue((Object)this.createSchemaTypeInfo(value2, true), (Object)this.createSchemaTypeInfo(typeName, true));
        }
    }

    private SchemaTypeInfo createSchemaTypeInfo(String value2, boolean isType) {
        int separatorIdx = value2.indexOf(58);
        String ns = separatorIdx <= 0 ? SIGN : value2.substring(0, separatorIdx);
        String element = separatorIdx <= 0 ? value2 : value2.substring(separatorIdx + 1);
        String nsUri = this.myNameSpaceHelper.getNamespaces().get(ns);
        nsUri = nsUri == null ? ns : nsUri;
        return new SchemaTypeInfo(element, isType, nsUri);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/xml/index/XsdComplexTypeInfoBuilder", "parse"));
    }

    private static final class NameSpaceHelper
    extends NanoXmlUtil.EmptyValidator {
        public static final String XMLNS = "xmlns";
        public static final String XMLNS_ = "xmlns:";
        private boolean myInSchema;
        private final Map<String, String> myNamespaces = new HashMap<String, String>();

        private NameSpaceHelper() {
        }

        public void attributeAdded(String key2, String value2, String systemId, int lineNr) {
            super.attributeAdded(key2, value2, systemId, lineNr);
            if (this.myInSchema && key2.startsWith(XMLNS)) {
                if (key2.length() == XMLNS.length()) {
                    this.myNamespaces.put(XsdComplexTypeInfoBuilder.SIGN, value2);
                } else if (key2.startsWith(XMLNS_)) {
                    String prefix = key2.substring(XMLNS_.length());
                    this.myNamespaces.put(prefix, value2);
                }
            }
        }

        public void elementStarted(String name, String systemId, int lineNr) {
            super.elementStarted(name, systemId, lineNr);
            this.myInSchema = "schema".equals(name) || name.endsWith(":schema");
        }

        public Map<String, String> getNamespaces() {
            return this.myNamespaces;
        }
    }
}

