/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes;

import com.intellij.util.text.SemVer;
import com.intellij.webSymbols.webTypes.WebTypesVersionsRegistry;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J/\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J#\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eR&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR)\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\r0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry;", "T", "", "()V", "myVersions", "Ljava/util/SortedMap;", "", "Lcom/intellij/util/text/SemVer;", "packages", "", "getPackages", "()Ljava/util/Set;", "versions", "", "getVersions", "()Ljava/util/Map;", "equals", "", "other", "get", "pkgVersion", "(Ljava/util/SortedMap;Lcom/intellij/util/text/SemVer;)Ljava/lang/Object;", "packageName", "packageVersion", "(Ljava/lang/String;Lcom/intellij/util/text/SemVer;)Ljava/lang/Object;", "hashCode", "", "put", "", "value", "(Ljava/lang/String;Lcom/intellij/util/text/SemVer;Ljava/lang/Object;)V", "Companion", "intellij.platform.webSymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebTypesLoadUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesLoadUtil.kt\ncom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class WebTypesVersionsRegistry<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SortedMap<String, SortedMap<SemVer, T>> myVersions = new TreeMap();
    @NotNull
    private static final Regex LETTERS_PATTERN = new Regex("[a-zA-Z]");
    @NotNull
    private static final Regex NON_LETTERS_PATTERN = new Regex("^[^a-zA-Z]+$");

    @NotNull
    public final Set<String> getPackages() {
        Set<String> set = this.myVersions.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public final Map<String, Map<SemVer, T>> getVersions() {
        return this.myVersions;
    }

    public final void put(@NotNull String packageName, @NotNull SemVer packageVersion, T value2) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)packageVersion, (String)"packageVersion");
        SortedMap sortedMap = this.myVersions.computeIfAbsent(packageName, arg_0 -> WebTypesVersionsRegistry.put$lambda$0(put.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"computeIfAbsent(...)");
        ((Map)sortedMap).put(packageVersion, value2);
    }

    @Nullable
    public final T get(@NotNull String packageName, @Nullable SemVer packageVersion) {
        T t;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        SortedMap sortedMap = (SortedMap)this.myVersions.get(packageName);
        if (sortedMap != null) {
            SortedMap it = sortedMap;
            boolean bl = false;
            t = this.get(it, packageVersion);
        } else {
            t = null;
        }
        return t;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final T get(SortedMap<SemVer, T> versions, SemVer pkgVersion) {
        block15: {
            block14: {
                var3_3 = versions;
                if (var3_3 == null || var3_3.isEmpty() != false) {
                    return null;
                }
                webTypesVersionEntry = null;
                if (pkgVersion == null) {
                    block12: {
                        v0 = versions.entrySet();
                        Intrinsics.checkNotNullExpressionValue(v0, (String)"<get-entries>(...)");
                        var8_4 = v0;
                        var9_5 /* !! */  = var8_4.iterator();
                        while (var9_5 /* !! */ .hasNext()) {
                            var10_6 = var9_5 /* !! */ .next();
                            it = (Map.Entry)var10_6;
                            $i$a$-find-WebTypesVersionsRegistry$get$webTypesVersionEntry$1 = false;
                            if (!(((SemVer)it.getKey()).getPreRelease() == null)) continue;
                            v1 = var10_6;
                            break block12;
                        }
                        v1 = null;
                    }
                    if ((v2 = (Map.Entry)v1) == null) {
                        v3 = versions.entrySet();
                        Intrinsics.checkNotNullExpressionValue(v3, (String)"<get-entries>(...)");
                        v2 = (Map.Entry)CollectionsKt.firstOrNull((Iterable)v3);
                    }
                } else {
                    block13: {
                        v4 = versions.entrySet();
                        Intrinsics.checkNotNullExpressionValue(v4, (String)"<get-entries>(...)");
                        var7_11 = v4;
                        var8_4 = var7_11.iterator();
                        while (var8_4.hasNext()) {
                            var9_5 /* !! */  = var8_4.next();
                            it = (Map.Entry)var9_5 /* !! */ ;
                            $i$a$-find-WebTypesVersionsRegistry$get$webTypesVersionEntry$2 = false;
                            if (!(((SemVer)it.getKey()).compareTo(pkgVersion) <= 0)) continue;
                            v5 /* !! */  = var9_5 /* !! */ ;
                            break block13;
                        }
                        v5 /* !! */  = null;
                    }
                    v2 = (Map.Entry)v5 /* !! */ ;
                }
                if (v2 == null) {
                    return null;
                }
                webTypesVersionEntry = v2;
                v6 = ((SemVer)webTypesVersionEntry.getKey()).getPreRelease();
                v7 = v6 != null ? WebTypesVersionsRegistry.LETTERS_PATTERN.containsMatchIn(var5_13 = (CharSequence)v6) : false;
                if (!v7) break block15;
                v8 = versions.entrySet();
                Intrinsics.checkNotNullExpressionValue(v8, (String)"<get-entries>(...)");
                var6_14 = v8;
                for (Object var8_4 : var6_14) {
                    it = (Map.Entry)var8_4;
                    $i$a$-find-WebTypesVersionsRegistry$get$2 = false;
                    if (((SemVer)it.getKey()).getMajor() != ((SemVer)webTypesVersionEntry.getKey()).getMajor() || ((SemVer)it.getKey()).getMinor() != ((SemVer)webTypesVersionEntry.getKey()).getMinor() || ((SemVer)it.getKey()).getPatch() != ((SemVer)webTypesVersionEntry.getKey()).getPatch()) ** GOTO lbl-1000
                    v9 = var11_8 = ((SemVer)it.getKey()).getPreRelease();
                    if (v9 != null) {
                        Intrinsics.checkNotNull((Object)v9);
                        v10 = WebTypesVersionsRegistry.NON_LETTERS_PATTERN.containsMatchIn((CharSequence)var11_8);
                    } else {
                        v10 = false;
                    }
                    if (v10) {
                        v11 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v11 = false;
                    }
                    if (!v11) continue;
                    v12 = var8_4;
                    break block14;
                }
                v12 = null;
            }
            var4_15 = (Map.Entry)v12;
            if (var4_15 == null) break block15;
            it = var4_15;
            $i$a$-let-WebTypesVersionsRegistry$get$3 = false;
            webTypesVersionEntry = it;
        }
        return (T)webTypesVersionEntry.getValue();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof WebTypesVersionsRegistry && Intrinsics.areEqual(((WebTypesVersionsRegistry)other).myVersions, this.myVersions);
    }

    public int hashCode() {
        return this.myVersions.hashCode();
    }

    private static final SortedMap put$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SortedMap)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/webSymbols/webTypes/WebTypesVersionsRegistry$Companion;", "", "()V", "LETTERS_PATTERN", "Lkotlin/text/Regex;", "NON_LETTERS_PATTERN", "intellij.platform.webSymbols"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

