/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.actions.TwoStepCompletionProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class VcsRefCompletionProvider
extends TwoStepCompletionProvider<VcsRef> {
    @NotNull
    private final VcsLogRefs myRefs;
    @NotNull
    private final Set<VirtualFile> myRoots;

    public VcsRefCompletionProvider(@NotNull VcsLogRefs refs, @NotNull Collection<? extends VirtualFile> roots, @NotNull TextCompletionValueDescriptor<VcsRef> descriptor) {
        if (refs == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(2);
        }
        super(descriptor);
        this.myRefs = refs;
        this.myRoots = new HashSet<VirtualFile>(roots);
    }

    @Override
    @NotNull
    protected Stream<? extends VcsRef> collectSync(@NotNull CompletionResultSet result2) {
        if (result2 == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(3);
        }
        return this.filterAndSort(result2, this.myRefs.getBranches().stream());
    }

    @Override
    @NotNull
    protected Stream<? extends VcsRef> collectAsync(@NotNull CompletionResultSet result2) {
        if (result2 == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(4);
        }
        return this.filterAndSort(result2, this.myRefs.stream().filter(ref -> !ref.getType().isBranch()));
    }

    @NotNull
    private Stream<VcsRef> filterAndSort(@NotNull CompletionResultSet result2, @NotNull Stream<VcsRef> stream) {
        if (result2 == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(5);
        }
        if (stream == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(6);
        }
        Stream<VcsRef> matched = stream.filter(ref -> this.myRoots.contains(ref.getRoot()) && result2.getPrefixMatcher().prefixMatches(ref.getName()));
        Stream<VcsRef> stream2 = this.filterRefs(matched);
        if (stream2 == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(7);
        }
        return stream2;
    }

    @NotNull
    protected Stream<VcsRef> filterRefs(@NotNull Stream<VcsRef> vcsRefs) {
        if (vcsRefs == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(8);
        }
        Stream<VcsRef> stream = vcsRefs;
        if (stream == null) {
            VcsRefCompletionProvider.$$$reportNull$$$0(9);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/VcsRefCompletionProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/VcsRefCompletionProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAndSort";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSync";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAsync";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterAndSort";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterRefs";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 9 -> new IllegalStateException(string2);
        };
    }
}

