/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogIndexUtils;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowOtherBranchesAction
extends BooleanPropertyToggleAction {
    public ShowOtherBranchesAction() {
        super(VcsLogBundle.messagePointer("vcs.log.action.show.all.branches", new Object[0]), VcsLogBundle.messagePointer("vcs.log.action.description.show.all.branches", new Object[0]), AllIcons.Vcs.Branch);
    }

    @Override
    protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
        return FileHistoryUiProperties.SHOW_ALL_BRANCHES;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowOtherBranchesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (!e.getPresentation().isEnabled()) {
            return;
        }
        if (!Registry.is((String)"vcs.history.use.index")) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, null);
            return;
        }
        Project project2 = e.getProject();
        VcsLogManager logManager2 = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        VcsLogUi logUi2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        Set roots = (Set)e.getData(VcsLogInternalDataKeys.VCS_LOG_VISIBLE_ROOTS);
        if (project2 != null && logManager2 != null && logUi2 != null && roots != null && roots.size() == 1) {
            VirtualFile root;
            VcsLogIndex index = logManager2.getDataManager().getIndex();
            if (!index.isIndexed(root = (VirtualFile)ContainerUtil.getOnlyItem((Collection)roots))) {
                e.getPresentation().setEnabled(false);
            }
            HelpTooltip helpTooltip = this.getHelpTooltip(e.getPresentation(), logManager2.getDataManager(), root);
            e.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, (Object)helpTooltip);
        } else {
            e.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, null);
        }
    }

    @Nullable
    private HelpTooltip getHelpTooltip(@NotNull Presentation presentation2, @NotNull VcsLogData vcsLogData, @NotNull VirtualFile root) {
        if (presentation2 == null) {
            ShowOtherBranchesAction.$$$reportNull$$$0(1);
        }
        if (vcsLogData == null) {
            ShowOtherBranchesAction.$$$reportNull$$$0(2);
        }
        if (root == null) {
            ShowOtherBranchesAction.$$$reportNull$$$0(3);
        }
        if (presentation2.isEnabled()) {
            return null;
        }
        if (VcsLogData.isIndexSwitchedOnInRegistry() && !VcsLogIndexUtils.isIndexingPausedFor(root)) {
            return null;
        }
        HelpTooltip previousTooltip = (HelpTooltip)presentation2.getClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP);
        if (previousTooltip != null) {
            return previousTooltip;
        }
        HelpTooltip tooltip2 = new HelpTooltip();
        tooltip2.setTitle(presentation2.getText());
        tooltip2.setShortcut(KeymapUtil.getFirstKeyboardShortcutText((AnAction)this));
        tooltip2.setDescription(VcsLogBundle.message("action.help.tooltip.show.all.branches", new Object[0]));
        String vcsDisplayName = VcsLogUtil.getVcsDisplayName(vcsLogData.getProject(), Collections.singleton(vcsLogData.getLogProvider(root)));
        tooltip2.setLink(VcsLogBundle.message("action.help.tooltip.link.show.all.branches", vcsDisplayName, root.getPresentableName()), () -> VcsLogIndexUtils.enableAndResumeIndexing(vcsLogData, Collections.singleton(root)));
        return tooltip2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsLogData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/ShowOtherBranchesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelpTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

