/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tR\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryDiffProcessor;", "Lcom/intellij/diff/impl/CacheDiffRequestProcessor$Simple;", "Lcom/intellij/openapi/vcs/changes/DiffPreviewUpdateProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "changeGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/vcs/changes/Change;", "isInEditor", "", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;ZLcom/intellij/openapi/Disposable;)V", "clear", "", "getCurrentRequestProvider", "Lcom/intellij/diff/chains/DiffRequestProducer;", "getFastLoadingTimeMillis", "", "refresh", "fromModelRefresh", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "updatePreview", "state", "intellij.platform.vcs.log.impl"})
public final class FileHistoryDiffProcessor
extends CacheDiffRequestProcessor.Simple
implements DiffPreviewUpdateProcessor {
    @NotNull
    private final Function0<Change> changeGetter;
    private final boolean isInEditor;

    public FileHistoryDiffProcessor(@NotNull Project project2, @NotNull Function0<? extends Change> changeGetter, boolean isInEditor, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(changeGetter, (String)"changeGetter");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(project2, isInEditor ? "Default" : "VcsFileHistoryView");
        this.changeGetter = changeGetter;
        this.isInEditor = isInEditor;
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)this));
    }

    public final void updatePreview(boolean state) {
        if (state) {
            this.refresh(false);
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, false, null);
    }

    @Override
    public void refresh(boolean fromModelRefresh) {
        this.updateRequest();
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    protected int getFastLoadingTimeMillis() {
        return 10;
    }

    @Nullable
    protected DiffRequestProducer getCurrentRequestProvider() {
        Change change = (Change)this.changeGetter.invoke();
        if (change == null) {
            return null;
        }
        Change change2 = change;
        Project project2 = this.getProject();
        Intrinsics.checkNotNull((Object)project2);
        return VcsLogChangesBrowser.Companion.createDiffRequestProducer(project2, change2, new HashMap(), true);
    }
}

