/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomElementsProblemsHolderImpl
implements DomElementsProblemsHolder {
    private final Map<DomElement, Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>>> myCachedErrors = new ConcurrentHashMap();
    private final Map<DomElement, Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>>> myCachedChildrenErrors = new ConcurrentHashMap();
    private final List<Annotation> myAnnotations = new ArrayList<Annotation>();
    private final Function<DomElement, List<DomElementProblemDescriptor>> myDomProblemsGetter = s -> {
        Map<Class<DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map2 = this.myCachedErrors.get(s);
        return map2 == null ? Collections.emptyList() : ContainerUtil.concat(map2.values());
    };
    private final DomFileElement myElement;
    private final Set<Class<? extends DomElementsInspection>> myPassedInspections = new HashSet<Class<? extends DomElementsInspection>>();

    public DomElementsProblemsHolderImpl(DomFileElement element) {
        this.myElement = element;
    }

    public void appendProblems(DomElementAnnotationHolderImpl holder, Class<? extends DomElementsInspection<?>> inspectionClass) {
        if (this.isInspectionCompleted(inspectionClass)) {
            return;
        }
        for (DomElementProblemDescriptor descriptor : holder) {
            this.addProblem(descriptor, inspectionClass);
        }
        this.myAnnotations.addAll((Collection<Annotation>)holder.getAnnotations());
        this.myPassedInspections.add(inspectionClass);
    }

    @Override
    public boolean isInspectionCompleted(@NotNull DomElementsInspection inspection) {
        if (inspection == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(0);
        }
        return this.isInspectionCompleted(((Object)((Object)inspection)).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInspectionCompleted(Class<? extends DomElementsInspection> inspectionClass) {
        Object object = DomElementAnnotationsManagerImpl.LOCK;
        synchronized (object) {
            return this.myPassedInspections.contains(inspectionClass);
        }
    }

    public List<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public void addProblem(DomElementProblemDescriptor descriptor, Class<? extends DomElementsInspection<?>> inspection) {
        this.myCachedErrors.computeIfAbsent(descriptor.getDomElement(), __ -> new ConcurrentHashMap()).computeIfAbsent(inspection, __ -> new SmartList()).add(descriptor);
        this.myCachedChildrenErrors.clear();
    }

    @Override
    @NotNull
    public synchronized List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
        if (domElement == null || !domElement.isValid()) {
            List<DomElementProblemDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                DomElementsProblemsHolderImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<DomElementProblemDescriptor> list3 = this.myDomProblemsGetter.apply(domElement);
        if (list3 == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @Override
    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
        if (!withChildren || domElement == null || !domElement.isValid()) {
            return this.getProblems(domElement);
        }
        return ContainerUtil.concat(this.getProblemsMap(domElement).values());
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren, HighlightSeverity minSeverity) {
        return this.getProblems(domElement, withChildren, minSeverity);
    }

    @Override
    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
        return ContainerUtil.findAll(this.getProblems(domElement, true, withChildren), object -> SeverityRegistrar.getSeverityRegistrar((Project)domElement.getManager().getProject()).compare(object.getHighlightSeverity(), minSeverity) >= 0);
    }

    @NotNull
    private Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> getProblemsMap(DomElement domElement) {
        Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map2 = this.myCachedChildrenErrors.get(domElement);
        if (map2 != null) {
            Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map3 = map2;
            if (map3 == null) {
                DomElementsProblemsHolderImpl.$$$reportNull$$$0(3);
            }
            return map3;
        }
        final HashMap problems = new HashMap();
        if (domElement == this.myElement) {
            for (Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map4 : this.myCachedErrors.values()) {
                DomElementsProblemsHolderImpl.mergeMaps(problems, map4);
            }
        } else {
            DomElementsProblemsHolderImpl.mergeMaps(problems, this.myCachedErrors.get(domElement));
            if (DomUtil.hasXml(domElement)) {
                domElement.acceptChildren(new DomElementVisitor(){

                    @Override
                    public void visitDomElement(DomElement element) {
                        DomElementsProblemsHolderImpl.mergeMaps(problems, DomElementsProblemsHolderImpl.this.getProblemsMap(element));
                    }
                });
            }
        }
        this.myCachedChildrenErrors.put(domElement, problems);
        HashMap hashMap = problems;
        if (hashMap == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static <T> void mergeMaps(@NotNull Map<T, List<DomElementProblemDescriptor>> accumulator, @Nullable Map<T, List<DomElementProblemDescriptor>> toAdd) {
        if (accumulator == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(5);
        }
        if (toAdd == null) {
            return;
        }
        for (Map.Entry<T, List<DomElementProblemDescriptor>> entry2 : toAdd.entrySet()) {
            accumulator.computeIfAbsent(entry2.getKey(), __ -> new SmartList()).addAll((Collection)entry2.getValue());
        }
    }

    @Override
    public List<DomElementProblemDescriptor> getAllProblems() {
        return this.getProblems((DomElement)this.myElement, false, true);
    }

    @Override
    public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
        if (inspection == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(6);
        }
        if (!this.myElement.isValid()) {
            return Collections.emptyList();
        }
        List<DomElementProblemDescriptor> list2 = this.getProblemsMap(this.myElement).get(((Object)((Object)inspection)).getClass());
        return list2 != null ? new ArrayList<DomElementProblemDescriptor>(list2) : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementsProblemsHolderImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementsProblemsHolderImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInspectionCompleted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeMaps";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllProblems";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

