/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalTrackerDiffUtil;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.LineStatusClientIdTrackerKt;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final LocalChangeListDiffRequest myLocalRequest;
    private final boolean myAllowExcludeChangesFromCommit;
    private final LocalTrackerDiffUtil.LocalTrackerActionProvider myTrackerActionProvider;
    private final LocalTrackerDiffUtil.ExcludeAllCheckboxPanel myExcludeAllCheckboxPanel;
    private final GutterCheckboxMouseMotionListener myGutterCheckboxMouseMotionListener;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (DiffRequest)localRequest.getRequest());
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myLocalRequest = localRequest;
        this.myAllowExcludeChangesFromCommit = DiffUtil.isUserDataFlagSet(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (UserDataHolder[])new UserDataHolder[]{context});
        this.myTrackerActionProvider = new MyLocalTrackerActionProvider(this, localRequest, this.myAllowExcludeChangesFromCommit);
        this.myExcludeAllCheckboxPanel = new LocalTrackerDiffUtil.ExcludeAllCheckboxPanel((DiffViewerBase)this, this.getEditor2());
        this.myExcludeAllCheckboxPanel.init(this.myLocalRequest, this.myAllowExcludeChangesFromCommit);
        LocalTrackerDiffUtil.installTrackerListener((DiffViewerBase)this, this.myLocalRequest);
        this.myGutterCheckboxMouseMotionListener = new GutterCheckboxMouseMotionListener();
        this.myGutterCheckboxMouseMotionListener.install();
        for (AnAction action2 : LocalTrackerDiffUtil.createTrackerShortcutOnlyActions(this.myTrackerActionProvider)) {
            DiffUtil.registerAction((AnAction)action2, (JComponent)this.myPanel);
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        List titles = DiffUtil.createTextTitles((FrameDiffTool.DiffViewer)this, (ContentDiffRequest)this.myRequest, (List)this.getEditors());
        assert (titles.size() == 2);
        BorderLayoutPanel titleWithCheckbox = JBUI.Panels.simplePanel();
        if (titles.get(1) != null) {
            titleWithCheckbox.addToCenter((Component)titles.get(1));
        }
        titleWithCheckbox.addToLeft((Component)this.myExcludeAllCheckboxPanel);
        List<JComponent> list2 = Arrays.asList((JComponent)titles.get(0), titleWithCheckbox);
        if (list2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group2 = new ArrayList<AnAction>(super.createEditorPopupActions());
        group2.addAll(LocalTrackerDiffUtil.createTrackerEditorPopupActions(this.myTrackerActionProvider));
        ArrayList<AnAction> arrayList = group2;
        if (arrayList == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected SimpleDiffChangeUi createUi(@NotNull SimpleDiffChange change) {
        if (change == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(4);
        }
        if (change instanceof MySimpleDiffChange) {
            return new MySimpleDiffChangeUi(this, (MySimpleDiffChange)change);
        }
        SimpleDiffChangeUi simpleDiffChangeUi = super.createUi(change);
        if (simpleDiffChangeUi == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(5);
        }
        return simpleDiffChangeUi;
    }

    @Nullable
    @Nls
    protected String getStatusTextMessage() {
        if (this.myAllowExcludeChangesFromCommit) {
            int totalCount = 0;
            int includedIntoCommitCount = 0;
            int excludedCount = 0;
            for (SimpleDiffChange change : this.getDiffChanges()) {
                RangeExclusionState.Included exclusionState;
                if (change instanceof MySimpleDiffChange) {
                    MySimpleDiffChange myChange = (MySimpleDiffChange)change;
                    exclusionState = myChange.getExclusionState();
                } else {
                    exclusionState = RangeExclusionState.Included.INSTANCE;
                }
                totalCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)false);
                if (change.isSkipped()) {
                    excludedCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)false);
                    continue;
                }
                includedIntoCommitCount += DocumentTrackerKt.countAffectedVisibleChanges((RangeExclusionState)exclusionState, (boolean)true);
            }
            return LocalTrackerDiffUtil.getStatusText(totalCount, includedIntoCommitCount, excludedCount, this.myModel.isContentsEqual());
        }
        return super.getStatusTextMessage();
    }

    @NotNull
    private Runnable superComputeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(6);
        }
        Runnable runnable = super.computeDifferences(indicator);
        if (runnable == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(8);
        }
        Runnable runnable = LocalTrackerDiffUtil.computeDifferences(this.myLocalRequest.getLineStatusTracker(), this.getContent1().getDocument(), this.getContent2().getDocument(), this.myLocalRequest.getChangelistId(), this.myAllowExcludeChangesFromCommit, this.myTextDiffProvider, indicator, new MyLocalTrackerDiffHandler(indicator));
        if (runnable == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(9);
        }
        return runnable;
    }

    protected void onAfterRediff() {
        super.onAfterRediff();
        this.myExcludeAllCheckboxPanel.refresh();
    }

    protected void clearDiffPresentation() {
        super.clearDiffPresentation();
        for (RangeHighlighter operation : this.myHighlighters) {
            operation.dispose();
        }
        this.myHighlighters.clear();
        this.myGutterCheckboxMouseMotionListener.destroyHoverHighlighter();
    }

    @NotNull
    private Runnable applyGutterOperations(@NotNull List<LocalTrackerDiffUtil.ToggleableLineRange> toggleableLineRanges) {
        if (toggleableLineRanges == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(10);
        }
        Runnable runnable = () -> {
            if (this.myAllowExcludeChangesFromCommit) {
                for (LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange : toggleableLineRanges) {
                    this.myHighlighters.addAll(this.createGutterToggleRenderers(toggleableLineRange));
                }
            }
            for (LocalTrackerDiffUtil.ToggleableLineRange range : toggleableLineRanges) {
                ContainerUtil.addIfNotNull(this.myHighlighters, (Object)this.createClientIdHighlighter(range));
            }
            if (!this.myHighlighters.isEmpty()) {
                this.getEditor1().getGutterComponentEx().revalidateMarkup();
                this.getEditor2().getGutterComponentEx().revalidateMarkup();
            }
        };
        if (runnable == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    private List<RangeHighlighter> createGutterToggleRenderers(@NotNull LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        LocalTrackerDiffUtil.LineFragmentData fragmentData;
        if (toggleableLineRange == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(12);
        }
        if (!(fragmentData = toggleableLineRange.getFragmentData()).isFromActiveChangelist()) {
            List<RangeHighlighter> list2 = Collections.emptyList();
            if (list2 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(13);
            }
            return list2;
        }
        ArrayList<RangeHighlighter> result2 = new ArrayList<RangeHighlighter>();
        RangeExclusionState exclusionState = fragmentData.getExclusionState();
        if (fragmentData.isPartiallyExcluded()) {
            RangeExclusionState.Partial partialExclusionState = (RangeExclusionState.Partial)exclusionState;
            Range lineRange = toggleableLineRange.getLineRange();
            partialExclusionState.iterateDeletionOffsets((start2, end, isIncluded) -> {
                for (int i = start2.intValue(); i < end; ++i) {
                    result2.add(this.createLineCheckboxToggleHighlighter(i + lineRange.start1, Side.LEFT, isIncluded == false));
                }
                return null;
            });
            partialExclusionState.iterateAdditionOffsets((start2, end, isIncluded) -> {
                for (int i = start2.intValue(); i < end; ++i) {
                    result2.add(this.createLineCheckboxToggleHighlighter(i + lineRange.start2, Side.RIGHT, isIncluded == false));
                }
                return null;
            });
        } else {
            result2.add(this.createBlockCheckboxToggleHighlighter(toggleableLineRange));
        }
        if (LocalTrackerDiffUtil.shouldShowToggleAreaThumb(toggleableLineRange)) {
            result2.add(this.createToggleAreaThumb(toggleableLineRange, Side.LEFT));
            result2.add(this.createToggleAreaThumb(toggleableLineRange, Side.RIGHT));
        }
        ArrayList<RangeHighlighter> arrayList = result2;
        if (arrayList == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private RangeHighlighter createBlockCheckboxToggleHighlighter(@NotNull LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange) {
        if (toggleableLineRange == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(15);
        }
        Side side = Side.RIGHT;
        int line = LocalTrackerDiffUtil.getSingleCheckBoxLine(toggleableLineRange, side);
        boolean isExcludedFromCommit = toggleableLineRange.getFragmentData().getExclusionState() instanceof RangeExclusionState.Excluded;
        RangeHighlighter rangeHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(this.getEditor(side), line, isExcludedFromCommit, () -> LocalTrackerDiffUtil.toggleBlockExclusion(this.myTrackerActionProvider, line, isExcludedFromCommit));
        if (rangeHighlighter == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(16);
        }
        return rangeHighlighter;
    }

    @NotNull
    private RangeHighlighter createLineCheckboxToggleHighlighter(int line, @NotNull Side side, boolean isExcludedFromCommit) {
        if (side == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(17);
        }
        RangeHighlighter rangeHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(this.getEditor(side), line, isExcludedFromCommit, () -> LocalTrackerDiffUtil.toggleLinePartialExclusion(this.myTrackerActionProvider, line, side, isExcludedFromCommit));
        if (rangeHighlighter == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(18);
        }
        return rangeHighlighter;
    }

    @NotNull
    private RangeHighlighter createToggleAreaThumb(@NotNull LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange, @NotNull Side side) {
        if (toggleableLineRange == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(19);
        }
        if (side == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(20);
        }
        EditorEx editor = this.getEditor(side);
        Range lineRange = toggleableLineRange.getLineRange();
        int line1 = side.select(lineRange.start1, lineRange.start2);
        int line2 = side.select(lineRange.end1, lineRange.end2);
        boolean isExcludedFromCommit = toggleableLineRange.getFragmentData().getExclusionState() instanceof RangeExclusionState.Excluded;
        RangeHighlighter rangeHighlighter = LocalTrackerDiffUtil.createToggleAreaThumb(editor, line1, line2, () -> LocalTrackerDiffUtil.toggleBlockExclusion(this.myTrackerActionProvider, lineRange.start1, isExcludedFromCommit));
        if (rangeHighlighter == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(21);
        }
        return rangeHighlighter;
    }

    @Nullable
    private RangeHighlighter createClientIdHighlighter(@NotNull LocalTrackerDiffUtil.ToggleableLineRange range) {
        List<ClientId> clientIds;
        if (range == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(22);
        }
        if ((clientIds = range.getFragmentData().getClientIds()).isEmpty()) {
            return null;
        }
        GutterIconRenderer iconRenderer = LineStatusClientIdTrackerKt.createClientIdGutterIconRenderer(this.myLocalRequest.getProject(), clientIds);
        if (iconRenderer == null) {
            return null;
        }
        Range lineRange = range.getLineRange();
        Side side = Side.fromLeft((lineRange.start2 == lineRange.end2 ? 1 : 0) != 0);
        int line1 = side.select(lineRange.start1, lineRange.start2);
        int line2 = side.select(lineRange.end1, lineRange.end2);
        EditorEx editor = this.getEditor(side);
        TextRange textRange = DiffUtil.getLinesRange((Document)editor.getDocument(), (int)line1, (int)line2);
        return editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.LINES_IN_RANGE, false, rangeHighlighterEx -> {
            rangeHighlighterEx.setGreedyToLeft(true);
            rangeHighlighterEx.setGreedyToRight(true);
            rangeHighlighterEx.setGutterIconRenderer(iconRenderer);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 7, 9, 11, 13, 14, 16, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toggleableLineRanges";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toggleableLineRange";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "superComputeDifferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGutterOperations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createGutterToggleRenderers";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockCheckboxToggleHighlighter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineCheckboxToggleHighlighter";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleAreaThumb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "superComputeDifferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyGutterOperations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createGutterToggleRenderers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCheckboxToggleHighlighter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLineCheckboxToggleHighlighter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createToggleAreaThumb";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createClientIdHighlighter";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 5, 7, 9, 11, 13, 14, 16, 18, 21 -> new IllegalStateException(string2);
        };
    }

    private static final class MyLocalTrackerActionProvider
    extends LocalTrackerDiffUtil.LocalTrackerActionProvider {
        @NotNull
        private final SimpleLocalChangeListDiffViewer myViewer;

        private MyLocalTrackerActionProvider(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull LocalChangeListDiffRequest localRequest, boolean allowExcludeChangesFromCommit) {
            if (viewer == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(0);
            }
            if (localRequest == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(1);
            }
            super((DiffViewerBase)viewer, localRequest, allowExcludeChangesFromCommit);
            this.myViewer = viewer;
        }

        @Override
        @Nullable
        public List<LocalTrackerDiffUtil.LocalTrackerChange> getSelectedTrackerChanges(@NotNull AnActionEvent e) {
            if (e == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(2);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)this.myViewer.getEditors(), (Object)editor);
            if (side == null) {
                return null;
            }
            return StreamEx.of((Collection)this.myViewer.getSelectedChanges(side)).select(MySimpleDiffChange.class).map(it -> new LocalTrackerDiffUtil.LocalTrackerChange(it.getStartLine(Side.RIGHT), it.getEndLine(Side.RIGHT), it.getChangelistId(), it.getExclusionState())).toList();
        }

        @Override
        @Nullable
        public LocalTrackerDiffUtil.SelectedTrackerLine getSelectedTrackerLines(@NotNull AnActionEvent e) {
            if (e == null) {
                MyLocalTrackerActionProvider.$$$reportNull$$$0(3);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromValue((List)this.myViewer.getEditors(), (Object)editor);
            if (editor == null || side == null) {
                return null;
            }
            BitSet selectedLines = DiffUtil.getSelectedLines((Editor)editor);
            if (side.isLeft()) {
                return new LocalTrackerDiffUtil.SelectedTrackerLine(selectedLines, null);
            }
            return new LocalTrackerDiffUtil.SelectedTrackerLine(null, selectedLines);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localRequest";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerActionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedTrackerChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedTrackerLines";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GutterCheckboxMouseMotionListener {
        @Nullable
        private RangeHighlighter myHighlighter;

        private GutterCheckboxMouseMotionListener() {
        }

        public void install() {
            for (Side side : Side.values()) {
                MyGutterMouseListener listener2 = new MyGutterMouseListener(side);
                SimpleLocalChangeListDiffViewer.this.getEditor(side).getGutterComponentEx().addMouseListener((MouseListener)listener2);
                SimpleLocalChangeListDiffViewer.this.getEditor(side).getGutterComponentEx().addMouseMotionListener((MouseMotionListener)listener2);
            }
        }

        public void destroyHoverHighlighter() {
            if (this.myHighlighter != null) {
                this.myHighlighter.dispose();
                this.myHighlighter = null;
            }
        }

        private void updateHoverHighlighter(@NotNull Side side, int line) {
            MySimpleDiffChange change;
            if (side == null) {
                GutterCheckboxMouseMotionListener.$$$reportNull$$$0(0);
            }
            if ((change = (MySimpleDiffChange)((Object)ObjectUtils.tryCast((Object)ContainerUtil.find((Iterable)SimpleLocalChangeListDiffViewer.this.getDiffChanges(), it -> it.getStartLine(side) <= line && it.getEndLine(side) > line), MySimpleDiffChange.class))) == null || change.isPartiallyExcluded() || !SimpleLocalChangeListDiffViewer.this.myLocalRequest.getChangelistId().equals(change.getChangelistId())) {
                this.destroyHoverHighlighter();
                return;
            }
            EditorEx editor = SimpleLocalChangeListDiffViewer.this.getEditor(side);
            if (LocalTrackerDiffUtil.hasIconHighlighters(SimpleLocalChangeListDiffViewer.this.myProject, editor, line)) {
                if (this.myHighlighter != null && editor.getDocument().getLineNumber(this.myHighlighter.getStartOffset()) != line) {
                    this.destroyHoverHighlighter();
                }
                return;
            }
            this.destroyHoverHighlighter();
            boolean isExcludedFromCommit = change.getExclusionState() instanceof RangeExclusionState.Excluded;
            this.myHighlighter = LocalTrackerDiffUtil.createCheckboxToggle(editor, line, isExcludedFromCommit, () -> {
                LocalTrackerDiffUtil.toggleLinePartialExclusion(SimpleLocalChangeListDiffViewer.this.myTrackerActionProvider, line, side, isExcludedFromCommit);
                this.destroyHoverHighlighter();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener", "updateHoverHighlighter"));
        }

        private class MyGutterMouseListener
        extends MouseAdapter {
            private final Side mySide;

            MyGutterMouseListener(Side side) {
                if (side == null) {
                    MyGutterMouseListener.$$$reportNull$$$0(0);
                }
                this.mySide = side;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int xOffset;
                if (!SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit) {
                    GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
                    return;
                }
                EditorEx editor = SimpleLocalChangeListDiffViewer.this.getEditor(this.mySide);
                EditorGutterComponentEx gutter = editor.getGutterComponentEx();
                int n = xOffset = DiffUtil.isMirrored((Editor)editor) ? gutter.getWidth() - e.getX() : e.getX();
                if (xOffset < gutter.getIconAreaOffset() || xOffset > gutter.getIconAreaOffset() + gutter.getIconsAreaWidth()) {
                    GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
                    return;
                }
                LogicalPosition position = editor.xyToLogicalPosition(e.getPoint());
                GutterCheckboxMouseMotionListener.this.updateHoverHighlighter(this.mySide, position.line);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GutterCheckboxMouseMotionListener.this.destroyHoverHighlighter();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$GutterCheckboxMouseMotionListener$MyGutterMouseListener", "<init>"));
            }
        }
    }

    public static class MySimpleDiffChange
    extends SimpleDiffChange {
        @NotNull
        @NonNls
        private final String myChangelistId;
        private final boolean myIsPartiallyExcluded;
        @NotNull
        private final RangeExclusionState myExclusionState;

        MySimpleDiffChange(int index, @NotNull LineFragment fragment2, boolean isExcluded, boolean isSkipped, @NotNull @NonNls String changelistId, boolean isPartiallyExcluded, @NotNull RangeExclusionState exclusionState) {
            if (fragment2 == null) {
                MySimpleDiffChange.$$$reportNull$$$0(0);
            }
            if (changelistId == null) {
                MySimpleDiffChange.$$$reportNull$$$0(1);
            }
            if (exclusionState == null) {
                MySimpleDiffChange.$$$reportNull$$$0(2);
            }
            super(index, fragment2, isExcluded, isSkipped);
            this.myChangelistId = changelistId;
            this.myIsPartiallyExcluded = isPartiallyExcluded;
            this.myExclusionState = exclusionState;
        }

        @NotNull
        @NonNls
        public String getChangelistId() {
            String string2 = this.myChangelistId;
            if (string2 == null) {
                MySimpleDiffChange.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public boolean isPartiallyExcluded() {
            return this.myIsPartiallyExcluded;
        }

        @NotNull
        public RangeExclusionState getExclusionState() {
            RangeExclusionState rangeExclusionState = this.myExclusionState;
            if (rangeExclusionState == null) {
                MySimpleDiffChange.$$$reportNull$$$0(4);
            }
            return rangeExclusionState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exclusionState";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangelistId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExclusionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class MySimpleDiffChangeUi
    extends SimpleDiffChangeUi {
        private MySimpleDiffChangeUi(@NotNull SimpleLocalChangeListDiffViewer viewer, @NotNull MySimpleDiffChange change) {
            if (viewer == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(1);
            }
            super((SimpleDiffViewer)viewer, (SimpleDiffChange)change);
        }

        @NotNull
        private SimpleLocalChangeListDiffViewer getViewer() {
            SimpleLocalChangeListDiffViewer simpleLocalChangeListDiffViewer = (SimpleLocalChangeListDiffViewer)this.myViewer;
            if (simpleLocalChangeListDiffViewer == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(2);
            }
            return simpleLocalChangeListDiffViewer;
        }

        @NotNull
        private MySimpleDiffChange getChange() {
            MySimpleDiffChange mySimpleDiffChange = (MySimpleDiffChange)this.myChange;
            if (mySimpleDiffChange == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(3);
            }
            return mySimpleDiffChange;
        }

        public void installHighlighter(@Nullable SimpleDiffChange previousChange) {
            if (this.getChange().isPartiallyExcluded() && this.getViewer().myAllowExcludeChangesFromCommit) {
                assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
                int changeStart1 = this.getChange().getStartLine(Side.LEFT);
                int changeStart2 = this.getChange().getStartLine(Side.RIGHT);
                RangeExclusionState.Partial exclusionState = (RangeExclusionState.Partial)this.getChange().getExclusionState();
                exclusionState.iterateDeletionOffsets((start2, end, isIncluded) -> {
                    this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myViewer.getEditor(Side.LEFT), start2 + changeStart1, end + changeStart1, TextDiffType.DELETED).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(isIncluded == false).withAlignedSides(this.myViewer.needAlignChanges()).done());
                    return null;
                });
                exclusionState.iterateAdditionOffsets((start2, end, isIncluded) -> {
                    this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myViewer.getEditor(Side.RIGHT), start2 + changeStart2, end + changeStart2, TextDiffType.INSERTED).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(isIncluded == false).withAlignedSides(this.myViewer.needAlignChanges()).done());
                    return null;
                });
                if (exclusionState.getDeletionsCount() == 0) {
                    this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myViewer.getEditor(Side.LEFT), changeStart1, changeStart1, TextDiffType.INSERTED).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(false).withAlignedSides(this.myViewer.needAlignChanges()).done());
                }
                if (exclusionState.getAdditionsCount() == 0) {
                    this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)this.myViewer.getEditor(Side.RIGHT), changeStart2, changeStart2, TextDiffType.DELETED).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(false).withAlignedSides(this.myViewer.needAlignChanges()).done());
                }
            } else {
                super.installHighlighter(previousChange);
            }
        }

        public boolean drawDivider(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            if (handler2 == null) {
                MySimpleDiffChangeUi.$$$reportNull$$$0(4);
            }
            if (this.getChange().isPartiallyExcluded() && this.getViewer().myAllowExcludeChangesFromCommit) {
                int startLine1 = this.myChange.getStartLine(Side.LEFT);
                int endLine1 = this.myChange.getEndLine(Side.LEFT);
                int startLine2 = this.myChange.getStartLine(Side.RIGHT);
                int endLine2 = this.myChange.getEndLine(Side.RIGHT);
                if (this.myViewer.needAlignChanges()) {
                    if (startLine1 != endLine1 && !handler2.processAligned(startLine1, endLine1, startLine2, startLine2, TextDiffType.DELETED)) {
                        return false;
                    }
                    return startLine2 == endLine2 || handler2.processAligned(endLine1, endLine1, startLine2, endLine2, TextDiffType.INSERTED);
                }
                if (startLine1 != endLine1 && !handler2.processExcludable(startLine1, endLine1, startLine2, startLine2, TextDiffType.DELETED, this.myChange.isExcluded(), this.myChange.isSkipped())) {
                    return false;
                }
                return startLine2 == endLine2 || handler2.processExcludable(endLine1, endLine1, startLine2, endLine2, TextDiffType.INSERTED, this.myChange.isExcluded(), this.myChange.isSkipped());
            }
            return super.drawDivider(handler2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChangeUi";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MySimpleDiffChangeUi";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "drawDivider";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }

    private final class MyLocalTrackerDiffHandler
    implements LocalTrackerDiffUtil.LocalTrackerDiffHandler {
        @NotNull
        private final ProgressIndicator myIndicator;

        private MyLocalTrackerDiffHandler(ProgressIndicator indicator) {
            if (indicator == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        @Override
        @NotNull
        public Runnable done(boolean isContentsEqual, CharSequence @NotNull [] texts, @NotNull List<LocalTrackerDiffUtil.ToggleableLineRange> toggleableLineRanges) {
            if (toggleableLineRanges == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(1);
            }
            if (texts == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(2);
            }
            ArrayList<MySimpleDiffChange> changes = new ArrayList<MySimpleDiffChange>();
            for (LocalTrackerDiffUtil.ToggleableLineRange toggleableLineRange : toggleableLineRanges) {
                LocalTrackerDiffUtil.LineFragmentData data2 = toggleableLineRange.getFragmentData();
                boolean isSkipped = data2.isSkipped();
                boolean isExcluded = data2.isExcluded(SimpleLocalChangeListDiffViewer.this.myAllowExcludeChangesFromCommit);
                for (LineFragment fragment2 : toggleableLineRange.getFragments()) {
                    changes.add(new MySimpleDiffChange(changes.size(), fragment2, isExcluded, isSkipped, data2.getChangelistId(), data2.isPartiallyExcluded(), data2.getExclusionState()));
                }
            }
            Runnable applyChanges2 = SimpleLocalChangeListDiffViewer.this.apply(changes, isContentsEqual);
            Runnable applyGutterExcludeOperations = SimpleLocalChangeListDiffViewer.this.applyGutterOperations(toggleableLineRanges);
            Runnable runnable = () -> {
                applyChanges2.run();
                applyGutterExcludeOperations.run();
            };
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(3);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable retryLater() {
            ApplicationManager.getApplication().invokeLater(() -> SimpleLocalChangeListDiffViewer.this.scheduleRediff());
            throw new ProcessCanceledException();
        }

        @Override
        @NotNull
        public Runnable fallback() {
            Runnable runnable = SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(4);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable fallbackWithProgress() {
            Runnable callback2 = SimpleLocalChangeListDiffViewer.this.superComputeDifferences(this.myIndicator);
            Runnable runnable = () -> {
                callback2.run();
                SimpleLocalChangeListDiffViewer.this.getStatusPanel().setBusy(true);
            };
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(5);
            }
            return runnable;
        }

        @Override
        @NotNull
        public Runnable error() {
            Runnable runnable = SimpleLocalChangeListDiffViewer.this.applyNotification(DiffNotifications.createError());
            if (runnable == null) {
                MyLocalTrackerDiffHandler.$$$reportNull$$$0(6);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toggleableLineRanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MyLocalTrackerDiffHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallback";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fallbackWithProgress";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }
}

