/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import org.jetbrains.annotations.NotNull;

public class JsonElementGenerator {
    private final Project myProject;

    public JsonElementGenerator(@NotNull Project project2) {
        if (project2 == null) {
            JsonElementGenerator.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @NotNull
    public PsiFile createDummyFile(@NotNull String content) {
        if (content == null) {
            JsonElementGenerator.$$$reportNull$$$0(1);
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.myProject);
        PsiFile psiFile2 = psiFileFactory.createFileFromText("dummy." + JsonFileType.INSTANCE.getDefaultExtension(), (FileType)JsonFileType.INSTANCE, (CharSequence)content);
        if (psiFile2 == null) {
            JsonElementGenerator.$$$reportNull$$$0(2);
        }
        return psiFile2;
    }

    @NotNull
    public <T extends JsonValue> T createValue(@NotNull String content) {
        if (content == null) {
            JsonElementGenerator.$$$reportNull$$$0(3);
        }
        PsiFile file = this.createDummyFile("{\"foo\": " + content + "}");
        JsonValue jsonValue = ((JsonObject)file.getFirstChild()).getPropertyList().get(0).getValue();
        if (jsonValue == null) {
            JsonElementGenerator.$$$reportNull$$$0(4);
        }
        return (T)jsonValue;
    }

    @NotNull
    public JsonObject createObject(@NotNull String content) {
        if (content == null) {
            JsonElementGenerator.$$$reportNull$$$0(5);
        }
        PsiFile file = this.createDummyFile("{" + content + "}");
        JsonObject jsonObject = (JsonObject)file.getFirstChild();
        if (jsonObject == null) {
            JsonElementGenerator.$$$reportNull$$$0(6);
        }
        return jsonObject;
    }

    @NotNull
    public JsonStringLiteral createStringLiteral(@NotNull String unescapedContent) {
        if (unescapedContent == null) {
            JsonElementGenerator.$$$reportNull$$$0(7);
        }
        JsonStringLiteral jsonStringLiteral = (JsonStringLiteral)this.createValue("\"" + StringUtil.escapeStringCharacters((String)unescapedContent) + "\"");
        if (jsonStringLiteral == null) {
            JsonElementGenerator.$$$reportNull$$$0(8);
        }
        return jsonStringLiteral;
    }

    @NotNull
    public JsonProperty createProperty(@NotNull String name, @NotNull String value2) {
        if (name == null) {
            JsonElementGenerator.$$$reportNull$$$0(9);
        }
        if (value2 == null) {
            JsonElementGenerator.$$$reportNull$$$0(10);
        }
        PsiFile file = this.createDummyFile("{\"" + name + "\": " + value2 + "}");
        JsonProperty jsonProperty = ((JsonObject)file.getFirstChild()).getPropertyList().get(0);
        if (jsonProperty == null) {
            JsonElementGenerator.$$$reportNull$$$0(11);
        }
        return jsonProperty;
    }

    @NotNull
    public PsiElement createComma() {
        JsonArray jsonArray1 = (JsonArray)this.createValue("[1, 2]");
        PsiElement psiElement = jsonArray1.getValueList().get(0).getNextSibling();
        if (psiElement == null) {
            JsonElementGenerator.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/psi/JsonElementGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescapedContent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/psi/JsonElementGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createProperty";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteral";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6, 8, 11, 12 -> new IllegalStateException(string2);
        };
    }
}

