/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.ExportToXMLAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.ResultsToFileProcessor;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class InspectionCommandEx
extends AbstractCommand {
    public static final String PREFIX = "%InspectCodeEx";
    private static final Logger LOGGER = Logger.getInstance(InspectionCommandEx.class);
    private final Options myOptions;

    public InspectionCommandEx(@NotNull String text2, int line) {
        if (text2 == null) {
            InspectionCommandEx.$$$reportNull$$$0(0);
        }
        super(text2, line);
        this.myOptions = new Options();
        if (text2.startsWith(PREFIX)) {
            Args.parse((Object)this.myOptions, (String[])text2.substring(PREFIX.length()).trim().split(" "));
        }
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        PsiDirectory psiDirectory;
        VirtualFile directory;
        if (context == null) {
            InspectionCommandEx.$$$reportNull$$$0(1);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        if (StringUtil.isNotEmpty((String)this.myOptions.downloadFileUrl)) {
            if (StringUtil.isEmpty((String)this.myOptions.toolShortName)) {
                LOGGER.error("myOptions.toolShortName cannot be null if you want to download file for test");
            } else {
                InspectionCommandEx.downloadTestRequiredFile(this.myOptions.toolShortName, this.myOptions.downloadFileUrl);
            }
        }
        final @NotNull Project project = context.getProject();
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        InspectionProfileManager profileManager = InspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl profile = profileManager.getCurrentProfile();
        if (StringUtil.isNotEmpty((String)this.myOptions.toolShortName)) {
            profile.disableAllTools(project);
            profile.enableTool(this.myOptions.toolShortName, project);
        }
        final List enabledInspectionTools = profile.getAllEnabledInspectionTools(project);
        if (!ArrayUtil.isEmpty((Object[])this.myOptions.inspectionTrueFields)) {
            InspectionCommandEx.setInspectionFields(enabledInspectionTools, this.myOptions.inspectionTrueFields, true);
        }
        if (!ArrayUtil.isEmpty((Object[])this.myOptions.inspectionFalseFields)) {
            InspectionCommandEx.setInspectionFields(enabledInspectionTools, this.myOptions.inspectionFalseFields, false);
        }
        NamedScope namedScope = NamedScopesHolder.getScope((Project)project, (String)this.myOptions.scopeName);
        AnalysisScope analysisScope = null;
        if (namedScope != null) {
            analysisScope = new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope), project);
        } else if (StringUtil.isNotEmpty((String)this.myOptions.directory) && (directory = VfsUtil.findRelativeFile((VirtualFile)ProjectUtil.guessProjectDir((Project)project), (String[])new String[]{this.myOptions.directory})) != null && (psiDirectory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findDirectory(directory))) != null) {
            analysisScope = new AnalysisScope(psiDirectory);
        }
        if (analysisScope == null) {
            analysisScope = new AnalysisScope(project);
        }
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(project, inspectionManagerEx.getContentManager()){

            public void addView(@NotNull InspectionResultsView view, @NotNull String title, boolean isOffline) {
                if (view == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.addView(view, title, isOffline);
                ToolWindow resultWindow = ProblemsView.getToolWindow((Project)project);
                if (resultWindow != null && InspectionCommandEx.this.myOptions.hideResults) {
                    resultWindow.hide();
                }
            }

            protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
                block15: {
                    if (scope == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.notifyInspectionsFinished(scope);
                    context.message(PerformanceTestingBundle.message("command.inspection.finish", new Object[0]), InspectionCommandEx.this.getLine());
                    if (enabledInspectionTools.size() == 1 && !InspectionCommandEx.this.myOptions.hideResults) {
                        try {
                            File tempDirectory = FileUtil.createTempDirectory((String)"inspection", (String)"result");
                            InspectionResultsView view = this.getView();
                            if (view == null) break block15;
                            ExportToXMLAction.Companion.dumpToXml(view.getCurrentProfile(), view.getTree(), view.getProject(), view.getGlobalInspectionContext(), tempDirectory.toPath());
                            File[] files = tempDirectory.listFiles();
                            if (files != null) {
                                for (File file : files) {
                                    long warningCount;
                                    if (file.isHidden()) continue;
                                    String identifier = InspectionCommandEx.buildIdentifier(file.getName(), InspectionCommandEx.this.myOptions.inspectionTrueFields, project);
                                    context.message("#########", InspectionCommandEx.this.getLine());
                                    context.message(file.getName(), InspectionCommandEx.this.getLine());
                                    context.message(ArrayUtil.isEmpty((Object[])InspectionCommandEx.this.myOptions.inspectionTrueFields) ? null : StringUtil.join((String[])InspectionCommandEx.this.myOptions.inspectionTrueFields, (String)"-"), InspectionCommandEx.this.getLine());
                                    context.message(project.getName(), InspectionCommandEx.this.getLine());
                                    context.message("#########", InspectionCommandEx.this.getLine());
                                    Path path = file.toPath();
                                    context.message(path.toString(), InspectionCommandEx.this.getLine());
                                    try (Stream<String> lines = Files.lines(path).filter(line -> line.contains("<problem>"));){
                                        warningCount = lines.count();
                                    }
                                    if (ApplicationManagerEx.isInIntegrationTest()) {
                                        if (warningCount < Integer.MAX_VALUE) {
                                            Path perfMetricsPath = Paths.get(PathManager.getLogPath(), new String[0]).resolve("performance-metrics").resolve("inspectionMetrics.json");
                                            ResultsToFileProcessor.writeMetricsToJson(perfMetricsPath, "inspection_execution", (int)warningCount, null);
                                        } else {
                                            LOGGER.error("warningCount is greater than Integer.MAX_VALUE");
                                        }
                                    }
                                    InspectionCommandEx.reportStatisticsToTeamCity(identifier, String.valueOf(warningCount));
                                    InspectionCommandEx.saveArtifact(path, identifier);
                                }
                                break block15;
                            }
                            LOGGER.error("tempDirectory.listFiles() is null");
                        }
                        catch (IOException ex) {
                            LOGGER.error((Throwable)ex);
                        }
                    }
                }
                actionCallback.setDone();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "view";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addView";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyInspectionsFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        inspectionContext.setExternalProfile(profile);
        inspectionContext.doInspections(analysisScope);
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            InspectionCommandEx.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static void saveArtifact(@NotNull Path path, @NotNull String identifier) {
        File dest;
        File destDir;
        if (path == null) {
            InspectionCommandEx.$$$reportNull$$$0(3);
        }
        if (identifier == null) {
            InspectionCommandEx.$$$reportNull$$$0(4);
        }
        if (!(destDir = (dest = new File("../../../report/incorrect-resolves/" + identifier + ".xml")).getParentFile()).exists() && !destDir.mkdirs()) {
            LOGGER.error("Haven't managed to create directory: " + destDir.getAbsolutePath());
        }
        try {
            Files.move(path, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Incorrect resolve artifact saved to " + dest.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Cannot save artifact: " + identifier);
            LOGGER.error((Throwable)e);
        }
    }

    private static void setInspectionFields(@NotNull List<Tools> enabledInspectionTools, String @NotNull [] fieldNames, boolean flag) {
        if (enabledInspectionTools == null) {
            InspectionCommandEx.$$$reportNull$$$0(5);
        }
        if (fieldNames == null) {
            InspectionCommandEx.$$$reportNull$$$0(6);
        }
        if (enabledInspectionTools.size() == 1) {
            InspectionProfileEntry inspection = enabledInspectionTools.get(0).getTool().getTool();
            Class<?> inspectionClass = inspection.getClass();
            for (String inspectionFieldName : fieldNames) {
                try {
                    Field field = inspectionClass.getField(inspectionFieldName);
                    field.setBoolean(inspection, flag);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        } else {
            LOGGER.error("Cannot set true flags for more than one inspection");
        }
    }

    private static void downloadTestRequiredFile(@NotNull String toolShortName, @NotNull String downloadUrl) {
        if (toolShortName == null) {
            InspectionCommandEx.$$$reportNull$$$0(7);
        }
        if (downloadUrl == null) {
            InspectionCommandEx.$$$reportNull$$$0(8);
        }
        String tempDirectory = FileUtil.getTempDirectory();
        String filename = toolShortName + ".txt";
        File downloadedFile = Paths.get(tempDirectory, filename).toFile();
        if (downloadedFile.exists()) {
            downloadedFile.delete();
        }
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileDescription description = service.createFileDescription(downloadUrl, filename);
        FileDownloader downloader = service.createDownloader(Collections.singletonList(description), "Download correct resolves file");
        try {
            downloader.download(new File(tempDirectory));
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        if (!downloadedFile.exists()) {
            LOGGER.error("Downloaded file doesn't exist");
        }
    }

    @NotNull
    private static String buildIdentifier(@NotNull String inspectionResultFilename, String @Nullable [] inspectionTrueFields, @NotNull Project project) {
        if (inspectionResultFilename == null) {
            InspectionCommandEx.$$$reportNull$$$0(9);
        }
        if (project == null) {
            InspectionCommandEx.$$$reportNull$$$0(10);
        }
        String string = Stream.of(project.getName(), StringUtil.trimExtensions((String)inspectionResultFilename), ArrayUtil.isEmpty((Object[])inspectionTrueFields) ? null : StringUtil.join((String[])inspectionTrueFields, (String)"-"), "warning-count").filter(Predicates.nonNull()).collect(Collectors.joining("-"));
        if (string == null) {
            InspectionCommandEx.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void reportStatisticsToTeamCity(@NotNull String key, @NotNull String value) {
        if (key == null) {
            InspectionCommandEx.$$$reportNull$$$0(12);
        }
        if (value == null) {
            InspectionCommandEx.$$$reportNull$$$0(13);
        }
        System.out.println("Report statistics key = " + key + " value = " + value);
        System.out.println("##teamcity[buildStatisticValue key='" + key + "' value='" + value + "']");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledInspectionTools";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionResultFilename";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveArtifact";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setInspectionFields";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadTestRequiredFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildIdentifier";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportStatisticsToTeamCity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11 -> new IllegalStateException(string);
        };
    }

    public static class Options {
        @Argument
        @Nullable
        public String scopeName;
        @Argument
        @Nullable
        public String toolShortName;
        @Argument
        public String @Nullable [] inspectionTrueFields;
        @Argument
        public String @Nullable [] inspectionFalseFields;
        @Argument
        @Nullable
        public String downloadFileUrl;
        @Argument
        @Nullable
        public String directory;
        @Argument
        public boolean hideResults = false;
    }
}

