/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotifications;
import java.util.HashSet;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingCharsetUtil;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.editorconfig.language.psi.EditorConfigFlatOptionKey;
import org.editorconfig.language.psi.EditorConfigOption;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

final class EditorConfigStatusListener
implements CodeStyleSettingsListener,
Disposable {
    private boolean myEnabledStatus;
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private Set<String> myEncodings;

    EditorConfigStatusListener(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myEnabledStatus = Utils.INSTANCE.isEnabled(project);
        this.myVirtualFile = virtualFile;
        this.myEncodings = this.extractEncodings();
        CodeStyleSettingsManager.getInstance((Project)project).subscribe((CodeStyleSettingsListener)this, (Disposable)this);
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        Set<String> newEncodings;
        CodeStyleSettings settings;
        if (event == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(2);
        }
        if ((settings = CodeStyle.getSettings((Project)this.myProject)).getCustomSettingsIfCreated(EditorConfigSettings.class) == null) {
            return;
        }
        boolean newEnabledStatus = Utils.INSTANCE.isEnabled(this.myProject);
        if (this.myEnabledStatus != newEnabledStatus) {
            this.myEnabledStatus = newEnabledStatus;
            this.onEditorConfigEnabled(newEnabledStatus);
        }
        if (!this.myEncodings.equals(newEncodings = this.extractEncodings())) {
            if (EditorConfigStatusListener.containsValidEncodings(newEncodings)) {
                EditorConfigStatusListener.onEncodingChanged();
            }
            this.myEncodings = newEncodings;
        }
    }

    private void onEditorConfigEnabled(boolean isEnabled) {
        PsiFile psiFile;
        if (!isEnabled) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            fileEditorManager.closeFile(this.myVirtualFile);
            fileEditorManager.openFile(this.myVirtualFile, false);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myVirtualFile);
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        PsiFile psiFile2 = psiFile = document == null ? null : PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
        }
    }

    public void dispose() {
    }

    private static void onEncodingChanged() {
        EditorConfigEncodingCache.Companion.getInstance().reset();
    }

    private static boolean containsValidEncodings(@NotNull Set<String> encodings) {
        if (encodings == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(3);
        }
        for (String t : encodings) {
            if (ConfigEncodingCharsetUtil.INSTANCE.toCharset(t) != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Set<String> extractEncodings() {
        final HashSet<String> charsets = new HashSet<String>();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myVirtualFile);
        if (psiFile == null) {
            HashSet<String> hashSet = charsets;
            if (hashSet == null) {
                EditorConfigStatusListener.$$$reportNull$$$0(4);
            }
            return hashSet;
        }
        PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiFile || element instanceof EditorConfigSection) {
                    super.visitElement(element);
                } else if (element instanceof EditorConfigOption) {
                    String keyName;
                    EditorConfigFlatOptionKey obj1 = ((EditorConfigOption)element).getFlatOptionKey();
                    String string = keyName = obj1 == null ? null : obj1.getName();
                    if ("charset".equals(keyName)) {
                        String charsetStr;
                        EditorConfigOptionValueIdentifier obj = ((EditorConfigOption)element).getOptionValueIdentifier();
                        String string2 = charsetStr = obj == null ? null : obj.getName();
                        if (charsetStr != null) {
                            charsets.add(charsetStr);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/editorconfig/configmanagement/editor/EditorConfigStatusListener$1", "visitElement"));
            }
        };
        psiFile.accept((PsiElementVisitor)visitor2);
        HashSet<String> hashSet = charsets;
        if (hashSet == null) {
            EditorConfigStatusListener.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigStatusListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractEncodings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsValidEncodings";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

