/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PtyCommandLine
extends GeneralCommandLine {
    private static final Logger LOG = Logger.getInstance(PtyCommandLine.class);
    private static final String RUN_PROCESSES_WITH_PTY = "run.processes.with.pty";
    public static final int MAX_COLUMNS = 2500;
    private final LocalPtyOptions.Builder myOptionsBuilder;
    private boolean myWindowsAnsiColorEnabled;
    private boolean myUnixOpenTtyToPreserveOutputAfterTermination;

    public static boolean isEnabled() {
        return Registry.is((String)RUN_PROCESSES_WITH_PTY);
    }

    public PtyCommandLine() {
        this.myOptionsBuilder = PtyCommandLine.getDefaultPtyOptions().builder();
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        this.myUnixOpenTtyToPreserveOutputAfterTermination = true;
    }

    public PtyCommandLine withUseCygwinLaunch(boolean useCygwinLaunch) {
        this.myOptionsBuilder.useCygwinLaunch(useCygwinLaunch);
        return this;
    }

    public PtyCommandLine withConsoleMode(boolean consoleMode) {
        this.myOptionsBuilder.consoleMode(consoleMode);
        return this;
    }

    public boolean isConsoleMode() {
        return this.myOptionsBuilder.consoleMode();
    }

    public PtyCommandLine withInitialColumns(int initialColumns) {
        this.myOptionsBuilder.initialColumns(initialColumns);
        return this;
    }

    public PtyCommandLine withInitialRows(int initialRows) {
        this.myOptionsBuilder.initialRows(initialRows);
        return this;
    }

    public PtyCommandLine withOptions(@NotNull LocalPtyOptions options) {
        if (options == null) {
            PtyCommandLine.$$$reportNull$$$0(0);
        }
        this.myOptionsBuilder.set(options);
        return this;
    }

    public PtyCommandLine(@NotNull List<String> command) {
        if (command == null) {
            PtyCommandLine.$$$reportNull$$$0(1);
        }
        super(command);
        this.myOptionsBuilder = PtyCommandLine.getDefaultPtyOptions().builder();
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        this.myUnixOpenTtyToPreserveOutputAfterTermination = true;
    }

    public PtyCommandLine(@NotNull GeneralCommandLine original) {
        if (original == null) {
            PtyCommandLine.$$$reportNull$$$0(2);
        }
        super(original);
        this.myOptionsBuilder = PtyCommandLine.getDefaultPtyOptions().builder();
        this.myWindowsAnsiColorEnabled = !Boolean.getBoolean("pty4j.win.disable.ansi.in.console.mode");
        this.myUnixOpenTtyToPreserveOutputAfterTermination = true;
        if (original instanceof PtyCommandLine) {
            this.myOptionsBuilder.set(((PtyCommandLine)original).myOptionsBuilder.build());
        }
    }

    @NotNull
    PtyCommandLine withWindowsAnsiColorDisabled() {
        this.myWindowsAnsiColorEnabled = false;
        PtyCommandLine ptyCommandLine = this;
        if (ptyCommandLine == null) {
            PtyCommandLine.$$$reportNull$$$0(3);
        }
        return ptyCommandLine;
    }

    @NotNull
    public PtyCommandLine withUnixOpenTtyToPreserveOutputAfterTermination(boolean unixOpenTtyToPreserveOutputAfterTermination) {
        this.myUnixOpenTtyToPreserveOutputAfterTermination = unixOpenTtyToPreserveOutputAfterTermination;
        PtyCommandLine ptyCommandLine = this;
        if (ptyCommandLine == null) {
            PtyCommandLine.$$$reportNull$$$0(4);
        }
        return ptyCommandLine;
    }

    @Override
    @NotNull
    protected Process startProcess(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(5);
        }
        if (this.getInputFile() == null && this.getProcessCreator() == null) {
            Process process;
            try {
                process = this.startProcessWithPty(commands);
            }
            catch (Throwable t) {
                String message = "Couldn't run process with PTY";
                if (LOG.isDebugEnabled()) {
                    String logFileContent = PtyCommandLine.loadLogFile();
                    if (logFileContent != null) {
                        LOG.debug(message, new Object[]{t, logFileContent});
                    } else {
                        LOG.warn(message, t);
                    }
                }
                LOG.warn(message, t);
            }
            if (process == null) {
                PtyCommandLine.$$$reportNull$$$0(6);
            }
            return process;
        }
        Process process = super.startProcess(commands);
        if (process == null) {
            PtyCommandLine.$$$reportNull$$$0(7);
        }
        return process;
    }

    @Nullable
    private static String loadLogFile() {
        File logFile;
        Application app = ApplicationManager.getApplication();
        File file = logFile = app != null && app.isEAP() ? new File(PathManager.getLogPath(), "pty.log") : null;
        if (logFile != null && logFile.exists()) {
            try {
                return FileUtil.loadFile((File)logFile);
            }
            catch (Exception e) {
                return "Unable to retrieve pty log: " + e.getMessage();
            }
        }
        return null;
    }

    public LocalPtyOptions getPtyOptions() {
        return this.myOptionsBuilder.build();
    }

    @NotNull
    public Process startProcessWithPty(@NotNull List<String> commands) throws IOException {
        if (commands == null) {
            PtyCommandLine.$$$reportNull$$$0(8);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.setupEnvironment(env);
        if (!SystemInfo.isWindows && !this.getEnvironment().containsKey("TERM")) {
            env.put("TERM", "xterm-256color");
        }
        String[] command = ArrayUtilRt.toStringArray(commands);
        File workDirectory = this.getWorkDirectory();
        String directory = workDirectory != null ? workDirectory.getPath() : null;
        LocalPtyOptions options = this.getPtyOptions();
        Application app = ApplicationManager.getApplication();
        Process process = ProcessService.getInstance().startPtyProcess(command, directory, env, options, app, this.isRedirectErrorStream(), this.myWindowsAnsiColorEnabled, this.myUnixOpenTtyToPreserveOutputAfterTermination);
        if (process == null) {
            PtyCommandLine.$$$reportNull$$$0(9);
        }
        return process;
    }

    @NotNull
    public static LocalPtyOptions getDefaultPtyOptions() {
        LocalPtyOptions localPtyOptions = LocalPtyOptions.DEFAULT.builder().consoleMode(true).useWinConPty(LocalPtyOptions.shouldUseWinConPty()).build();
        if (localPtyOptions == null) {
            PtyCommandLine.$$$reportNull$$$0(10);
        }
        return localPtyOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/PtyCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withWindowsAnsiColorDisabled";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withUnixOpenTtyToPreserveOutputAfterTermination";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessWithPty";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPtyOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withOptions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startProcessWithPty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

