/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitIterator;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class Player
extends FreeColGameObject
implements Nameable {
    private static final Logger logger = Logger.getLogger(Player.class.getName());
    private static final int PLAYER_CLASS_INDEX = 10;
    public static final String TAG = "player";
    public static final Comparator<Player> playerComparator = Comparator.comparingInt(Player::getRank);
    public static final int GOLD_NOT_ACCOUNTED = Integer.MIN_VALUE;
    public static final String ASSIGN_SETTLEMENT_NAME = "";
    protected String name;
    protected String independentNationName;
    protected PlayerType playerType;
    protected NationType nationType;
    protected String nationId;
    protected String newLandName = null;
    protected boolean admin;
    protected boolean ai;
    protected boolean ready;
    protected boolean dead = false;
    protected boolean attackedByPrivateers = false;
    private boolean bankrupt;
    protected int score;
    protected int gold;
    protected int immigration;
    protected int immigrationRequired;
    protected int liberty;
    protected int oldSoL = 0;
    protected int interventionBells;
    protected int tax = 0;
    protected Tile entryTile;
    protected Market market;
    protected Europe europe;
    protected Monarch monarch;
    protected final Set<FoundingFather> foundingFathers = new HashSet<FoundingFather>();
    protected FoundingFather currentFather;
    protected final List<FoundingFather> offeredFathers = new ArrayList<FoundingFather>();
    protected final java.util.Map<Player, Tension> tension = new HashMap<Player, Tension>();
    protected Set<Player> bannedMissions = null;
    protected final java.util.Map<String, Stance> stance = new HashMap<String, Stance>();
    protected final List<TradeRoute> tradeRoutes = new ArrayList<TradeRoute>();
    protected final List<ModelMessage> modelMessages = new ArrayList<ModelMessage>();
    protected final List<HistoryEvent> history = new ArrayList<HistoryEvent>();
    protected HashMap<String, LastSale> lastSales = null;
    private final Set<Unit> units = new HashSet<Unit>();
    protected final List<Settlement> settlements = new ArrayList<Settlement>();
    private boolean[][] canSeeTiles = null;
    private boolean canSeeValid = false;
    private final Object canSeeLock = new Object();
    protected final FeatureContainer featureContainer = new FeatureContainer();
    private int maximumFoodConsumption = -1;
    private final UnitIterator nextActiveUnitIterator = new UnitIterator(this, Unit::couldMove);
    private final UnitIterator nextGoingToUnitIterator = new UnitIterator(this, Unit::goingToDestination);
    protected HighSeas highSeas = null;
    private final java.util.Map<Player, NationSummary> nationCache = new HashMap<Player, NationSummary>();
    private Comparator<Colony> colonyComparator = null;
    private static final String ADMIN_TAG = "admin";
    private static final String AI_TAG = "ai";
    private static final String ATTACKED_BY_PRIVATEERS_TAG = "attackedByPrivateers";
    private static final String BANKRUPT_TAG = "bankrupt";
    private static final String BAN_MISSIONS_TAG = "banMissions";
    private static final String CURRENT_FATHER_TAG = "currentFather";
    private static final String DEAD_TAG = "dead";
    private static final String ENTRY_LOCATION_TAG = "entryLocation";
    private static final String FOUNDING_FATHERS_TAG = "foundingFathers";
    private static final String GOLD_TAG = "gold";
    private static final String IMMIGRATION_TAG = "immigration";
    private static final String IMMIGRATION_REQUIRED_TAG = "immigrationRequired";
    private static final String LIBERTY_TAG = "liberty";
    private static final String INDEPENDENT_NATION_NAME_TAG = "independentNationName";
    private static final String INTERVENTION_BELLS_TAG = "interventionBells";
    private static final String NATION_ID_TAG = "nationId";
    private static final String NATION_TYPE_TAG = "nationType";
    private static final String NEW_LAND_NAME_TAG = "newLandName";
    private static final String OFFERED_FATHERS_TAG = "offeredFathers";
    private static final String OLD_SOL_TAG = "oldSoL";
    private static final String PLAYER_TAG = "player";
    private static final String PLAYER_TYPE_TAG = "playerType";
    private static final String READY_TAG = "ready";
    private static final String SCORE_TAG = "score";
    private static final String STANCE_TAG = "stance";
    private static final String TAX_TAG = "tax";
    private static final String TENSION_TAG = "tension";
    private static final String USERNAME_TAG = "username";

    protected Player(Game game) {
        super(game);
    }

    public Player(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public StringTemplate getLabel() {
        return ((StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.label(ASSIGN_SETTLEMENT_NAME).add(this.getRulerNameKey())).addName(" (")).addStringTemplate(this.getNationLabel())).addName(")");
    }

    public boolean isUnknownEnemy() {
        return "model.nation.unknownEnemy".equals(this.nationId);
    }

    public final String getIndependentNationName() {
        return this.independentNationName;
    }

    public final void setIndependentNationName(String newIndependentNationName) {
        this.independentNationName = newIndependentNationName;
    }

    public String getNewLandName() {
        return this.newLandName;
    }

    public boolean isNewLandNamed() {
        return this.newLandName != null;
    }

    public void setNewLandName(String newLandName) {
        this.newLandName = newLandName;
    }

    public String getNameForNewLand() {
        return NameCache.getNewLandName(this);
    }

    public String getEuropeNameKey() {
        return this.europe == null ? null : this.nationId + ".europe";
    }

    public String getNationResourceKey() {
        return StringUtils.lastPart(this.nationId, ".");
    }

    public StringTemplate getNationLabel() {
        return this.playerType == PlayerType.REBEL || this.playerType == PlayerType.INDEPENDENT ? StringTemplate.name(this.independentNationName) : StringTemplate.key(Messages.nameKey(this.nationId));
    }

    public StringTemplate getCountryLabel() {
        return this.playerType == PlayerType.REBEL || this.playerType == PlayerType.INDEPENDENT ? StringTemplate.name(this.newLandName) : StringTemplate.template("countryName").addStringTemplate("%nation%", this.getNationLabel());
    }

    public StringTemplate getForcesLabel() {
        return StringTemplate.template("model.player.forces").addStringTemplate("%nation%", this.getNationLabel());
    }

    public StringTemplate getWaitingLabel() {
        return StringTemplate.template("model.player.waitingFor").addStringTemplate("%nation%", this.getNationLabel());
    }

    public String getDebugName() {
        return this.getNation().getSuffix();
    }

    public final String getRulerNameKey() {
        return Messages.rulerKey(this.nationId);
    }

    public StringTemplate getMarketName() {
        return this.getEurope() == null ? StringTemplate.key("model.player.independentMarket") : StringTemplate.key(this.getEuropeNameKey());
    }

    public String getCapitalName(Random random) {
        return NameCache.getCapitalName(this, random);
    }

    public String getSettlementName(Random random) {
        return NameCache.getSettlementName(this, random);
    }

    public void putSettlementName(String name) {
        NameCache.putSettlementName(this, name);
    }

    public String getNameForRegion(Region region) {
        return NameCache.getRegionName(this, region);
    }

    public String getNameForUnit(UnitType type, Random random) {
        return NameCache.getUnitName(this, type, random);
    }

    public final boolean isConnected() {
        return this.getConnection() != null;
    }

    public Connection getConnection() {
        throw new RuntimeException("getConnection called on Player: " + this);
    }

    public void setConnection(Connection connection) {
        throw new RuntimeException("setConnection called on Player: " + this);
    }

    public boolean send(ChangeSet cs) {
        throw new RuntimeException("send called on Player: " + this);
    }

    public ChangeSet clientError(StringTemplate template) {
        logger.warning(Messages.message(template));
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS)) {
            Thread.dumpStack();
        }
        return ChangeSet.clientError(ChangeSet.See.only(this), template);
    }

    public ChangeSet clientError(String message) {
        logger.warning(message);
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS)) {
            Thread.dumpStack();
        }
        return ChangeSet.clientError(ChangeSet.See.only(this), message);
    }

    public PlayerType getPlayerType() {
        return this.playerType;
    }

    private void setPlayerType(PlayerType type) {
        this.playerType = type;
    }

    public void changePlayerType(PlayerType type) {
        if (this.playerType != PlayerType.REBEL && this.playerType != PlayerType.INDEPENDENT) {
            switch (type) {
                case REBEL: 
                case INDEPENDENT: {
                    this.addAbility(new Ability("model.ability.independenceDeclared", true));
                    this.addAbility(new Ability("model.ability.independentNation", true));
                    break;
                }
            }
        }
        this.setPlayerType(type);
    }

    public boolean isColonial() {
        return this.playerType == PlayerType.COLONIAL;
    }

    public boolean isEuropean() {
        return this.playerType == PlayerType.COLONIAL || this.playerType == PlayerType.REBEL || this.playerType == PlayerType.INDEPENDENT || this.playerType == PlayerType.ROYAL;
    }

    public boolean isIndian() {
        return this.playerType == PlayerType.NATIVE;
    }

    public boolean isRebel() {
        return this.playerType == PlayerType.REBEL;
    }

    public boolean isUndead() {
        return this.playerType == PlayerType.UNDEAD;
    }

    public boolean isREF() {
        return this.playerType == PlayerType.ROYAL;
    }

    public boolean isPotentialEnemy(Player player) {
        if (!this.hasAbility("model.ability.ignoreEuropeanWars") && player.getREFPlayer() != this) {
            switch (this.getStance(player)) {
                case PEACE: 
                case CEASE_FIRE: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPotentialFriend(Player player) {
        if (player.getREFPlayer() != this) {
            switch (this.getStance(player)) {
                case CEASE_FIRE: 
                case WAR: {
                    return true;
                }
            }
        }
        return false;
    }

    public NationType getNationType() {
        return this.nationType;
    }

    public void setNationType(NationType newNationType) {
        this.nationType = newNationType;
    }

    public void changeNationType(NationType newNationType) {
        if (this.nationType != null) {
            this.removeFeatures(this.nationType);
        }
        this.setNationType(newNationType);
        if (newNationType != null) {
            this.addFeatures(newNationType);
        }
    }

    public boolean canBuildColonies() {
        return this.nationType != null && this.nationType.hasAbility("model.ability.foundsColonies");
    }

    public boolean canHaveFoundingFathers() {
        return this.nationType != null && this.nationType.hasAbility("model.ability.electFoundingFather");
    }

    public String getNationId() {
        return this.nationId;
    }

    public Nation getNation() {
        return this.getSpecification().getNation(this.nationId);
    }

    public void setNation(Nation newNation) {
        Nation oldNation = this.getNation();
        this.nationId = newNation.getId();
        java.util.Map<Nation, NationOptions.NationState> nations = this.getGame().getNationOptions().getNations();
        nations.put(oldNation, NationOptions.NationState.AVAILABLE);
        nations.put(newNation, NationOptions.NationState.NOT_AVAILABLE);
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isAI() {
        return this.ai;
    }

    public void setAI(boolean ai) {
        this.ai = ai;
    }

    public boolean isReady() {
        return this.getReady() || this.isAI();
    }

    public boolean getReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean getDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public boolean getAttackedByPrivateers() {
        return this.attackedByPrivateers;
    }

    public void setAttackedByPrivateers(boolean attacked) {
        this.attackedByPrivateers = attacked;
    }

    public boolean isWorkForREF() {
        return CollectionUtils.any(this.getUnits(), Unit::hasTile) ? true : !this.getRebels().isEmpty();
    }

    public List<Player> getRebels() {
        return CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(this), p -> p.getREFPlayer() == this && (p.isRebel() || p.isUndead()));
    }

    public Player getREFPlayer() {
        Nation ref = this.getNation().getREFNation();
        return ref == null ? null : this.getGame().getPlayerByNation(ref);
    }

    public Color getNationColor() {
        Nation nation = this.getNation();
        return nation == null ? null : nation.getColor();
    }

    public int getRank() {
        int ret;
        int n = ret = this.isEuropean() ? 1 : 0;
        if (this.isAI()) {
            ret |= 2;
        }
        if (this.isAdmin()) {
            ret |= 4;
        }
        return ret;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getSpanishSuccessionScore() {
        return this.getScore();
    }

    public int getGold() {
        return this.gold;
    }

    public void setGold(int newGold) {
        this.gold = newGold;
    }

    public boolean checkGold(int amount) {
        return this.gold == Integer.MIN_VALUE || this.gold >= amount;
    }

    public int modifyGold(int amount) {
        if (this.gold != Integer.MIN_VALUE) {
            if (this.gold + amount >= 0) {
                this.gold += amount;
            } else {
                logger.warning("Cannot add " + amount + " gold for " + this + ": would be negative!");
                this.gold = 0;
            }
        }
        return this.gold;
    }

    public final boolean getBankrupt() {
        return this.bankrupt;
    }

    public final void setBankrupt(boolean newBankrupt) {
        this.bankrupt = newBankrupt;
    }

    public int getImmigration() {
        return this.isColonial() ? this.immigration : 0;
    }

    public void setImmigration(int immigration) {
        if (!this.isColonial()) {
            return;
        }
        this.immigration = immigration;
    }

    public void reduceImmigration() {
        int cost;
        if (!this.isColonial()) {
            return;
        }
        int n = cost = this.getSpecification().getBoolean("model.option.saveProductionOverflow") ? this.immigrationRequired : this.immigration;
        this.immigration = cost > this.immigration ? 0 : (this.immigration -= cost);
    }

    public void modifyImmigration(int amount) {
        this.immigration = Math.max(0, this.immigration + amount);
    }

    public int getImmigrationRequired() {
        return this.immigrationRequired;
    }

    public void setImmigrationRequired(int immigrationRequired) {
        this.immigrationRequired = immigrationRequired;
    }

    public void updateImmigrationRequired() {
        if (!this.isColonial()) {
            return;
        }
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        int current = this.immigrationRequired;
        int base = spec.getInteger("model.option.crossesIncrement");
        int unreduced = Math.round((float)current / this.apply(1.0f, turn, "model.modifier.religiousUnrestBonus"));
        this.immigrationRequired = (int)this.apply(unreduced + base, turn, "model.modifier.religiousUnrestBonus");
        logger.finest("Immigration for " + this.getId() + " updated " + current + " -> " + this.immigrationRequired);
    }

    public boolean checkEmigrate() {
        return this.isColonial() ? this.getImmigrationRequired() <= this.immigration : false;
    }

    public int getTotalImmigrationProduction() {
        if (!this.isColonial()) {
            return 0;
        }
        List<GoodsType> immigrationGoodsTypes = this.getSpecification().getImmigrationGoodsTypeList();
        int production = CollectionUtils.sum(this.getColonies(), c -> CollectionUtils.sum(immigrationGoodsTypes, gt -> c.getTotalProductionOf((GoodsType)gt)));
        Europe europe = this.getEurope();
        if (europe != null) {
            production += europe.getImmigration(production);
        }
        return production;
    }

    public ModelMessage getEmigrationMessage(Unit unit) {
        return (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.player.emigrate", this, unit).addNamed("%europe%", this.getEurope())).addStringTemplate("%unit%", unit.getLabel());
    }

    public int getLiberty() {
        return this.canHaveFoundingFathers() ? this.liberty : 0;
    }

    public void setLiberty(int liberty) {
        if (!this.canHaveFoundingFathers()) {
            return;
        }
        this.liberty = liberty;
    }

    public void modifyLiberty(int amount) {
        this.setLiberty(Math.max(0, this.liberty + amount));
        if (this.isRebel()) {
            this.interventionBells += amount;
        }
    }

    protected boolean recalculateBellsBonus() {
        boolean ret = false;
        for (Ability ability : CollectionUtils.transform(this.getAbilities("model.ability.addTaxToBells"), CollectionUtils.isNotNull(Feature::getSource))) {
            FreeColObject source = ability.getSource();
            for (Modifier modifier : CollectionUtils.transform(this.getModifiers("model.goods.bells"), CollectionUtils.matchKeyEquals(source, Feature::getSource))) {
                modifier.setValue(this.tax);
                ret = true;
            }
        }
        return ret;
    }

    public int getLibertyProductionNextTurn() {
        Specification spec = this.getSpecification();
        List<GoodsType> goodsTypes = spec.getLibertyGoodsTypeList();
        int nextTurn = CollectionUtils.sum(this.getColonies(), c -> CollectionUtils.sum(goodsTypes, gt -> c.getTotalProductionOf((GoodsType)gt)));
        return (int)this.apply(nextTurn, this.getGame().getTurn(), "model.modifier.liberty");
    }

    protected int getOldSoL() {
        return this.oldSoL;
    }

    public int getSoL() {
        List<Colony> colonies = this.getColonyList();
        return colonies.isEmpty() ? 0 : CollectionUtils.sum(colonies, Colony::getSonsOfLiberty) / colonies.size();
    }

    protected int getInterventionBells() {
        return this.interventionBells;
    }

    public Set<FoundingFather> getFoundingFathers() {
        return this.foundingFathers;
    }

    protected void setFoundingFathers(Set<FoundingFather> foundingFathers) {
        this.foundingFathers.clear();
        for (FoundingFather ff : foundingFathers) {
            this.addFather(ff);
        }
    }

    public boolean hasFather(FoundingFather someFather) {
        return this.foundingFathers.contains(someFather);
    }

    public int getFatherCount() {
        return this.foundingFathers.size();
    }

    public void addFather(FoundingFather father) {
        this.foundingFathers.add(father);
        this.addFeatures(father);
        for (Colony c : this.getColonyList()) {
            c.invalidateCache();
        }
    }

    public FoundingFather getCurrentFather() {
        return this.currentFather;
    }

    public void setCurrentFather(FoundingFather someFather) {
        this.currentFather = someFather;
    }

    public List<FoundingFather> getOfferedFathers() {
        return this.offeredFathers;
    }

    public void clearOfferedFathers() {
        this.offeredFathers.clear();
    }

    public void setOfferedFathers(List<FoundingFather> fathers) {
        this.clearOfferedFathers();
        this.offeredFathers.addAll(fathers);
    }

    public int getRemainingFoundingFatherCost() {
        return this.getTotalFoundingFatherCost() - this.getLiberty();
    }

    public int getTotalFoundingFatherCost() {
        Specification spec = this.getSpecification();
        int base = spec.getInteger("model.option.foundingFatherFactor");
        int count = this.getFatherCount();
        return count == 0 ? base : 2 * (count + 1) * base + 1;
    }

    public java.util.Map<String, Turn> getElectionTurns() {
        return CollectionUtils.transform(this.getHistory(), CollectionUtils.matchKey(HistoryEvent.HistoryEventType.FOUNDING_FATHER, HistoryEvent::getEventType), Function.identity(), Collectors.toMap(he -> he.getReplacement("%father%").getId(), HistoryEvent::getTurn));
    }

    public StringTemplate checkDeclareIndependence() {
        if (this.getPlayerType() != PlayerType.COLONIAL) {
            return StringTemplate.template("model.player.colonialIndependence");
        }
        Event event = this.getSpecification().getEvent("model.event.declareIndependence");
        Limit limit = CollectionUtils.find(event.getLimitValues(), l -> !l.evaluate(this));
        return limit == null ? null : (StringTemplate)StringTemplate.template(limit.getDescriptionKey()).addAmount("%limit%", limit.getRightHandSide().getValue(this.getGame()));
    }

    public int calculateStrength(boolean naval) {
        CombatModel cm = this.getGame().getCombatModel();
        return (int)CollectionUtils.sumDouble(this.getUnits(), u -> u.isNaval() == naval, u -> cm.getOffencePower((FreeColGameObject)u, null));
    }

    public double getRebelStrengthRatio(boolean naval) {
        if (this.getPlayerType() != PlayerType.COLONIAL) {
            return 0.0;
        }
        return Player.strengthRatio(this.calculateStrength(naval), this.getMonarch().getExpeditionaryForce().calculateStrength(naval));
    }

    public List<AbstractUnit> getREFUnits() {
        return this.getPlayerType() == PlayerType.COLONIAL ? this.getMonarch().getExpeditionaryForce().getUnitList() : null;
    }

    public List<AbstractUnit> getMilitaryUnits() {
        Specification spec = this.getSpecification();
        UnitType defaultType = spec.getDefaultUnitType(this);
        List<Unit> milUnits = CollectionUtils.transform(this.getUnits(), Unit::isOffensiveUnit);
        HashMap unitHash = new HashMap(milUnits.size());
        ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>(milUnits.size());
        for (Unit unit : milUnits) {
            Integer count;
            String roleId;
            HashMap<String, Integer> roleMap;
            UnitType unitType = defaultType;
            if (unit.getType().getOffence() > 0.0 || unit.hasAbility("model.ability.expertSoldier")) {
                unitType = unit.getType();
            }
            if ((roleMap = (HashMap<String, Integer>)unitHash.get(unitType)) == null) {
                roleMap = new HashMap<String, Integer>(spec.getMilitaryRolesList().size());
            }
            roleMap.put(roleId, (count = (Integer)roleMap.get(roleId = unit.getRole().getId())) == null ? 1 : count + 1);
            unitHash.put(unitType, roleMap);
        }
        CollectionUtils.forEachMapEntry(unitHash, te -> CollectionUtils.forEachMapEntry((java.util.Map)te.getValue(), re -> units.add(new AbstractUnit((UnitType)te.getKey(), (String)re.getKey(), (int)((Integer)re.getValue())))));
        return units;
    }

    public int getTax() {
        return this.tax;
    }

    public void setTax(int amount) {
        this.tax = amount;
        if (this.recalculateBellsBonus()) {
            for (Colony c : this.getColonyList()) {
                c.invalidateCache();
            }
        }
    }

    public Market getMarket() {
        return this.market;
    }

    public void reinitialiseMarket() {
        this.market = new Market(this.getGame(), this);
    }

    protected java.util.Map<String, LastSale> getLastSales() {
        if (this.lastSales == null) {
            this.lastSales = new HashMap();
        }
        return this.lastSales;
    }

    protected void setLastSales(java.util.Map<String, LastSale> lastSales) {
        if (this.lastSales == null) {
            this.lastSales = new HashMap();
        } else {
            this.lastSales.clear();
        }
        this.lastSales.putAll(lastSales);
    }

    public LastSale getLastSale(Location where, GoodsType what) {
        return this.lastSales == null ? null : this.lastSales.get(LastSale.makeKey(where, what));
    }

    public void addLastSale(LastSale sale) {
        if (this.lastSales == null) {
            this.lastSales = new HashMap();
        }
        this.lastSales.put(sale.getId(), sale);
    }

    public String getLastSaleString(Location where, GoodsType what) {
        LastSale data = this.getLastSale(where, what);
        return data == null ? null : String.valueOf(data.getPrice());
    }

    public StringTemplate getLastSaleTip(Location where, GoodsType what) {
        LastSale data = this.getLastSale(where, what);
        return data == null ? null : (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template("model.indianSettlement.lastSale").addNamed("%goodsType%", what)).addAmount("%price%", data.getPrice())).addStringTemplate("%turn%", data.getWhen().getLabel());
    }

    public int getArrears(GoodsType type) {
        Market market = this.getMarket();
        return market == null ? 0 : market.getArrears(type);
    }

    public boolean canTrade(GoodsType type) {
        return this.canTrade(type, Market.Access.EUROPE);
    }

    public boolean canTrade(GoodsType type, Market.Access access) {
        return this.getArrears(type) == 0 || access == Market.Access.CUSTOM_HOUSE && (this.getSpecification().getBoolean("model.option.customIgnoreBoycott") || this.hasAbility("model.ability.customHouseTradesWithForeignCountries") && CollectionUtils.any(this.getGame().getLiveEuropeanPlayers(this), p -> this.getStance((Player)p) == Stance.PEACE || this.getStance((Player)p) == Stance.ALLIANCE));
    }

    public int getSales(GoodsType goodsType) {
        Market market = this.getMarket();
        return market == null ? 0 : market.getSales(goodsType);
    }

    public void modifySales(GoodsType goodsType, int amount) {
        Market market = this.getMarket();
        if (market != null) {
            market.modifySales(goodsType, amount);
        }
    }

    public boolean hasTraded(GoodsType goodsType) {
        Market market = this.getMarket();
        return market == null ? false : market.hasBeenTraded(goodsType);
    }

    public Goods getMostValuableGoods() {
        if (!this.isEuropean()) {
            return null;
        }
        Market market = this.getMarket();
        if (market == null) {
            return null;
        }
        Predicate<Goods> boycottPred = g -> this.getArrears(g.getType()) <= 0 && this.hasTraded(g.getType());
        Comparator<Goods> tradedValueComp = Comparator.comparingInt(g -> market.getSalePrice(g.getType(), Math.min(g.getAmount(), 100)));
        return CollectionUtils.maximize(CollectionUtils.flatten(this.getColonies(), c -> c.getCompactGoodsList().stream()), boycottPred, tradedValueComp);
    }

    public int getIncomeBeforeTaxes(GoodsType goodsType) {
        Market market = this.getMarket();
        return market == null ? 0 : market.getIncomeBeforeTaxes(goodsType);
    }

    public void modifyIncomeBeforeTaxes(GoodsType goodsType, int amount) {
        Market market = this.getMarket();
        if (market != null) {
            market.modifyIncomeBeforeTaxes(goodsType, amount);
        }
    }

    public int getIncomeAfterTaxes(GoodsType goodsType) {
        Market market = this.getMarket();
        return market == null ? 0 : market.getIncomeAfterTaxes(goodsType);
    }

    public void modifyIncomeAfterTaxes(GoodsType goodsType, int amount) {
        Market market = this.getMarket();
        if (market != null) {
            market.modifyIncomeAfterTaxes(goodsType, amount);
        }
    }

    public Europe getEurope() {
        return this.europe;
    }

    public void setEurope(Europe europe) {
        this.europe = europe;
    }

    public boolean canMoveToEurope() {
        return this.getEurope() != null;
    }

    public int getEuropeanRecruitPrice() {
        return this.getEurope().getCurrentRecruitPrice();
    }

    public int getEuropeanPurchasePrice(AbstractUnit au) {
        Specification spec = this.getSpecification();
        UnitType unitType = au.getType(spec);
        Market market = this.getMarket();
        if (market == null || !unitType.hasPrice()) {
            return Integer.MAX_VALUE;
        }
        return au.getNumber() * (this.getEurope().getUnitPrice(unitType) + au.getRole(spec).getRequiredGoodsPrice(market));
    }

    public int getMercenaryHirePrice(AbstractUnit au) {
        Specification spec = this.getSpecification();
        UnitType unitType = au.getType(spec);
        int price = unitType.getMercenaryPrice();
        if (price < 0) {
            price = unitType.getPrice();
        }
        return price * au.getNumber();
    }

    public Monarch getMonarch() {
        return this.monarch;
    }

    public void setMonarch(Monarch monarch) {
        this.monarch = monarch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnit(Unit unit) {
        Set<Unit> set = this.units;
        synchronized (set) {
            return this.units.contains(unit);
        }
    }

    public Stream<Unit> getUnits() {
        return this.getUnitSet().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Unit> getUnitSet() {
        Set<Unit> set = this.units;
        synchronized (set) {
            return this.units.isEmpty() ? Collections.emptySet() : new HashSet<Unit>(this.units);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnitCount() {
        Set<Unit> set = this.units;
        synchronized (set) {
            return this.units.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unit getUnitByName(String name) {
        Set<Unit> set = this.units;
        synchronized (set) {
            return CollectionUtils.find(this.units, CollectionUtils.matchKeyEquals(name, Unit::getName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addUnit(Unit newUnit) {
        if (newUnit == null) {
            return false;
        }
        if (!this.owns(newUnit)) {
            throw new IllegalStateException("Adding another players unit:" + newUnit.getId() + " to " + this);
        }
        if (this.hasUnit(newUnit)) {
            return false;
        }
        Set<Unit> set = this.units;
        synchronized (set) {
            return this.units.add(newUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnit(Unit oldUnit) {
        if (oldUnit == null) {
            return false;
        }
        this.nextActiveUnitIterator.remove(oldUnit);
        this.nextGoingToUnitIterator.remove(oldUnit);
        Set<Unit> set = this.units;
        synchronized (set) {
            return this.units.remove(oldUnit);
        }
    }

    public List<Unit> getCarriersForUnit(Unit unit) {
        return CollectionUtils.transform(this.getUnits(), u -> u.couldCarry(unit));
    }

    public int getUnitCount(boolean naval) {
        return CollectionUtils.count(this.getUnits(), u -> u.isNaval() == naval);
    }

    public int getNumberOfKingLandUnits() {
        return CollectionUtils.count(this.getUnits(), u -> u.hasAbility("model.ability.refUnit") && !u.isNaval());
    }

    public boolean hasUnitType(String typeId) {
        return CollectionUtils.any(this.getUnits(), CollectionUtils.matchKeyEquals(typeId, u -> u.getType().getId()));
    }

    public Unit restoreActiveUnit() {
        Game game = this.getGame();
        Unit u = game.getInitialActiveUnit();
        game.setInitialActiveUnitId(null);
        if (u != null && this.owns(u)) {
            return u;
        }
        this.resetIterators();
        return this.getNextActiveUnit();
    }

    public Unit getNextActiveUnit() {
        return this.nextActiveUnitIterator.next();
    }

    public boolean hasNextActiveUnit() {
        return this.nextActiveUnitIterator.hasNext();
    }

    public Unit getNextGoingToUnit() {
        return this.nextGoingToUnitIterator.next();
    }

    public boolean setNextGoingToUnit(Unit unit) {
        return this.nextGoingToUnitIterator.setNext(unit);
    }

    public boolean hasNextGoingToUnit() {
        return this.nextGoingToUnitIterator.hasNext();
    }

    public void resetIterators() {
        this.nextActiveUnitIterator.reset();
        this.nextGoingToUnitIterator.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TradeRoute> getTradeRoutes() {
        List<TradeRoute> list = this.tradeRoutes;
        synchronized (list) {
            return new ArrayList<TradeRoute>(this.tradeRoutes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTradeRouteCount() {
        List<TradeRoute> list = this.tradeRoutes;
        synchronized (list) {
            return this.tradeRoutes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TradeRoute getNewestTradeRoute() {
        List<TradeRoute> list = this.tradeRoutes;
        synchronized (list) {
            return this.tradeRoutes.isEmpty() ? null : this.tradeRoutes.get(this.tradeRoutes.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTradeRoute(TradeRoute tradeRoute) {
        String name;
        if (tradeRoute != null && (name = tradeRoute.getName()) != null && this.getTradeRouteByName(name, tradeRoute) == null) {
            List<TradeRoute> list = this.tradeRoutes;
            synchronized (list) {
                this.tradeRoutes.add(tradeRoute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TradeRoute getTradeRouteByName(String name, TradeRoute exclude) {
        List<TradeRoute> list = this.tradeRoutes;
        synchronized (list) {
            return CollectionUtils.find(this.tradeRoutes, t -> t != exclude && t.getName().equals(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Unit> removeTradeRoute(TradeRoute tradeRoute) {
        List<Object> ret;
        List<TradeRoute> list = this.tradeRoutes;
        synchronized (list) {
            ret = !this.tradeRoutes.remove(tradeRoute) ? Collections.emptyList() : tradeRoute.getAssignedUnits();
        }
        for (Unit unit : ret) {
            unit.setTradeRoute(null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTradeRoutes() {
        List<TradeRoute> list = this.tradeRoutes;
        synchronized (list) {
            this.tradeRoutes.clear();
        }
    }

    public String getNameForTradeRoute() {
        return NameCache.getTradeRouteName(this);
    }

    public boolean addOwnable(Ownable o) {
        return o instanceof Settlement ? this.addSettlement((Settlement)o) : (o instanceof Unit ? this.addUnit((Unit)o) : false);
    }

    public boolean removeOwnable(Ownable o) {
        return o instanceof Settlement ? this.removeSettlement((Settlement)o) : (o instanceof Unit ? this.removeUnit((Unit)o) : false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Settlement> getSettlementList() {
        List<Settlement> list = this.settlements;
        synchronized (list) {
            return new ArrayList<Settlement>(this.settlements);
        }
    }

    public Stream<Settlement> getSettlements() {
        return this.getSettlementList().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSettlements() {
        List<Settlement> list = this.settlements;
        synchronized (list) {
            return !this.settlements.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSettlementCount() {
        List<Settlement> list = this.settlements;
        synchronized (list) {
            return this.settlements.size();
        }
    }

    public int getNumberOfPorts() {
        return !this.isEuropean() ? 0 : CollectionUtils.count(this.getColonies(), Settlement::isConnectedPort);
    }

    public List<Colony> getConnectedPortList() {
        return !this.isEuropean() ? Collections.emptyList() : CollectionUtils.transform(this.getColonies(), Settlement::isConnectedPort);
    }

    public Stream<Colony> getConnectedPorts() {
        return this.getConnectedPortList().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSettlement(Settlement settlement) {
        List<Settlement> list = this.settlements;
        synchronized (list) {
            return this.settlements.contains(settlement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSettlement(Settlement settlement) {
        if (settlement == null) {
            return false;
        }
        if (!this.owns(settlement)) {
            throw new IllegalStateException("Does not own: " + settlement);
        }
        if (this.hasSettlement(settlement)) {
            return false;
        }
        List<Settlement> list = this.settlements;
        synchronized (list) {
            if (this.colonyComparator == null) {
                this.settlements.add(settlement);
            } else {
                Colony s;
                int i;
                Colony c = (Colony)settlement;
                for (i = this.settlements.size() - 1; i >= 0 && this.colonyComparator.compare(c, s = (Colony)this.settlements.get(i)) < 0; --i) {
                }
                this.settlements.add(i + 1, settlement);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSettlement(Settlement settlement) {
        List<Settlement> list = this.settlements;
        synchronized (list) {
            return this.settlements.remove(settlement);
        }
    }

    public int getColoniesPopulation() {
        return CollectionUtils.sum(this.getColonies(), Colony::getUnitCount);
    }

    public Colony getColonyByName(String name) {
        return CollectionUtils.find(this.getColonies(), CollectionUtils.matchKeyEquals(name, Settlement::getName));
    }

    public IndianSettlement getIndianSettlementByName(String name) {
        return CollectionUtils.find(this.getIndianSettlements(), CollectionUtils.matchKeyEquals(name, Settlement::getName));
    }

    public Stream<Colony> getColonies() {
        return this.getColonyList().stream();
    }

    public List<Colony> getColonyList() {
        return CollectionUtils.transform(this.getSettlements(), s -> s instanceof Colony, s -> (Colony)s);
    }

    public List<Colony> getSortedColonies(Comparator<Colony> comp) {
        return CollectionUtils.transform(this.getSettlements(), s -> s instanceof Colony, s -> (Colony)s, comp);
    }

    public Stream<IndianSettlement> getIndianSettlements() {
        return this.getIndianSettlementList().stream();
    }

    public List<IndianSettlement> getIndianSettlementList() {
        return CollectionUtils.transform(this.getSettlements(), s -> s instanceof IndianSettlement, s -> (IndianSettlement)s);
    }

    public List<IndianSettlement> getIndianSettlementsWithMissionaryList(Player p) {
        Predicate<Settlement> isPred = s -> s instanceof IndianSettlement && ((IndianSettlement)s).hasMissionary(p);
        return CollectionUtils.transform(this.getSettlements(), isPred, s -> (IndianSettlement)s);
    }

    public Stream<IndianSettlement> getIndianSettlementsWithMissionary(Player p) {
        return this.getIndianSettlementsWithMissionaryList(p).stream();
    }

    public Settlement getSettlementByName(String name) {
        return this.isIndian() ? this.getIndianSettlementByName(name) : this.getColonyByName(name);
    }

    public Settlement getClosestPortForEurope() {
        Comparator<Settlement> comp = Comparator.comparingInt(Settlement::getHighSeasCount);
        return CollectionUtils.minimize(this.getSettlements(), comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModelMessage> getModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            return new ArrayList<ModelMessage>(this.modelMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModelMessage> getNewModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            return CollectionUtils.transform(this.modelMessages, m -> !m.getDisplayed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelMessage(ModelMessage modelMessage) {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            this.modelMessages.add(modelMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refilterModelMessages(OptionGroup options) {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            CollectionUtils.removeInPlace(this.modelMessages, m -> !options.getBoolean(m.getMessageType().getOptionName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisplayedModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            CollectionUtils.removeInPlace(this.modelMessages, ModelMessage::getDisplayed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearModelMessages() {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            this.modelMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModelMessages(List<ModelMessage> modelMessages) {
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            this.modelMessages.clear();
            this.modelMessages.addAll(modelMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void divertModelMessages(FreeColGameObject source, FreeColGameObject newSource) {
        Predicate<ModelMessage> sourcePred = m -> Utils.equals(m.getSourceId(), source.getId());
        List<ModelMessage> list = this.modelMessages;
        synchronized (list) {
            if (newSource == null) {
                CollectionUtils.removeInPlace(this.modelMessages, sourcePred);
            } else {
                for (ModelMessage m2 : CollectionUtils.transform(this.modelMessages, sourcePred)) {
                    m2.divert(newSource);
                }
            }
        }
    }

    public void addStartGameMessage() {
        Tile tile = this.getEntryTile();
        String sailTag = tile == null ? "unknown" : (tile.getX() < tile.getMap().getWidth() / 2 ? "east" : "west");
        this.addModelMessage((ModelMessage)new ModelMessage(ModelMessage.MessageType.TUTORIAL, "model.player.startGame", this).addTagged("%direction%", sailTag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<HistoryEvent> getHistory() {
        List<HistoryEvent> list = this.history;
        synchronized (list) {
            return new ArrayList<HistoryEvent>(this.history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(HistoryEvent event) {
        List<HistoryEvent> list = this.history;
        synchronized (list) {
            this.history.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistory() {
        List<HistoryEvent> list = this.history;
        synchronized (list) {
            this.history.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHistory(List<HistoryEvent> history) {
        List<HistoryEvent> list = this.history;
        synchronized (list) {
            this.history.clear();
            this.history.addAll(history);
        }
    }

    public Tile getEntryTile() {
        return this.entryTile;
    }

    public void setEntryTile(Tile entryTile) {
        this.entryTile = entryTile;
    }

    public Tile getFallbackTile() {
        Settlement settlement = CollectionUtils.first(this.getSettlements());
        return settlement != null ? settlement.getTile() : this.getEntryTile();
    }

    public final HighSeas getHighSeas() {
        return this.highSeas;
    }

    public void initializeHighSeas() {
        Game game = this.getGame();
        this.highSeas = new HighSeas(game);
        if (this.europe != null) {
            this.highSeas.addDestination(this.europe);
        }
        if (game.getMap() != null) {
            this.highSeas.addDestination(game.getMap());
        }
    }

    public boolean hasExplored(Tile tile) {
        return tile.isExplored();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCanSeeTiles() {
        Object object = this.canSeeLock;
        synchronized (object) {
            this.canSeeValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSee(Tile tile) {
        if (tile == null) {
            return false;
        }
        Map map = this.getGame().getMap();
        if (map == null) {
            return false;
        }
        Object object = this.canSeeLock;
        synchronized (object) {
            if (!this.canSeeValid) {
                this.canSeeTiles = this.makeCanSeeTiles(map);
                this.canSeeValid = true;
            }
            return this.canSeeTiles[tile.getX()][tile.getY()];
        }
    }

    public boolean canSeeUnit(Unit unit) {
        Tile tile;
        return this.owns(unit) ? true : ((tile = unit.getTile()) == null ? false : (!this.canSee(tile) ? false : (tile.hasSettlement() ? false : !unit.isOnCarrier())));
    }

    public Set<Tile> getVisibleTileSet() {
        Specification spec = this.getSpecification();
        HashSet<Tile> tiles = new HashSet<Tile>();
        if (spec.getBoolean("model.option.fogOfWar")) {
            List<Settlement> settlements = this.hasAbility("model.ability.seeAllColonies") ? this.getGame().getAllColoniesList(null) : this.getSettlementList();
            for (Settlement s : settlements) {
                tiles.addAll(s.getVisibleTileSet());
            }
            for (Unit u : CollectionUtils.transform(this.getUnitSet(), Unit::isOnTile)) {
                tiles.addAll(u.getVisibleTileSet());
            }
            if (this.isEuropean() && spec.getBoolean("model.option.enhancedMissionaries")) {
                for (Player other : this.getGame().getLiveNativePlayerList(this)) {
                    for (IndianSettlement is : other.getIndianSettlementsWithMissionaryList(this)) {
                        tiles.addAll(is.getVisibleTileSet());
                    }
                }
            }
        } else {
            this.getGame().getMap().forEachTile(t -> this.hasExplored((Tile)t), t -> tiles.add((Tile)t));
        }
        return tiles;
    }

    private boolean[][] makeCanSeeTiles(Map map) {
        Specification spec = this.getSpecification();
        boolean[][] cST = new boolean[map.getWidth()][map.getHeight()];
        Set<Tile> visible = this.getVisibleTileSet();
        if (spec.getBoolean("model.option.fogOfWar")) {
            for (Tile t : visible) {
                cST[t.getX()][t.getY()] = true;
                t.seeTile(this);
            }
        } else {
            for (Tile t : visible) {
                cST[t.getX()][t.getY()] = true;
            }
        }
        return cST;
    }

    protected java.util.Map<Player, Tension> getTension() {
        return this.tension;
    }

    protected void setTension(java.util.Map<Player, Tension> tension) {
        this.tension.clear();
        this.tension.putAll(tension);
    }

    public Tension getTension(Player player) {
        if (player == null) {
            throw new RuntimeException("Null player: " + this);
        }
        Tension newTension = this.tension.get(player);
        if (newTension == null) {
            newTension = new Tension(0);
            this.tension.put(player, newTension);
        }
        return newTension;
    }

    public void setTension(Player player, Tension newTension) {
        if (player == this || player == null) {
            return;
        }
        this.tension.put(player, newTension);
    }

    public void removeTension(Player player) {
        if (player != null) {
            this.tension.remove(player);
        }
    }

    protected Set<Player> getBannedMissions() {
        return this.bannedMissions == null ? Collections.emptySet() : this.bannedMissions;
    }

    protected void setBannedMissions(Collection<Player> bannedMissions) {
        if (this.bannedMissions == null) {
            this.bannedMissions = new HashSet<Player>();
        } else {
            this.bannedMissions.clear();
        }
        this.bannedMissions.addAll(bannedMissions);
    }

    public boolean missionsBanned(Player player) {
        return this.bannedMissions != null && this.bannedMissions.contains(player);
    }

    public void addMissionBan(Player player) {
        if (this.bannedMissions == null) {
            this.bannedMissions = new HashSet<Player>();
        }
        this.bannedMissions.add(player);
    }

    public void removeMissionBan(Player player) {
        if (this.bannedMissions != null) {
            this.bannedMissions.remove(player);
        }
    }

    protected java.util.Map<String, Stance> getStances() {
        return this.stance;
    }

    protected void setStances(java.util.Map<String, Stance> stances) {
        this.stance.clear();
        this.stance.putAll(stances);
    }

    public Stance getStance(Player player) {
        return player == null || this.stance.get(player.getId()) == null ? Stance.UNCONTACTED : this.stance.get(player.getId());
    }

    public boolean setStance(Player player, Stance newStance) {
        if (player == null) {
            throw new RuntimeException("Player must not be 'null': " + this);
        }
        if (player == this) {
            throw new RuntimeException("Cannot set the stance towards ourselves: " + this);
        }
        if (newStance == null) {
            this.stance.remove(player.getId());
            return true;
        }
        Stance oldStance = this.stance.get(player.getId());
        if (newStance == oldStance) {
            return true;
        }
        boolean valid = true;
        if (newStance == Stance.CEASE_FIRE && oldStance != Stance.WAR || newStance == Stance.UNCONTACTED) {
            valid = false;
        }
        this.stance.put(player.getId(), newStance);
        return valid;
    }

    public boolean atWarWith(Player player) {
        return this.getStance(player) == Stance.WAR;
    }

    public boolean isAtWar() {
        return CollectionUtils.any(this.getGame().getLivePlayers(new Player[0]), p -> this.atWarWith((Player)p));
    }

    public boolean hasContacted(Player player) {
        return this.getStance(player) != Stance.UNCONTACTED;
    }

    public boolean hasContactedEuropeans() {
        return CollectionUtils.any(this.getGame().getLiveEuropeanPlayers(this), p -> this.hasContacted((Player)p));
    }

    public boolean hasContactedIndians() {
        return CollectionUtils.any(this.getGame().getLiveNativePlayers(this), p -> this.hasContacted((Player)p));
    }

    public static void makeContact(Player player1, Player player2) {
        player1.stance.put(player2.getId(), Stance.PEACE);
        player2.stance.put(player1.getId(), Stance.PEACE);
        player1.setTension(player2, new Tension(0));
        player2.setTension(player1, new Tension(0));
    }

    public int getLandPrice(Tile tile) {
        Specification spec = this.getSpecification();
        Player nationOwner = tile.getOwner();
        if (nationOwner == null || nationOwner == this) {
            return 0;
        }
        if (tile.hasSettlement()) {
            return -1;
        }
        if (nationOwner.isEuropean()) {
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement().getOwner() == nationOwner) {
                return -1;
            }
            return 0;
        }
        int price = spec.getInteger("model.option.landPriceFactor") * CollectionUtils.sum(spec.getGoodsTypeList(), gt -> gt != spec.getPrimaryFoodType(), gt -> tile.getPotentialProduction((GoodsType)gt, null)) + 100;
        return (int)this.apply(price, this.getGame().getTurn(), "model.modifier.landPaymentModifier");
    }

    public NationSummary getNationSummary(Player player) {
        return this.nationCache.get(player);
    }

    public void putNationSummary(Player player, NationSummary ns) {
        this.nationCache.put(player, ns);
    }

    public void clearNationSummary(Player player) {
        this.nationCache.remove(player);
    }

    public void clearNationCache() {
        this.nationCache.clear();
    }

    public double getStrengthRatio(Player other, boolean naval) {
        NationSummary ns = this.getNationSummary(other);
        if (ns == null) {
            return -1.0;
        }
        int strength = this.calculateStrength(naval);
        return Player.strengthRatio(strength, ns.getMilitaryStrength());
    }

    public static double strengthRatio(double ours, double theirs) {
        return ours == 0.0 ? 0.0 : ours / (ours + theirs);
    }

    public boolean canOwnTile(Tile tile) {
        return this.canOwnTileReason(tile) == NoClaimReason.NONE;
    }

    private NoClaimReason canOwnTileReason(Tile tile) {
        return CollectionUtils.any(tile.getUnits(), u -> u.getOwner() != this && u.isOffensiveUnit()) ? NoClaimReason.OCCUPIED : (this.isEuropean() ? (tile.hasLostCityRumour() ? NoClaimReason.RUMOUR : NoClaimReason.NONE) : (tile.isLand() ? NoClaimReason.NONE : NoClaimReason.WATER));
    }

    public boolean canClaimForSettlement(Tile tile) {
        return this.canClaimForSettlementReason(tile) == NoClaimReason.NONE;
    }

    public NoClaimReason canClaimForSettlementReason(Tile tile) {
        int price;
        NoClaimReason reason = this.canOwnTileReason(tile);
        NoClaimReason noClaimReason = reason != NoClaimReason.NONE ? reason : (tile.hasSettlement() ? NoClaimReason.SETTLEMENT : (tile.getOwner() == null ? NoClaimReason.NONE : (tile.getOwner() == this ? (tile.isInUse() ? NoClaimReason.WORKED : NoClaimReason.NONE) : ((price = this.getLandPrice(tile)) < 0 ? NoClaimReason.EUROPEANS : (price > 0 ? NoClaimReason.NATIVES : NoClaimReason.NONE)))));
        return noClaimReason;
    }

    public boolean canClaimToFoundSettlement(Tile tile) {
        return this.canClaimToFoundSettlementReason(tile) == NoClaimReason.NONE;
    }

    public NoClaimReason canClaimToFoundSettlementReason(Tile tile) {
        NoClaimReason reason;
        return !tile.getType().canSettle() ? NoClaimReason.TERRAIN : ((reason = this.canClaimForSettlementReason(tile)) != NoClaimReason.NATIVES ? reason : (!tile.getAdjacentColonies().isEmpty() ? NoClaimReason.SETTLEMENT : (this.canClaimFreeCenterTile(tile) ? NoClaimReason.NONE : NoClaimReason.NATIVES)));
    }

    private boolean canClaimFreeCenterTile(Tile tile) {
        Specification spec = this.getGame().getSpecification();
        String build = spec.getString("model.option.buildOnNativeLand");
        return this.isEuropean() && tile.getOwner() != null && tile.getOwner().isIndian() && ("model.option.buildOnNativeLand.always".equals(build) || "model.option.buildOnNativeLand.first".equals(build) && this.hasZeroSettlements() || "model.option.buildOnNativeLand.firstAndUncontacted".equals(build) && this.hasZeroSettlements() && (tile.getOwner() == null || tile.getOwner().getStance(this) == Stance.UNCONTACTED));
    }

    private boolean hasZeroSettlements() {
        List<Settlement> settlements = this.getSettlementList();
        return settlements.isEmpty() || settlements.size() == 1 && settlements.get(0).getTile().getSettlement() == null;
    }

    public boolean canClaimForImprovement(Tile tile) {
        Player owner = tile.getOwner();
        return owner == null || owner == this || this.getLandPrice(tile) == 0;
    }

    public boolean canAcquireForImprovement(Tile tile) {
        return this.canClaimForImprovement(tile) || this.getLandPrice(tile) > 0;
    }

    public List<Tile> getClaimableTiles(Tile centerTile, int radius) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        ArrayList<Tile> layer = new ArrayList<Tile>();
        if (this.canClaimToFoundSettlement(centerTile)) {
            layer.add(centerTile);
            for (int r = 1; r <= radius; ++r) {
                ArrayList lastLayer = new ArrayList(layer);
                tiles.addAll(layer);
                layer.clear();
                layer.addAll(CollectionUtils.transform(CollectionUtils.flatten(lastLayer, ll -> ll.getSurroundingTiles(1, 1).stream()), t -> !tiles.contains(t) && this.canClaimForSettlement((Tile)t)));
            }
            tiles.addAll(layer);
        }
        return tiles;
    }

    public List<Double> getAllColonyValues(Tile tile) {
        int initialFood;
        int LOW_SETTLEMENT_NUMBER = 3;
        int LONG_PATH_TILES = 12;
        double MOD_HAS_RESOURCE = 0.75;
        double MOD_FOOD_LOW = 0.75;
        double MOD_INITIAL_FOOD = 2.0;
        double MOD_STEAL = 0.5;
        double MOD_INLAND = 0.5;
        double MOD_OWNED_EUROPEAN = 0.67;
        double MOD_OWNED_NATIVE = 0.8;
        double MOD_HIGH_PRODUCTION = 1.2;
        double MOD_GOOD_PRODUCTION = 1.1;
        double[] MOD_OWN_COLONY = new double[]{0.0, 0.0, 0.0, 2.0, 0.75, 0.9, 1.5, 1.0, 1.0, 1.25};
        double[] MOD_ENEMY_COLONY = new double[]{0.0, 0.0, 0.0, 0.7, 0.5, 0.9, 1.25, 1.0, 1.0, 1.1};
        double[] MOD_NEUTRAL_COLONY = new double[]{0.0, 0.0, 0.0, 1.0, 0.8, 0.9, 1.25, 1.0, 1.0, 1.1};
        double[] MOD_INDIAN_SETTLEMENT = new double[]{0.0, 0.0, 0.9, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double[] MOD_ENEMY_UNIT = new double[]{0.4, 0.5, 0.6, 0.75, 0.9, 0.0, 0.0, 0.0, 0.0, 0.0};
        int distanceMax = MOD_OWN_COLONY.length;
        int GOOD_PRODUCTION = 4;
        int HIGH_PRODUCTION = 8;
        int FOOD_LOW = 4;
        boolean FOOD_VERY_LOW = true;
        List<Double> values = CollectionUtils.transform(ColonyValueCategory.values(), CollectionUtils.alwaysTrue(), v -> 1.0);
        double development = (double)Math.min(3, this.getSettlementCount()) / 3.0;
        int portCount = this.getNumberOfPorts();
        if (tile.isPolar() && this.getSettlementCount() < 3) {
            values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.POLAR.getDouble());
            return values;
        }
        switch (this.canClaimToFoundSettlementReason(tile)) {
            case NONE: {
                break;
            }
            case TERRAIN: 
            case WATER: {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.TERRAIN.getDouble());
                return values;
            }
            case RUMOUR: {
                if (!this.hasSettlements()) {
                    values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.RUMOUR.getDouble());
                    return values;
                }
                values.set(ColonyValueCategory.A_TILE.ordinal(), development);
                break;
            }
            case OCCUPIED: {
                values.set(ColonyValueCategory.A_TILE.ordinal(), MOD_ENEMY_UNIT[0]);
                break;
            }
            case SETTLEMENT: 
            case WORKED: 
            case EUROPEANS: {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                return values;
            }
            case NATIVES: {
                if (tile.getOwningSettlement() != null && tile.getOwningSettlement().getTile() != null && tile.getOwningSettlement().getTile().isAdjacent(tile)) {
                    values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                    return values;
                }
                int price = this.getLandPrice(tile);
                if (price <= 0 || portCount <= 0 || this.checkGold(price)) break;
                values.set(ColonyValueCategory.A_TILE.ordinal(), 0.5);
                break;
            }
            default: {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.BOGUS.getDouble());
                return values;
            }
        }
        Specification spec = this.getSpecification();
        TypeCountMap<GoodsType> production = new TypeCountMap<GoodsType>();
        GoodsType foodType = spec.getPrimaryFoodType();
        AbstractGoods bestFood = tile.getBestFoodProduction();
        int n = initialFood = bestFood == null ? 0 : bestFood.getAmount();
        if (initialFood <= 1) {
            values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.FOOD.getDouble());
            return values;
        }
        production.incrementCount(foodType, initialFood);
        values.set(ColonyValueCategory.A_PROD.ordinal(), (double)initialFood * (double)foodType.getProductionWeight());
        int tilesToHighSeas = tile.getHighSeasCount();
        if (tilesToHighSeas < 0) {
            if (portCount < 3) {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.INLAND.getDouble());
                return values;
            }
            values.set(ColonyValueCategory.A_EUROPE.ordinal(), 0.5);
        } else if (tilesToHighSeas >= 12) {
            double trip = 12.0 / (double)tilesToHighSeas;
            values.set(ColonyValueCategory.A_EUROPE.ordinal(), Math.pow(trip, 2.0 - development));
        } else {
            values.set(ColonyValueCategory.A_EUROPE.ordinal(), 1.0 + 0.25 * (12.0 / (double)(12 - tilesToHighSeas)));
        }
        values.set(ColonyValueCategory.A_RESOURCE.ordinal(), tile.hasResource() ? 0.75 : 1.0);
        HashSet<GoodsType> highProduction = new HashSet<GoodsType>();
        HashSet<GoodsType> goodProduction = new HashSet<GoodsType>();
        int land = 0;
        for (Tile t : CollectionUtils.transform(tile.getSurroundingTiles(1, 1), CollectionUtils.isNotNull(Tile::getType))) {
            if (t.getSettlement() != null) {
                values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                return values;
            }
            if (t.isLand()) {
                ++land;
            }
            double pf = 1.0;
            if (t.getOwner() != null && !this.owns(t)) {
                if (t.getOwner().isEuropean()) {
                    if (portCount < 3) {
                        values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.SETTLED.getDouble());
                        return values;
                    }
                    values.set(ColonyValueCategory.A_ADJACENT.ordinal(), values.get(ColonyValueCategory.A_ADJACENT.ordinal()) * 0.67 * development);
                    continue;
                }
                pf = 0.8;
                if (portCount > 0) {
                    pf *= development;
                }
            }
            for (AbstractGoods ag : t.getSortedPotential()) {
                GoodsType type = ag.getType();
                if (type.isFoodType()) {
                    type = foodType;
                }
                int amount = ag.getAmount();
                if (!t.isLand()) {
                    amount = (int)((double)amount * development);
                }
                values.set(ColonyValueCategory.A_PROD.ordinal(), values.get(ColonyValueCategory.A_PROD.ordinal()) + (double)((float)amount * type.getProductionWeight()) * pf);
                production.incrementCount(type, amount);
                if (amount > 8) {
                    highProduction.add(type);
                    continue;
                }
                if (amount <= 4) continue;
                goodProduction.add(type);
            }
            for (Unit u2 : CollectionUtils.transform(t.getUnits(), u -> !this.owns((Ownable)u) && u.isOffensiveUnit() && this.atWarWith(u.getOwner()))) {
                values.set(ColonyValueCategory.A_ADJACENT.ordinal(), values.get(ColonyValueCategory.A_ADJACENT.ordinal()) * MOD_ENEMY_UNIT[1]);
            }
        }
        if (land <= 1) {
            values.set(ColonyValueCategory.A_OVERRIDE.ordinal(), NoValueType.ISLAND1.getDouble());
            return values;
        }
        for (GoodsType g : highProduction) {
            values.set(ColonyValueCategory.A_LEVEL.ordinal(), values.get(ColonyValueCategory.A_LEVEL.ordinal()) * 1.2);
            goodProduction.remove(g);
        }
        if (!goodProduction.isEmpty()) {
            values.set(ColonyValueCategory.A_LEVEL.ordinal(), values.get(ColonyValueCategory.A_LEVEL.ordinal()) * 1.1 * (double)goodProduction.size());
        }
        Predicate<Unit> hostileUnitPred = u -> !this.owns((Ownable)u) && u.isOffensiveUnit() && this.atWarWith(u.getOwner());
        for (int radius = 1; radius < distanceMax; ++radius) {
            for (Tile t : this.getGame().getMap().getCircleTiles(tile, false, radius)) {
                Settlement settlement = t.getSettlement();
                if (settlement == null) continue;
                if (settlement instanceof IndianSettlement) {
                    values.set(ColonyValueCategory.A_NEARBY.ordinal(), values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_INDIAN_SETTLEMENT[radius]);
                    continue;
                }
                if (this.owns(settlement)) {
                    values.set(ColonyValueCategory.A_NEARBY.ordinal(), values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_OWN_COLONY[radius]);
                    continue;
                }
                if (this.atWarWith(settlement.getOwner())) {
                    values.set(ColonyValueCategory.A_NEARBY.ordinal(), values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_ENEMY_COLONY[radius]);
                    continue;
                }
                values.set(ColonyValueCategory.A_NEARBY.ordinal(), values.get(ColonyValueCategory.A_NEARBY.ordinal()) * MOD_NEUTRAL_COLONY[radius]);
            }
        }
        if (production.getCount(foodType) < 4) {
            values.set(ColonyValueCategory.A_FOOD.ordinal(), values.get(ColonyValueCategory.A_FOOD.ordinal()) * 0.75);
        }
        int a = ColonyValueCategory.A_GOODS.ordinal() - 1;
        for (GoodsType type : production.keySet()) {
            Integer amount = production.getCount(type);
            double threshold = type.getLowProductionThreshold();
            if (!(threshold > 0.0)) continue;
            if (++a == values.size()) {
                values.add(1.0);
            }
            if (!((double)amount.intValue() < threshold)) continue;
            double fraction = (double)amount.intValue() / threshold;
            double zeroValue = type.getZeroProductionFactor();
            values.set(a, (1.0 - fraction) * zeroValue + fraction);
        }
        return values;
    }

    public int getColonyValue(Tile tile) {
        List<Double> values = this.getAllColonyValues(tile);
        if (values.get(0) < 0.0) {
            return (int)Math.round(values.get(0));
        }
        double v = 1.0;
        for (Double d : values) {
            v *= d.doubleValue();
        }
        return (int)Math.round(v);
    }

    public void logCheat(String what) {
        logger.finest("CHEAT: " + this.getGame().getTurn().getNumber() + " " + StringUtils.lastPart(this.getNationId(), ".") + " " + what);
    }

    public int getMaximumFoodConsumption() {
        if (this.maximumFoodConsumption < 0) {
            Specification spec = this.getSpecification();
            this.maximumFoodConsumption = CollectionUtils.max(spec.getUnitTypeList(), ut -> ut.isAvailableTo(this), ut -> CollectionUtils.sum(spec.getFoodGoodsTypeList(), ft -> ut.getConsumptionOf((GoodsType)ft)));
        }
        return this.maximumFoodConsumption;
    }

    public boolean owns(Ownable ownable) {
        return ownable == null ? false : this.equals(ownable.getOwner());
    }

    public <T extends FreeColGameObject> T getOurFreeColGameObject(String id, Class<T> returnClass) {
        T t = this.getGame().getFreeColGameObject(id, returnClass);
        if (t == null) {
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(id);
            throw new RuntimeException("Not a " + returnClass.getName() + ": " + id + "/" + fcgo);
        }
        if (t instanceof Ownable) {
            if (!this.owns((Ownable)t)) {
                throw new IllegalStateException(returnClass.getName() + " not owned by " + this.getId() + ": " + id + "/" + t);
            }
        } else {
            throw new RuntimeException("Not ownable: " + id + "/" + t);
        }
        return t;
    }

    public void setColonyComparator(Comparator<Colony> cc) {
        this.colonyComparator = cc;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        for (Unit unit : this.getUnitSet()) {
            if (unit.getOwner() == null) {
                if (fix) {
                    unit.setOwner(this);
                    lb.add("\n  Unit without owner assigned: ", unit.getId());
                    result = result.fix();
                    continue;
                }
                lb.add("\n  Unit without owner: ", unit.getId());
                result = result.fail();
                continue;
            }
            result = result.combine(unit.checkIntegrity(fix, lb));
        }
        if (this.monarch != null) {
            result = result.combine(this.monarch.checkIntegrity(fix, lb));
        }
        for (TradeRoute tr : new ArrayList<TradeRoute>(this.tradeRoutes)) {
            Constants.IntegrityType tri = tr.checkIntegrity(fix, lb);
            if (!tri.safe()) {
                lb.add("\n  Dropping trade route: " + tr.getId());
                this.removeTradeRoute(tr);
                result = result.fix();
                continue;
            }
            result = result.combine(tri);
        }
        return result;
    }

    @Override
    public final FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    @Override
    public int getClassIndex() {
        return 10;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Player o = this.copyInCast(other, Player.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.name = o.getName();
        this.independentNationName = o.getIndependentNationName();
        this.playerType = o.getPlayerType();
        this.changeNationType(o.getNationType());
        this.nationId = o.getNationId();
        this.newLandName = o.getNewLandName();
        this.admin = o.isAdmin();
        this.ai = o.isAI();
        this.ready = o.getReady();
        this.dead = o.getDead();
        this.attackedByPrivateers = o.getAttackedByPrivateers();
        this.bankrupt = o.getBankrupt();
        this.score = o.getScore();
        this.gold = o.getGold();
        this.immigration = o.getImmigration();
        this.immigrationRequired = o.getImmigrationRequired();
        this.liberty = o.getLiberty();
        this.oldSoL = o.getOldSoL();
        this.interventionBells = o.getInterventionBells();
        this.tax = o.getTax();
        this.entryTile = game.update(o.getEntryTile(), true);
        this.market = game.update(o.getMarket(), true);
        this.europe = game.update(o.getEurope(), false);
        this.monarch = game.update(o.getMonarch(), false);
        this.highSeas = game.update(o.getHighSeas(), false);
        this.setFoundingFathers(o.getFoundingFathers());
        this.currentFather = o.getCurrentFather();
        this.setTension(o.getTension());
        this.setBannedMissions(game.updateRef(o.getBannedMissions()));
        this.setStances(o.getStances());
        this.tradeRoutes.clear();
        for (TradeRoute tr : o.getTradeRoutes()) {
            this.tradeRoutes.add(game.update(tr, false));
        }
        this.setHistory(o.getHistory());
        this.setLastSales(o.getLastSales());
        return true;
    }

    @Override
    public FreeColObject getDisplayObject() {
        return this.getNation();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(USERNAME_TAG, this.name);
        xw.writeAttribute(NATION_ID_TAG, this.nationId);
        if (this.nationType != null) {
            xw.writeAttribute(NATION_TYPE_TAG, this.nationType);
        }
        xw.writeAttribute(ADMIN_TAG, this.admin);
        xw.writeAttribute(READY_TAG, this.ready);
        xw.writeAttribute(DEAD_TAG, this.dead);
        xw.writeAttribute(PLAYER_TYPE_TAG, this.playerType);
        xw.writeAttribute(AI_TAG, this.ai);
        if (xw.validFor(this)) {
            xw.writeAttribute(BANKRUPT_TAG, this.bankrupt);
            xw.writeAttribute(TAX_TAG, this.tax);
            xw.writeAttribute(GOLD_TAG, this.gold);
            xw.writeAttribute(IMMIGRATION_TAG, this.immigration);
            xw.writeAttribute(LIBERTY_TAG, this.liberty);
            xw.writeAttribute(INTERVENTION_BELLS_TAG, this.interventionBells);
            if (this.currentFather != null) {
                xw.writeAttribute(CURRENT_FATHER_TAG, this.currentFather);
            }
            xw.writeAttribute(IMMIGRATION_REQUIRED_TAG, this.immigrationRequired);
            xw.writeAttribute(ATTACKED_BY_PRIVATEERS_TAG, this.attackedByPrivateers);
            xw.writeAttribute(OLD_SOL_TAG, this.oldSoL);
            xw.writeAttribute(SCORE_TAG, this.score);
            if (this.entryTile != null) {
                xw.writeAttribute(ENTRY_LOCATION_TAG, this.entryTile);
            }
        }
        if (this.newLandName != null) {
            xw.writeAttribute(NEW_LAND_NAME_TAG, this.newLandName);
        }
        if (this.independentNationName != null) {
            xw.writeAttribute(INDEPENDENT_NATION_NAME_TAG, this.independentNationName);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this)) {
            if (this.market != null) {
                this.market.toXML(xw);
            }
            for (Ability ability : CollectionUtils.transform(this.getSortedAbilities(), Feature::isIndependent)) {
                ability.toXML(xw);
            }
            Turn turn = this.getGame().getTurn();
            for (Modifier modifier : CollectionUtils.transform(this.getSortedModifiers(), m -> m.isTemporary() && !m.isOutOfDate(turn))) {
                modifier.toXML(xw);
            }
            for (Player player : CollectionUtils.sort(this.tension.keySet())) {
                xw.writeStartElement(TENSION_TAG);
                xw.writeAttribute("player", player);
                xw.writeAttribute("value", this.tension.get(player).getValue());
                xw.writeEndElement();
            }
            if (this.bannedMissions != null) {
                for (Player player : CollectionUtils.sort(this.bannedMissions)) {
                    xw.writeStartElement(BAN_MISSIONS_TAG);
                    xw.writeAttribute("player", player.getId());
                    xw.writeEndElement();
                }
            }
            for (Map.Entry<String, Stance> entry : CollectionUtils.mapEntriesByKey(this.stance)) {
                Stance s = entry.getValue();
                if (s == Stance.UNCONTACTED) continue;
                xw.writeStartElement(STANCE_TAG);
                xw.writeAttribute("player", entry.getKey());
                xw.writeAttribute("value", s);
                xw.writeEndElement();
            }
            for (HistoryEvent historyEvent : this.getHistory()) {
                historyEvent.toXML(xw);
            }
            for (TradeRoute tradeRoute : CollectionUtils.sort(this.getTradeRoutes())) {
                tradeRoute.toXML(xw);
            }
            xw.writeToListElement(FOUNDING_FATHERS_TAG, this.foundingFathers);
            xw.writeToListElement(OFFERED_FATHERS_TAG, this.offeredFathers);
            if (this.europe != null) {
                this.europe.toXML(xw);
            }
            if (this.monarch != null) {
                this.monarch.toXML(xw);
            }
            if (this.highSeas != null) {
                this.highSeas.toXML(xw);
            }
            for (ModelMessage modelMessage : this.getModelMessages()) {
                modelMessage.toXML(xw);
            }
            if (this.lastSales != null) {
                for (LastSale lastSale : CollectionUtils.sort(this.lastSales.values())) {
                    lastSale.toXML(xw);
                }
            }
        } else {
            Stance stance;
            Player player = xw.getClientPlayer();
            Tension tension = this.getTension(player);
            xw.writeStartElement(TENSION_TAG);
            xw.writeAttribute("player", player);
            xw.writeAttribute("value", tension.getValue());
            xw.writeEndElement();
            if (this.missionsBanned(player)) {
                xw.writeStartElement(BAN_MISSIONS_TAG);
                xw.writeAttribute("player", player.getId());
                xw.writeEndElement();
            }
            if ((stance = this.getStance(player)) != null && stance != Stance.UNCONTACTED) {
                xw.writeStartElement(STANCE_TAG);
                xw.writeAttribute("player", player);
                xw.writeAttribute("value", stance);
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.name = xr.getAttribute(USERNAME_TAG, null);
        this.nationId = xr.getAttribute(NATION_ID_TAG, null);
        this.nationType = this.isUnknownEnemy() ? null : xr.getType(spec, NATION_TYPE_TAG, NationType.class, null);
        this.admin = xr.getAttribute(ADMIN_TAG, false);
        this.gold = xr.getAttribute(GOLD_TAG, 0);
        this.immigration = xr.getAttribute(IMMIGRATION_TAG, 0);
        this.liberty = xr.getAttribute(LIBERTY_TAG, 0);
        this.interventionBells = xr.getAttribute(INTERVENTION_BELLS_TAG, 0);
        this.oldSoL = xr.getAttribute(OLD_SOL_TAG, 0);
        this.score = xr.getAttribute(SCORE_TAG, 0);
        this.ready = xr.getAttribute(READY_TAG, false);
        this.ai = xr.getAttribute(AI_TAG, false);
        this.dead = xr.getAttribute(DEAD_TAG, false);
        this.bankrupt = xr.getAttribute(BANKRUPT_TAG, false);
        this.tax = xr.getAttribute(TAX_TAG, 0);
        this.changePlayerType(xr.getAttribute(PLAYER_TYPE_TAG, PlayerType.class, null));
        this.currentFather = xr.getType(spec, CURRENT_FATHER_TAG, FoundingFather.class, null);
        this.immigrationRequired = xr.getAttribute(IMMIGRATION_REQUIRED_TAG, 12);
        this.newLandName = xr.getAttribute(NEW_LAND_NAME_TAG, null);
        this.independentNationName = xr.getAttribute(INDEPENDENT_NATION_NAME_TAG, null);
        this.attackedByPrivateers = xr.getAttribute(ATTACKED_BY_PRIVATEERS_TAG, false);
        this.entryTile = xr.makeFreeColObject(game, ENTRY_LOCATION_TAG, Tile.class, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.tension.clear();
        if (this.bannedMissions != null) {
            this.bannedMissions.clear();
        }
        this.stance.clear();
        this.foundingFathers.clear();
        this.offeredFathers.clear();
        this.europe = null;
        this.monarch = null;
        this.clearHistory();
        this.clearTradeRoutes();
        if (xr.getReadScope() == FreeColXMLReader.ReadScope.SERVER) {
            this.clearModelMessages();
        }
        this.lastSales = null;
        this.highSeas = null;
        this.featureContainer.clear();
        if (this.nationType != null) {
            this.addFeatures(this.nationType);
        }
        super.readChildren(xr);
        this.recalculateBellsBonus();
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (BAN_MISSIONS_TAG.equals(tag)) {
            Player player = xr.makeFreeColObject(game, "player", Player.class, true);
            if (player != null && player.isEuropean()) {
                this.addMissionBan(player);
            }
            xr.closeTag(BAN_MISSIONS_TAG);
        } else if (FOUNDING_FATHERS_TAG.equals(tag)) {
            List<FoundingFather> ffs = xr.readList(spec, FOUNDING_FATHERS_TAG, FoundingFather.class);
            if (ffs != null) {
                for (FoundingFather ff : ffs) {
                    this.addFather(ff);
                }
            }
        } else if (OFFERED_FATHERS_TAG.equals(tag)) {
            List<FoundingFather> ofs = xr.readList(spec, OFFERED_FATHERS_TAG, FoundingFather.class);
            this.offeredFathers.addAll(ofs);
        } else if (STANCE_TAG.equals(tag)) {
            Player player = xr.makeFreeColObject(game, "player", Player.class, true);
            this.stance.put(player.getId(), xr.getAttribute("value", Stance.class, Stance.UNCONTACTED));
            xr.closeTag(STANCE_TAG);
        } else if (TENSION_TAG.equals(tag)) {
            this.tension.put(xr.makeFreeColObject(game, "player", Player.class, true), new Tension(xr.getAttribute("value", 0)));
            xr.closeTag(TENSION_TAG);
        } else if ("ability".equals(tag)) {
            Ability ability = new Ability(xr, spec);
            if (ability.isIndependent()) {
                this.addAbility(ability);
            }
        } else if ("europe".equals(tag)) {
            this.europe = xr.readFreeColObject(game, Europe.class);
        } else if ("highSeas".equals(tag)) {
            this.highSeas = xr.readFreeColObject(game, HighSeas.class);
        } else if ("historyEvent".equals(tag)) {
            this.addHistory(new HistoryEvent(xr));
        } else if ("lastSale".equals(tag)) {
            this.addLastSale(new LastSale(xr));
        } else if ("market".equals(tag)) {
            this.market = xr.readFreeColObject(game, Market.class);
        } else if ("modelMessage".equals(tag)) {
            this.addModelMessage(new ModelMessage(xr));
        } else if ("modifier".equals(tag)) {
            Modifier modifier = new Modifier(xr, spec);
            if (modifier.isIndependent()) {
                this.addModifier(modifier);
            }
        } else if ("monarch".equals(tag)) {
            this.monarch = xr.readFreeColObject(game, Monarch.class);
        } else if ("tradeRoute".equals(tag)) {
            this.addTradeRoute(xr.readFreeColObject(game, TradeRoute.class));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return "player";
    }

    @Override
    public String toString() {
        return this.nationId;
    }

    public static enum NoClaimReason implements Named
    {
        NONE,
        TERRAIN,
        RUMOUR,
        WATER,
        OCCUPIED,
        SETTLEMENT,
        WORKED,
        EUROPEANS,
        NATIVES;


        private String getKey() {
            return "noClaimReason." + StringUtils.getEnumKey(this);
        }

        public String getDescriptionKey() {
            return Messages.descriptionKey("model." + this.getKey());
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }

    public static enum NoValueType {
        BOGUS(-1),
        TERRAIN(-2),
        RUMOUR(-3),
        SETTLED(-4),
        FOOD(-5),
        INLAND(-6),
        POLAR(-7),
        ISLAND1(-8);

        private static final int MAX;
        private final int value;

        private NoValueType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public double getDouble() {
            return this.value;
        }

        public static NoValueType fromValue(int i) {
            int n = -i - 1;
            return n >= 0 && n < MAX ? NoValueType.values()[n] : BOGUS;
        }

        static {
            MAX = NoValueType.values().length;
        }
    }

    public static enum ColonyValueCategory {
        A_OVERRIDE,
        A_PROD,
        A_TILE,
        A_EUROPE,
        A_RESOURCE,
        A_ADJACENT,
        A_FOOD,
        A_LEVEL,
        A_NEARBY,
        A_GOODS;


        public String toString() {
            return super.toString().substring(2);
        }
    }

    public static enum PlayerType {
        NATIVE,
        COLONIAL,
        REBEL,
        INDEPENDENT,
        ROYAL,
        UNDEAD,
        RETIRED;

    }
}

