/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivFunction;
import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SingleDataDerivType;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import org.relaxng.datatype.ValidationContext;

class BlankDataDerivType
extends DataDerivType {
    private PatternMemo blankMemo;
    private PatternMemo nonBlankMemo;

    BlankDataDerivType() {
    }

    @Override
    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern, String string, ValidationContext validationContext) {
        if (DataDerivFunction.isBlank(string)) {
            if (this.blankMemo == null) {
                this.blankMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
            }
            return this.blankMemo;
        }
        if (this.nonBlankMemo == null) {
            this.nonBlankMemo = super.dataDeriv(validatorPatternBuilder, pattern, string, validationContext);
        }
        return this.nonBlankMemo;
    }

    @Override
    DataDerivType copy() {
        return new BlankDataDerivType();
    }

    @Override
    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof BlankDataDerivType || dataDerivType instanceof SingleDataDerivType) {
            return this;
        }
        return InconsistentDataDerivType.getInstance();
    }
}

