How to install GNU Stow
=======================

Prerequisites
-------------

Stow is a collection of Perl scripts and modules.  You must have Perl
5.6.1 or later in order for it to run.  The test suite also requires
the `Test::More` and `Test::Output` modules which can be obtained from
CPAN.  They are also available as packages in some of the GNU/Linux
distributions.

Installation methods
--------------------

Stow can either be installed via the standard GNU Autotools procedure
(`./configure && make install`) or since 2.1.0, via CPAN-style via
Module::Build.

Advantages of the Autotools approach:

  - It's arguably more flexible.

  - It will install the documentation in Info, HTML, man, and PDF
    formats.

Advantages of the `Module::Build` approach:

  - It's more in keeping with the standard way to distribute CPAN
    modules.

  - It performs dependency checking to ensure you have the necessary
    Perl modules installed.

Both approaches are described in detail below.  However if you are
building from the git repository rather than an official release,
you first need to perform some extra steps:

Preparatory steps required only when building from git
------------------------------------------------------

`configure` and `Makefile` are included in official releases of Stow,
but they are deliberately omitted from the git repository because they
are autogenerated.  Therefore if you are installing directly from git,
you first need to generate them as follows.

First `cd` to the directory containing the source code (and this
file), and then run:

    autoreconf -iv

If this runs successfully then you are ready to continue with one of
the two installation methods below.

Basic Installation via `Module::Build`
--------------------------------------

The steps in building Stow are:

1.  `cd` to the directory containing the source code (and this file).

2.  If you are building from an official GNU release tarball, type
    `./configure && make` to configure stow for your system.  If you
    are building from a CPAN tarball, this step can be skipped.

    If `make` warns that the Perl module installation directory is
    not in `@INC`, then you should run:

        eval `perl -V:siteprefix`
        ./configure --prefix=$siteprefix && make

    to avoid a superfluous `use lib` line in your stow executable.

3.  Type `perl Build.PL`.

4.  Type `./Build install` to install the various files.  As noted
    above, this installs fewer files than the Autotools installation.

Basic Installation via Autotools
--------------------------------

The steps in building Stow are:

1.  `cd` to the directory containing the source code (and this file).

2.  Type `./configure` to configure stow for your system.  This step
    will attempt to locate your copy of perl and set its location in
    `Makefile.in`.  You can use the normal arguments to change the
    default installation paths (see below); additionally you can use
    the

        --with-pmdir=/path/to/perl/modules

    option to manually choose where the Perl modules get installed.
    However, if you don't, the `configure` script will go to great
    lengths to try to choose a sensible default.

3.  Type `make install` to install the various files.  If the chosen
    installation directory for Perl modules is not included in Perl's
    built-in `@INC` search path, the Makefile rules will automatically
    insert a

        use lib "...";

    line into the generated stow script to ensure that it can always
    locate the Perl modules without needing to manually set `PERL5LIB`.

4.  You can remove the generated files from the source code directory
    by typing `make clean`.  To also remove the files that `configure`
    created (so you can compile the package for a different computer),
    type `make distclean`.  There is also a `make maintainer-clean`
    target, but that is intended mainly for stow's developers.  If you
    use it, you may have to get all sorts of other programs in order
    to regenerate files that came with the distribution.

Installation Names
------------------

By default, `make install` will install the package's files in
`/usr/local/bin` and `/usr/local/info`.  You can specify an
installation prefix other than `/usr/local` by giving `configure` the
option `--prefix=PATH`.

If the package supports it, you can cause programs to be installed
with an extra prefix or suffix on their names by giving `configure`
the option `--program-prefix=PREFIX` or `--program-suffix=SUFFIX`.

Since `stow` is concerned with separating a package's installation
tree from its run-time tree, you might want to install `stow` into a
directory such as `/usr/local/stow/stow` but have it run out of
`/usr/local`.  Do this by giving the run-time prefix (e.g.,
/usr/local) to configure as described above; then run `make`; then run
`make install prefix=/usr/local/stow/stow`.  For more information on
this technique, see the Stow manual.

The configuration system
------------------------

The `configure` shell script attempts to guess correct values for
various system-dependent variables used during compilation.  It uses
those values to create a `Makefile` and to create the `stow` script
itself, using Makefile.in and stow.in as templates.  Finally, it
creates a shell script `config.status` that you can run in the future
to recreate the current configuration, a file `config.cache` that
saves the results of its tests to speed up reconfiguring, and a file
`config.log` containing other output.

The file `configure.ac` is used to create `configure` by a program
called `autoconf`.  You only need `configure.ac` if you want to change
it or regenerate `configure` using a newer version of `autoconf`.

The file `Makefile.am` is used to create `Makefile.in` by a program
called `automake`.  You only need `Makefile.am` if you want to change
it or regenerate `Makefile.in` using a newer version of `automake`.

Sharing Defaults
----------------

If you want to set default values for `configure` scripts to share,
you can create a site shell script called `config.site` that gives
default values for variables like `CC`, `cache_file`, and `prefix`.
`configure` looks for `PREFIX/share/config.site` if it exists, then
`PREFIX/etc/config.site` if it exists.  Or, you can set the
`CONFIG_SITE` environment variable to the location of the site script.
A warning: not all `configure` scripts look for a site script.

Operation Controls
------------------

`configure` recognizes the following options to control how it
operates.

`--cache-file=FILE`
     Use and save the results of the tests in FILE instead of
     `./config.cache`.  Set FILE to `/dev/null` to disable caching, for
     debugging `configure`.

`--help`
     Print a summary of the options to `configure`, and exit.

`--quiet`
`--silent`
`-q`
     Do not print messages saying which checks are being made.

`--srcdir=DIR`
     Look for the package's source code in directory DIR.  Usually
     `configure` can determine that directory automatically.

`--version`
     Print the version of Autoconf used to generate the `configure`
     script, and exit.

`configure` also accepts some other, not widely useful, options.

License for this file
---------------------

Copying and distribution of this file, with or without modification,
are permitted in any medium without royalty provided the copyright
notice and this notice are preserved.  This file is offered as-is,
without any warranty.
