/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.RFC2253Parser;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X509DataTest
extends TestCase {
    private static final String BASEDIR = System.getProperty("basedir");
    KeyStore ks = null;

    KeyStore getKeyStore() throws Exception {
        if (this.ks != null) {
            return this.ks;
        }
        String string = "JKS";
        String string2 = "data/org/apache/xml/security/samples/input/keystore.jks";
        String string3 = "xmlsecurity";
        this.ks = KeyStore.getInstance(string);
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + "/" + string2) : new FileInputStream(string2);
        this.ks.load(fileInputStream, string3.toCharArray());
        return this.ks;
    }

    X509Certificate getCertificate() throws Exception {
        String string = "test";
        X509Certificate x509Certificate = (X509Certificate)this.getKeyStore().getCertificate(string);
        return x509Certificate;
    }

    PrivateKey getPrivateKey() throws Exception {
        String string = "test";
        String string2 = "xmlsecurity";
        PrivateKey privateKey = (PrivateKey)this.getKeyStore().getKey(string, string2.toCharArray());
        return privateKey;
    }

    public XMLSignature getSignature(byte[] byArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        Element element = (Element)document.getFirstChild();
        return new XMLSignature(element, "");
    }

    public void testAddX509SubjectName() throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        XMLSignature xMLSignature = new XMLSignature(document, "", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        document.appendChild(xMLSignature.getElement());
        xMLSignature.addDocument("");
        X509Certificate x509Certificate = this.getCertificate();
        xMLSignature.addKeyInfo(x509Certificate);
        xMLSignature.addKeyInfo(x509Certificate.getPublicKey());
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        keyInfo.itemX509Data(0).addSubjectName(((Object)x509Certificate.getSubjectDN()).toString());
        keyInfo.itemX509Data(0).addIssuerSerial(((Object)x509Certificate.getIssuerDN()).toString(), x509Certificate.getSerialNumber());
        xMLSignature.sign((Key)this.getPrivateKey());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOM((Node)document, (OutputStream)byteArrayOutputStream);
        XMLSignature xMLSignature2 = this.getSignature(byteArrayOutputStream.toByteArray());
        X509DataTest.assertNotNull((Object)xMLSignature2.getKeyInfo().itemX509Data(0));
        X509DataTest.assertEquals((String)RFC2253Parser.normalize((String)((Object)x509Certificate.getSubjectDN()).toString()), (String)xMLSignature2.getKeyInfo().itemX509Data(0).itemSubjectName(0).getSubjectName());
        X509DataTest.assertEquals((String)RFC2253Parser.normalize((String)((Object)x509Certificate.getIssuerDN()).toString()), (String)xMLSignature2.getKeyInfo().itemX509Data(0).itemIssuerSerial(0).getIssuerName());
    }
}

