/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.test.TestUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UnknownAlgoSignatureTest
extends TestCase {
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    protected static final String KEYSTORE_TYPE = "JKS";
    protected static final String KEYSTORE_FILE = "data/org/apache/xml/security/samples/input/keystore.jks";
    protected static final String CERT_ALIAS = "test";
    protected static final String SIGNATURE_SOURCE_PATH = "data/org/apache/xml/security/temp/signature";
    protected PublicKey publicKey;
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest == null ? (class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest = UnknownAlgoSignatureTest.class$("org.apache.xml.security.test.signature.UnknownAlgoSignatureTest")) : class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest);
    }

    public UnknownAlgoSignatureTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest == null ? (class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest = UnknownAlgoSignatureTest.class$("org.apache.xml.security.test.signature.UnknownAlgoSignatureTest")) : class$org$apache$xml$security$test$signature$UnknownAlgoSignatureTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public void setUp() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + KEYSTORE_FILE) : new FileInputStream(KEYSTORE_FILE);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        keyStore.load(fileInputStream, null);
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(CERT_ALIAS);
        this.publicKey = x509Certificate.getPublicKey();
    }

    public void testGood() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSignatureException, XMLSecurityException {
        UnknownAlgoSignatureTest.assertTrue((boolean)this.checkSignature("signature-good.xml"));
    }

    public void testBadC14NAlgo() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException {
        try {
            UnknownAlgoSignatureTest.assertTrue((boolean)this.checkSignature("signature-bad-c14n-algo.xml"));
            UnknownAlgoSignatureTest.fail((String)"Exception not caught");
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            // empty catch block
        }
    }

    public void testBadSigAlgo() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException {
        try {
            UnknownAlgoSignatureTest.assertTrue((boolean)this.checkSignature("signature-bad-sig-algo.xml"));
            UnknownAlgoSignatureTest.fail((String)"Exception not caught");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    public void testBadTransformAlgo() throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException {
        try {
            UnknownAlgoSignatureTest.assertTrue((boolean)this.checkReferences("signature-bad-transform-algo.xml"));
            UnknownAlgoSignatureTest.fail((String)"Exception not caught");
        }
        catch (XMLSignatureException xMLSignatureException) {
            // empty catch block
        }
    }

    protected boolean checkSignature(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException {
        XMLSignature xMLSignature = this.unmarshalXMLSignature(string);
        return xMLSignature.checkSignatureValue((Key)this.publicKey);
    }

    protected boolean checkReferences(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException {
        XMLSignature xMLSignature = this.unmarshalXMLSignature(string);
        return xMLSignature.getSignedInfo().verify(false);
    }

    private XMLSignature unmarshalXMLSignature(String string) throws ParserConfigurationException, SAXException, IOException, TransformerException, XMLSecurityException {
        File file = null;
        file = BASEDIR != null && !"".equals(BASEDIR) ? new File(BASEDIR + SEP + SIGNATURE_SOURCE_PATH, string) : new File(SIGNATURE_SOURCE_PATH, string);
        Document document = UnknownAlgoSignatureTest.getDocument(file);
        Element element = TestUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
        XMLSignature xMLSignature = new XMLSignature(element2, file.toURL().toString());
        return xMLSignature;
    }

    public static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        return document;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

