/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public abstract class Insets2D
implements Cloneable,
Serializable {
    protected Insets2D() {
    }

    public abstract double getTop();

    public abstract double getLeft();

    public abstract double getBottom();

    public abstract double getRight();

    public abstract void set(double var1, double var3, double var5, double var7);

    public void set(Insets2D insets2D) {
        this.set(insets2D.getTop(), insets2D.getLeft(), insets2D.getBottom(), insets2D.getRight());
    }

    public void add(double d, double d2, double d3, double d4) {
        this.set(this.getTop() + d, this.getLeft() + d2, this.getBottom() + d3, this.getRight() + d4);
    }

    public void add(Insets2D insets2D) {
        this.set(this.getTop() + insets2D.getTop(), this.getLeft() + insets2D.getLeft(), this.getBottom() + insets2D.getBottom(), this.getRight() + insets2D.getRight());
    }

    public void addTo(Rectangle2D rectangle2D) {
        rectangle2D.setRect(rectangle2D.getX() - this.getLeft(), rectangle2D.getY() - this.getTop(), rectangle2D.getWidth() + this.getLeft() + this.getRight(), rectangle2D.getHeight() + this.getTop() + this.getBottom());
    }

    public void subtract(double d, double d2, double d3, double d4) {
        this.set(this.getTop() - d, this.getLeft() - d2, this.getBottom() - d3, this.getRight() - d4);
    }

    public void subtract(Insets2D insets2D) {
        this.set(this.getTop() - insets2D.getTop(), this.getLeft() - insets2D.getLeft(), this.getBottom() - insets2D.getBottom(), this.getRight() - insets2D.getRight());
    }

    public void subtractTo(Rectangle2D rectangle2D) {
        rectangle2D.setRect(rectangle2D.getX() + this.getLeft(), rectangle2D.getY() + this.getTop(), rectangle2D.getWidth() - this.getLeft() - this.getRight(), rectangle2D.getHeight() - this.getTop() - this.getBottom());
    }

    public boolean equals(Object object) {
        if (object instanceof Insets2D) {
            Insets2D insets2D = (Insets2D)object;
            return this.getTop() == insets2D.getTop() && this.getLeft() == insets2D.getLeft() && this.getBottom() == insets2D.getBottom() && this.getRight() == insets2D.getRight();
        }
        return false;
    }

    public int hashCode() {
        double d = this.getLeft() + this.getBottom();
        double d2 = this.getRight() + this.getTop();
        double d3 = d * (d + 1.0) / 2.0 + this.getLeft();
        double d4 = d2 * (d2 + 1.0) / 2.0 + this.getTop();
        double d5 = d3 + d4;
        return java.lang.Float.floatToIntBits((float)(d5 * (d5 + 1.0) / 2.0 + d4));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Insets2D {
        public double top;
        public double left;
        public double bottom;
        public double right;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.top = d;
            this.left = d2;
            this.bottom = d3;
            this.right = d4;
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        @Override
        public void set(double d, double d2, double d3, double d4) {
            this.top = d;
            this.left = d2;
            this.bottom = d3;
            this.right = d4;
        }
    }

    public static class Float
    extends Insets2D {
        public float top;
        public float left;
        public float bottom;
        public float right;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.top = f;
            this.left = f2;
            this.bottom = f3;
            this.right = f4;
        }

        @Override
        public double getTop() {
            return this.top;
        }

        @Override
        public double getLeft() {
            return this.left;
        }

        @Override
        public double getBottom() {
            return this.bottom;
        }

        @Override
        public double getRight() {
            return this.right;
        }

        @Override
        public void set(double d, double d2, double d3, double d4) {
            this.top = (float)d;
            this.left = (float)d2;
            this.bottom = (float)d3;
            this.right = (float)d4;
        }

        public void set(float f, float f2, float f3, float f4) {
            this.top = f;
            this.left = f2;
            this.bottom = f3;
            this.right = f4;
        }
    }
}

