package dnos9;
##
## rancid 3.13
## Copyright (c) 1997-2019 by Henry Kilmer and John Heasley
## All rights reserved.
##
## This code is derived from software contributed to and maintained by
## Henry Kilmer, John Heasley, Andrew Partan,
## Pete Whiting, Austin Schutz, and Andrew Fort.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
## 1. Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
## 2. Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
## 3. Neither the name of RANCID nor the names of its
##    contributors may be used to endorse or promote products derived from
##    this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY Henry Kilmer, John Heasley AND CONTRIBUTORS
## ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
## TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
## PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COMPANY OR CONTRIBUTORS
## BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
## CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
## SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
## INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
## CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
## POSSIBILITY OF SUCH DAMAGE.
##
## It is the request of the authors, but not a condition of license, that
## parties packaging or redistributing RANCID NOT distribute altered versions
## of the etc/rancid.types.base file nor alter how this file is processed nor
## when in relation to etc/rancid.types.conf.  The goal of this is to help
## suppress our support costs.  If it becomes a problem, this could become a
## condition of license.
# 
#  The expect login scripts were based on Erik Sherk's gwtn, by permission.
# 
#  The original looking glass software was written by Ed Kern, provided by
#  permission and modified beyond recognition.
#
#  RANCID - Really Awesome New Cisco confIg Differ
#
#  dnos9.pm - Force10 / Dell NOS9 rancid procedures

use 5.010;
use strict 'vars';
use warnings;
no warnings 'uninitialized';
require(Exporter);
our @ISA = qw(Exporter);

use rancid 3.13;

@ISA = qw(Exporter rancid main);
#XXX @Exporter::EXPORT = qw($VERSION @commandtable %commands @commands);

# load-time initialization
sub import {
    0;
}

# post-open(collection file) initialization
sub init {
    # add content lines and separators
    ProcessHistory("","","","!RANCID-CONTENT-TYPE: $devtype\n!\n");
    ProcessHistory("COMMENTS","keysort","B0","!\n");
    ProcessHistory("COMMENTS","keysort","F0","!\n");
    ProcessHistory("COMMENTS","keysort","G0","!\n");

    0;
}

$timeo = 90;				# clogin timeout in seconds

# main loop of input of device output
sub inloop {
    my($INPUT, $OUTPUT) = @_;
    my($cmd, $rval);

TOP: while(<$INPUT>) {
	tr/\015//d;
	if (/\#\s?exit$/) {
	    $clean_run=1;
	    last;
	}
	if (/^Error:/) {
	    print STDOUT ("$host clogin error: $_");
	    print STDERR ("$host clogin error: $_") if ($debug);
	    $clean_run=0;
	    last;
	}
	while (/#\s*($cmds_regexp)\s*$/) {
	    $cmd = $1;
	    if (!defined($prompt)) {
		$prompt = ($_ =~ /^([^#]+#)/)[0];
		$prompt =~ s/([][}{)(\\])/\\$1/g;
		print STDERR ("PROMPT MATCH: $prompt\n") if ($debug);
	    }
	    print STDERR ("HIT COMMAND:$_") if ($debug);
	    if (! defined($commands{$cmd})) {
		print STDERR "$host: found unexpected command - \"$cmd\"\n";
		$clean_run = 0;
		last TOP;
	    }
	    if (! defined(&{$commands{$cmd}})) {
		printf(STDERR "$host: undefined function - \"%s\"\n",  
		       $commands{$cmd});
		$clean_run = 0;
		last TOP;
	    }
	    $rval = &{$commands{$cmd}}($INPUT, $OUTPUT, $cmd);
	    delete($commands{$cmd});
	    if ($rval == -1) {
		$clean_run = 0;
		last TOP;
	    }
	}
    }
}

# This routine parses "show version"
sub ShowVersion {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowVersion: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if(/^$prompt/);
	next if(/^(\s*|\s*$cmd\s*)$/);
	return(-1) if (/command authorization failed/i);

	s/\s*$/\n/;

	/ Type: / &&
	    ProcessHistory("COMMENTS","keysort","A1", "!$_");

	/^.* Version.*$/ &&
	    ProcessHistory("COMMENTS","keysort","F1", "!Image: $_") && next;

	/^Build .*$/ &&
	    ProcessHistory("COMMENTS","keysort","F1", "!Image: $_") && next;

	/^System image file is "([^\"]*)"$/ &&
	    ProcessHistory("COMMENTS","keysort","F5", "!Image: $1\n") && next;

	if (/^(.*\s+Processor)( \d)?:(.*) with (\d+[kK]?) bytes/) {
	    my($cpu) = "$1$2:$3";
	    my($mem) = int($4 / (1024 * 1024));
	    my($device) = "Force10";
	    ProcessHistory("COMMENTS","keysort","B1",
			   "!Memory: $1$2: $mem" . "M\n");
	    ProcessHistory("COMMENTS","keysort","A3","!CPU: $cpu\n");
	    next;
	}

	# E-Series and C-Series use NVRAM
	/^(\d+[kK]) bytes of non-volatile/ &&
	    ProcessHistory("COMMENTS","keysort","B3", "!Memory: NVRAM $1\n") &&
	    next;
	# S-Series uses boot flash
	/^(\d+[mM]) bytes of .oot..lash/ &&
	    ProcessHistory("COMMENTS","keysort","B3", "!Memory: Flash $1\n") &&
	    next;
    }
    return(0);
}

# This routine parses "show boot"
sub ShowBoot {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowBoot: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	return(1) if /(Invalid input|Type help or )/;
	return(1) if /( *\^$)/;
	return(-1) if (/command authorization failed/i);
	
	ProcessHistory("COMMENTS","keysort","H0","!Boot Variables: $_");
    }
    ProcessHistory("COMMENTS","","","!\n");
    return(0);
}

# This routine parses "show chassis"
sub ShowChassis {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowChassis: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
REDO:	last if (/^$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	return(1) if /(Invalid input|Type help or )/;
	return(1) if /( *\^$)/;
	return(-1) if (/command authorization failed/i);

	/-----------------------------/ && next;
	# general stuff that changes
	/Next Boot/ && next;
	/Up Time/ && next;
	/Last Restart/ && next;
	/Switch Fabric State/ && next;
	/active / && next;
	/online / && next;
	/offline / && next;
	# E600 AC PSMs
	/Status        : up/ && next;
	/High line/ && next;
	# PS fans
	if (/power\s+supplies/i) {
	    ProcessHistory("COMMENTS","keysort","CHASSIS","!Chassis: $_");

	    while (<$INPUT>) {
		tr/\015//d;
		if (/^$prompt/) {
		    goto OUT;
		}
		last if (/^$/);
		# remove any trailing WS
		s/\s+$//;
		next if (/^----+$/);
		# s4048 style
		if (/(Unit\s+Bay\s+Status\s+Type\s+FanStatus)\s+FanSpeed/) {
		    ProcessHistory("COMMENTS","keysort","CHASSIS",
		    		   "!Chassis: $1\n");
		    while (<$INPUT>) {
			tr/\015//d;
			if (/^$prompt/) {
			    goto OUT;
			}
			last if (/^$/);
			# remove any trailing WS
			s/\s+$//;
			# consume the following separator line
			next if (/^----+$/);
			/^(\s+\d+\s+\d+\s+\S+\s+\S+\s+\S+)\s+\S+/ &&
			    ProcessHistory("COMMENTS","keysort","CHASSIS",
			    "!Chassis: $1\n") && next;
			last;
		    }
		    goto REDO;
		}
	    }
	}
	# fans
	if (/Fan\s+Status/i) {
	    ProcessHistory("COMMENTS","keysort","CHASSIS","!Chassis: $_");

	    while (<$INPUT>) {
		tr/\015//d;
		if (/^$prompt/) {
		    goto OUT;
		}
		last if (/^$/);
		# remove any trailing WS
		s/\s+$//;
		next if (/^----+$/);
		# c150 / c300 style
		/FanNumber\s+Speed\s+Status/ && ProcessHistory("COMMENTS",
		    "keysort","CHASSIS","!Chassis: FanNumber\tStatus\n") &&
		    next;
		/^\s+(\d)\s+\d+\s+(\S+)/ && ProcessHistory("COMMENTS",
		    "keysort","CHASSIS","!Chassis: $1\t\t$2\n") && next;
		# e300
		/^Status\s+$/ && next;
		/^\s+(\S+)\s*$/ && ProcessHistory("COMMENTS","keysort",
		    "CHASSIS","!Chassis: $1\n") && next;
		# e600 style
		/Status\s+Temp\s+Fan1\s+Fan2\s+Fan3\s+Serial\s/ && next;
		/^\s+(\S+)\s+\d+C\s+\d+ RPM\s+/ && ProcessHistory("COMMENTS",
		    "keysort","CHASSIS","!Chassis: $1\n") && next;
		# e1200 style
		/Tray\s+Status\s+Temp\s+/ && ProcessHistory("COMMENTS",
		    "keysort","CHASSIS","!Chassis: Tray\tStatus\n") &&
		    next;
		/^\s+(\d+)\s+(\S+)\s+(or down|(< )?\d+C\s+)/ &&
		    ProcessHistory("COMMENTS","keysort","CHASSIS",
		    "!Chassis: $1\t$2\n") && next;
		# s50n / s50v style
		if (/Unit\s+TrayStatus\s+Fan0\s+Fan1\s+/) {
		    ProcessHistory("COMMENTS","keysort","CHASSIS",
		    "!Chassis: $_\n");
		    # consume the following blank/separator line
		    $_ = <$INPUT>;
		    # the s50n botches its fan status line with the "---..."
		    # separator line w/o a CR, followed by the fan status.  we
		    # would normally skip the sparator line, so hack it.
		    s/^------+(\s+)/$1/;
		    tr/\015//d;
		    # the s50v has a blank line following the table header,
		    # loop for that one and continue for the S50n
		    /^\s+$/ && next;
		}
		/^\s+\d+\s+\S+\s+\S+\s+\S+\s+\S+\s+/ &&
		    ProcessHistory("COMMENTS","keysort","CHASSIS",
		    "!Chassis: $_") && next;
	    }
	    next;
	}
	ProcessHistory("COMMENTS","keysort","CHASSIS","!Chassis: $_");
    }
OUT:
    ProcessHistory("COMMENTS","keysort","CHASSIS","!\n");
    return(0);
}

# This routine parses "dir /all (flash|slotN):"
sub DirSlotN {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In DirSlotN: $_" if ($debug);

    my($dev) = (/\s([^\s]+):/);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	# return(1) if ($type !~ /^(12[40]|7|36)/);
	return(1) if /^\s*\^\s*$/;
	return(1) if /(Invalid input|Type help or )/;
	return(1) if /No such device/i;
	return(1) if /\% ?Error: No such file or directory/;

	return(1) if /\% ?Error: The file device is not present/;
	return(1) if /\% ?Error: The specified file or directory does not exist/;
	return(1) if /No space information available/;
	return(-1) if (/command authorization failed/i);
	return(1) if /(Open device \S+ failed|Error opening \S+:)/;

	/Directory of/ && next;
	# . & ..
	/ \.{1,2}\s+$/ && next;

	# clean up totals line
	if (/.* (\d+) bytes total/) {
	    my($tmp) = int($1 / (1024 * 1024));
	    s/.* $1 bytes total/${tmp}M total/;
	}
	if (/.*\((\d+) bytes free\)/) {
	    my($tmp) = int($1 / (1024 * 1024));
	    s/$1 bytes free/${tmp}M free/;
	}
	s/ +$//g;
	ProcessHistory("FLASH","","","!Flash: $dev: $_");
    }
    ProcessHistory("","","","!\n");
    return(0);
}

# This routine parses "show inventory"
sub ShowInventory {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowInventory: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	return(1) if /(Invalid input|Type help or )/;
	return(-1) if (/command authorization failed/i);

	/-----------------------------/ && next;
	ProcessHistory("COMMENTS","keysort","INVENTORY","!Inventory: $_");
    }
    ProcessHistory("COMMENTS","keysort","INVENTORY","!\n");
    return(0);
}

# This routine parses "show vlan"
sub ShowVLAN {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowVLAN: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);
	return(1) if /(Invalid input|Type help or )/;
	return(-1) if (/command authorization failed/i);
	ProcessHistory("COMMENTS","keysort","VLAN","!VLAN: $_");
    }
    ProcessHistory("COMMENTS","keysort","VLAN","!\n");
    return(0);
}

# This routine processes a "write term"
sub WriteTerm {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In WriteTerm: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if(/^$prompt/);
	return(-1) if (/command authorization failed/i);
	# skip crap
 	/^Current Configuration/ && next;
	/^! (version|last configuration|startup-config last)/i && next;


	# Dog gone Cool matches to process the rest of the config
	/^tftp-server flash /   && next; # kill any tftp remains
	/^ntp clock-period /    && next; # kill ntp clock-period
	/^ length /		&& next; # kill length on serial lines
	/^ width /		&& next; # kill width on serial lines
	/^ clockrate /		&& next; # kill clockrate on serial interfaces
	if (/^(enable )?(password|passwd) / && $filter_pwds >= 1) {
	    ProcessHistory("ENABLE","","","!$1$2 <removed>\n");
	    next;
	}
	if (/^(enable secret) / && $filter_pwds >= 2) {
	    ProcessHistory("ENABLE","","","!$1 <removed>\n");
	    next;
	}
	if (/^(enable restricted) / && $filter_pwds >= 2) {
	    ProcessHistory("ENABLE","","","!$1 <removed>\n");
	    next;
	}
	if (/^username (\S+)(\s.*)? secret /) {
	    if ($filter_pwds >= 2) {
		ProcessHistory("USER","keysort","$1","!username $1$2 secret <removed>\n");
	    } else {
		ProcessHistory("USER","keysort","$1","$_");
	    }
	    next;
	}
	if (/^username (\S+)(\s.*)? password ((\d) \S+|\S+)/) {
	    if ($filter_pwds == 2) {
		ProcessHistory("USER","keysort","$1","!username $1$2 password <removed>\n");
	    } elsif ($filter_pwds == 1 && $4 ne "5"){
		ProcessHistory("USER","keysort","$1","!username $1$2 password <removed>\n");
	    } else {
		ProcessHistory("USER","keysort","$1","$_");
	    }
	    next;
	}
	if (/^(\s*)password / && $filter_pwds >= 1) {
	    ProcessHistory("LINE-PASS","","","!$1password <removed>\n");
	    next;
	}
	if (/^\s*neighbor (\S*) password / && $filter_pwds >= 1) {
	    ProcessHistory("","","","! neighbor $1 password <removed>\n");
	    next;
	}
	if (/^(ip ftp password) / && $filter_pwds >= 1) {
	    ProcessHistory("","","","!$1 <removed>\n"); next;
	}
	if (/^(ftp-server username.*password) / && $filter_pwds >= 1) {
	    ProcessHistory("","","","!$1 <removed>\n"); next;
	}
	if (/^( ip ospf authentication-key) / && $filter_pwds >= 1) {
	    ProcessHistory("","","","!$1 <removed>\n"); next;
	}
	# this is reversable, despite 'md5' in the cmd
	if (/^( ip ospf message-digest-key \d+ md5) / && $filter_pwds >= 1) {
	    ProcessHistory("","","","!$1 <removed>\n"); next;
	}
	# sort route-maps
	if (/^route-map (\S+)/) {
	    my($key) = $1;
	    my($routemap) = $_;
	    while (<$INPUT>) {
		tr/\015//d;
		last if (/^$prompt/ || ! /^(route-map |[ !])/);
		if (/^route-map (\S+)/) {
		    ProcessHistory("ROUTEMAP","keysort","$key","$routemap");
		    $key = $1;
		    $routemap = $_;
		} else  {
		    $routemap .= $_;
		}
	    }
	    ProcessHistory("ROUTEMAP","keysort","$key","$routemap");
	}
	# filter out any RCS/CVS tags to avoid confusing local CVS storage
	s/\$(Revision|Id):/ $1:/;
	# order access-lists
	/^access-list\s+(\d\d?)\s+(\S+)\s+(\S+)/ &&
	    ProcessHistory("ACL $1 $2","$aclsort","$3","$_") && next;
	# order extended access-lists
	/^access-list\s+(\d\d\d)\s+(\S+)\s+ip\s+host\s+(\S+)/ &&
	    ProcessHistory("EACL $1 $2","$aclsort","$3","$_") && next;
	/^access-list\s+(\d\d\d)\s+(\S+)\s+ip\s+(\d\S+)/ &&
	    ProcessHistory("EACL $1 $2","$aclsort","$3","$_") && next;
	/^access-list\s+(\d\d\d)\s+(\S+)\s+ip\s+any/ &&
	    ProcessHistory("EACL $1 $2","$aclsort","0.0.0.0","$_") && next;
	# order arp lists
	/^arp\s+(\d+\.\d+\.\d+\.\d+)\s+/ &&
	    ProcessHistory("ARP","$aclsort","$1","$_") && next;
	/^ip prefix-list\s+(\S+)\s+seq\s+(\d+)\s+(permit|deny)\s+(\d\S+)(\/.*)$/ &&
	    ProcessHistory("PACL $1 $3","$aclsort","$4","ip prefix-list $1 $3 $4$5\n")
	    && next;
	# order logging statements
	/^logging (\d+\.\d+\.\d+\.\d+)/ &&
	    ProcessHistory("LOGGING","ipsort","$1","$_") && next;
	# order/prune snmp-server host statements
	# we only prune lines of the form
	# snmp-server host a.b.c.d <community>
	if (/^snmp-server host (\d+\.\d+\.\d+\.\d+) /) {
	    if ($filter_commstr) {
		my($ip) = $1;
		my($line) = "snmp-server host $ip";
		my(@tokens) = split(' ', $');
		my($token);
		while ($token = shift(@tokens)) {
		    if ($token eq 'version') {
			$line .= " " . join(' ', ($token, shift(@tokens)));
		    } elsif ($token =~ /^(informs?|traps?|(no)?auth)$/) {
			$line .= " " . $token;
		    } else {
			$line = "!$line " . join(' ', ("<removed>", join(' ',@tokens)));
			last;
		    }
		}
		ProcessHistory("SNMPSERVERHOST","ipsort","$ip","$line\n");
	    } else {
		ProcessHistory("SNMPSERVERHOST","ipsort","$1","$_");
	    }
	    next;
	}
	if (/^(snmp-server community) (\S+)/) {
	    if ($filter_commstr) {
		ProcessHistory("SNMPSERVERCOMM","keysort","$_","!$1 <removed>$'") && next;
	    } else {
		ProcessHistory("SNMPSERVERCOMM","keysort","$_","$_") && next;
	    }
	}
	# order/prune tacacs/radius server statements
	if (/^(tacacs-server|radius-server) key / && $filter_pwds >= 1) {
	    ProcessHistory("","","","!$1 key <removed>\n"); next;
	}
	# order clns host statements
	/^clns host \S+ (\S+)/ &&
	    ProcessHistory("CLNS","keysort","$1","$_") && next;
	# delete ntp auth password - this md5 is a reversable too
	if (/^(ntp authentication-key \d+ md5) / && $filter_pwds >= 1) {
	    ProcessHistory("","","","!$1 <removed>\n"); next;
	}
	# order ntp peers/servers
	if (/^ntp (server|peer) (\d+)\.(\d+)\.(\d+)\.(\d+)/) {
	    my($sortkey) = sprintf("$1 %03d%03d%03d%03d",$2,$3,$4,$5);
	    ProcessHistory("NTP","keysort",$sortkey,"$_");
	    next;
	}
	# order ip host line statements
	/^ip host line(\d+)/ &&
	    ProcessHistory("IPHOST","numsort","$1","$_") && next;
	# order atm map-list statements
	/^\s+ip\s+(\d+\.\d+\.\d+\.\d+)\s+atm-vc/ &&
	    ProcessHistory("ATM map-list","ipsort","$1","$_") && next;

	# catch anything that wasnt matched above.
	ProcessHistory("","","","$_");
	# end of config.  the ": " game is for the PIX
	if (/^end *$/) {
	    $found_end = 1;
	    return(0);
	}
    }
    return(0);
}

1;
