/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidSymbolTypeException;
import org.scilab.forge.jlatexmath.InvalidTeXFormulaException;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.VerticalBox;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AccentedAtom
extends Atom {
    private final SymbolAtom a;
    private boolean a;
    private boolean b;
    protected Atom a = null;
    protected Atom b = null;

    public AccentedAtom(Atom atom, Atom atom2) {
        this.a = atom;
        this.b = atom instanceof AccentedAtom ? ((AccentedAtom)atom).b : atom;
        if (!(atom2 instanceof SymbolAtom)) {
            throw new InvalidSymbolTypeException("Invalid accent");
        }
        this.a = (SymbolAtom)atom2;
        this.a = true;
    }

    public AccentedAtom(Atom atom, Atom atom2, boolean bl) {
        this(atom, atom2);
        this.b = bl;
    }

    public AccentedAtom(Atom atom, String string) {
        this.a = SymbolAtom.get(string);
        if (this.a.a == 10) {
            this.a = atom;
            this.b = atom instanceof AccentedAtom ? ((AccentedAtom)atom).b : atom;
        } else {
            throw new InvalidSymbolTypeException("The symbol with the name '" + string + "' is not defined as an accent (" + "type" + "='acc') in '" + "TeXSymbols.xml" + "'!");
        }
    }

    public AccentedAtom(Atom atom, TeXFormula teXFormula) {
        if (teXFormula == null) {
            throw new InvalidTeXFormulaException("The accent TeXFormula can't be null!");
        }
        Atom atom2 = teXFormula.a;
        if (atom2 instanceof SymbolAtom) {
            this.a = (SymbolAtom)atom2;
            if (this.a.a != 10) {
                throw new InvalidSymbolTypeException("The accent TeXFormula represents a single symbol with the name '" + this.a.getName() + "', but this symbol is not defined as an accent (" + "type" + "='acc') in '" + "TeXSymbols.xml" + "'!");
            }
        } else {
            throw new InvalidTeXFormulaException("The accent TeXFormula does not represent a single symbol!");
        }
        this.a = atom;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box;
        Char char_;
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Box box2 = this.a == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.a.createBox(teXEnvironment.crampStyle());
        float f = box2.getWidth();
        float f2 = 0.0f;
        if (this.b instanceof CharSymbol) {
            f2 = teXFont.getSkew(((CharSymbol)this.b).getCharFont(teXFont), n);
        }
        Char char_2 = teXFont.getChar(this.a.getName(), n);
        while (teXFont.hasNextLarger(char_2) && (char_ = teXFont.getNextLarger(char_2, n)).getWidth() <= f) {
            char_2 = char_;
        }
        float f3 = -SpaceAtom.getFactor(5, teXEnvironment);
        float f4 = this.a ? f3 : Math.min(box2.getHeight(), teXFont.getXHeight(n, char_2.getFontCode()));
        VerticalBox verticalBox = new VerticalBox();
        float f5 = char_2.getItalic();
        Box box3 = new CharBox(char_2);
        if (this.a) {
            box3 = this.a.createBox(this.b ? teXEnvironment.subStyle() : teXEnvironment);
        }
        if (Math.abs(f5) > 1.0E-7f) {
            box = new HorizontalBox(new StrutBox(-f5, 0.0f, 0.0f, 0.0f));
            box.add(box3);
        } else {
            box = box3;
        }
        float f6 = (f - box.getWidth()) / 2.0f;
        box.setShift(f2 + (f6 > 0.0f ? f6 : 0.0f));
        if (f6 < 0.0f) {
            box2 = new HorizontalBox(box2, box.getWidth(), 2);
        }
        verticalBox.add(box);
        verticalBox.add(new StrutBox(0.0f, this.b ? -f4 : -box2.getHeight(), 0.0f, 0.0f));
        verticalBox.add(box2);
        float f7 = verticalBox.getHeight() + verticalBox.getDepth();
        float f8 = box2.getDepth();
        verticalBox.setDepth(f8);
        verticalBox.setHeight(f7 - f8);
        if (f6 < 0.0f) {
            HorizontalBox horizontalBox = new HorizontalBox(new StrutBox(f6, 0.0f, 0.0f, 0.0f));
            horizontalBox.add(verticalBox);
            horizontalBox.setWidth(f);
            return horizontalBox;
        }
        return verticalBox;
    }
}

