/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.PackageDepsSpecBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeatureSpec
extends PackageDepsSpec {
    final String name;
    final Map<String, FeatureAnnotation> annotations;
    final Map<FeatureId, FeatureDependencySpec> featureDeps;
    final Map<String, FeatureReferenceSpec> featureRefs;
    final Map<String, FeatureParameterSpec> params;
    final List<FeatureParameterSpec> idParams;
    final Set<CapabilitySpec> providedCaps;
    final Set<CapabilitySpec> requiredCaps;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private FeatureSpec(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.annotations = CollectionUtils.unmodifiable(builder.annotations);
        this.featureDeps = CollectionUtils.unmodifiable(builder.featureDeps);
        this.featureRefs = CollectionUtils.unmodifiable(builder.refs);
        this.params = CollectionUtils.unmodifiable(builder.params);
        this.idParams = CollectionUtils.unmodifiable(builder.idParams);
        this.providedCaps = CollectionUtils.unmodifiable(builder.providedCaps);
        this.requiredCaps = CollectionUtils.unmodifiable(builder.requiredCaps);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public Collection<FeatureAnnotation> getAnnotations() {
        return this.annotations.values();
    }

    public boolean hasAnnotation(String name) {
        return this.annotations.containsKey(name);
    }

    public FeatureAnnotation getAnnotation(String name) {
        return this.annotations.get(name);
    }

    public boolean hasId() {
        return !this.idParams.isEmpty();
    }

    public List<FeatureParameterSpec> getIdParams() {
        return this.idParams;
    }

    public boolean hasFeatureDeps() {
        return !this.featureDeps.isEmpty();
    }

    public Collection<FeatureDependencySpec> getFeatureDeps() {
        return this.featureDeps.values();
    }

    public boolean hasFeatureRefs() {
        return !this.featureRefs.isEmpty();
    }

    public Collection<FeatureReferenceSpec> getFeatureRefs() {
        return this.featureRefs.values();
    }

    public FeatureReferenceSpec getFeatureRef(String name) throws ProvisioningDescriptionException {
        FeatureReferenceSpec ref = this.featureRefs.get(name);
        if (ref == null) {
            throw new ProvisioningDescriptionException(Errors.featureRefNotInSpec(name, this.name));
        }
        return ref;
    }

    public boolean hasParams() {
        return !this.params.isEmpty();
    }

    public int getParamsTotal() {
        return this.params.size();
    }

    public Map<String, FeatureParameterSpec> getParams() {
        return this.params;
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    public FeatureParameterSpec getParam(String name) throws ProvisioningDescriptionException {
        FeatureParameterSpec paramSpec = this.params.get(name);
        if (paramSpec == null) {
            throw new ProvisioningDescriptionException(Errors.unknownFeatureParameter(this.name, name));
        }
        return paramSpec;
    }

    public boolean providesCapabilities() {
        return !this.providedCaps.isEmpty();
    }

    public Set<CapabilitySpec> getProvidedCapabilities() {
        return this.providedCaps;
    }

    public boolean requiresCapabilities() {
        return !this.requiredCaps.isEmpty();
    }

    public Set<CapabilitySpec> getRequiredCapabilities() {
        return this.requiredCaps;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.featureDeps == null ? 0 : this.featureDeps.hashCode());
        result = 31 * result + (this.featureRefs == null ? 0 : this.featureRefs.hashCode());
        result = 31 * result + (this.idParams == null ? 0 : this.idParams.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.providedCaps == null ? 0 : this.providedCaps.hashCode());
        result = 31 * result + (this.requiredCaps == null ? 0 : this.requiredCaps.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureSpec other = (FeatureSpec)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.featureDeps == null ? other.featureDeps != null : !this.featureDeps.equals(other.featureDeps)) {
            return false;
        }
        if (this.featureRefs == null ? other.featureRefs != null : !this.featureRefs.equals(other.featureRefs)) {
            return false;
        }
        if (this.idParams == null ? other.idParams != null : !this.idParams.equals(other.idParams)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.providedCaps == null ? other.providedCaps != null : !this.providedCaps.equals(other.providedCaps)) {
            return false;
        }
        return !(this.requiredCaps == null ? other.requiredCaps != null : !this.requiredCaps.equals(other.requiredCaps));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.name);
        if (!this.providedCaps.isEmpty()) {
            buf.append(" provides=");
            StringUtils.append(buf, this.providedCaps);
        }
        if (!this.requiredCaps.isEmpty()) {
            buf.append(" requires=");
            StringUtils.append(buf, this.requiredCaps);
        }
        if (!this.featureDeps.isEmpty()) {
            buf.append(" deps=");
            StringUtils.append(buf, this.featureDeps.values());
        }
        if (!this.featureRefs.isEmpty()) {
            buf.append(" refs=");
            StringUtils.append(buf, this.featureRefs.values());
        }
        if (!this.params.isEmpty()) {
            buf.append(" params=");
            StringUtils.append(buf, this.params.values());
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends PackageDepsSpecBuilder<Builder> {
        private String name;
        private Map<String, FeatureAnnotation> annotations = Collections.emptyMap();
        private Map<FeatureId, FeatureDependencySpec> featureDeps = Collections.emptyMap();
        private Map<String, FeatureReferenceSpec> refs = Collections.emptyMap();
        private Map<String, FeatureParameterSpec> params = Collections.emptyMap();
        private List<FeatureParameterSpec> idParams = Collections.emptyList();
        private Set<CapabilitySpec> providedCaps = Collections.emptySet();
        private Set<CapabilitySpec> requiredCaps = Collections.emptySet();

        private Builder() {
        }

        private Builder(String name) {
            this.name = name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addAnnotation(FeatureAnnotation annotation) {
            this.annotations = CollectionUtils.putLinked(this.annotations, annotation.getName(), annotation);
            return this;
        }

        public Builder addFeatureDep(FeatureDependencySpec dep) throws ProvisioningDescriptionException {
            if (this.featureDeps.containsKey(dep.getFeatureId())) {
                throw new ProvisioningDescriptionException("Duplicate dependency on " + dep.getFeatureId() + " from feature spec " + this.name);
            }
            this.featureDeps = CollectionUtils.putLinked(this.featureDeps, dep.getFeatureId(), dep);
            return this;
        }

        public Builder addFeatureRef(FeatureReferenceSpec ref) throws ProvisioningDescriptionException {
            if (this.refs.containsKey(ref.name)) {
                throw new ProvisioningDescriptionException("Duplicate reference " + ref.name + " in feature spec " + this.name);
            }
            this.refs = CollectionUtils.putLinked(this.refs, ref.name, ref);
            return this;
        }

        public boolean hasParam(String name) {
            return this.params.containsKey(name);
        }

        public Builder addParam(FeatureParameterSpec param) throws ProvisioningDescriptionException {
            if (this.params.containsKey(param.name)) {
                throw new ProvisioningDescriptionException("Duplicate parameter " + param + " for feature " + this.name);
            }
            this.params = CollectionUtils.put(this.params, param.name, param);
            if (param.featureId) {
                this.idParams = CollectionUtils.add(this.idParams, param);
            }
            return this;
        }

        public Builder providesCapability(String name) throws ProvisioningDescriptionException {
            return this.providesCapability(name, false);
        }

        public Builder providesCapability(String name, boolean optional) throws ProvisioningDescriptionException {
            return this.providesCapability(CapabilitySpec.fromString(name, optional));
        }

        public Builder providesCapability(CapabilitySpec cap) {
            this.providedCaps = CollectionUtils.add(this.providedCaps, cap);
            return this;
        }

        public Builder requiresCapability(String name) throws ProvisioningDescriptionException {
            return this.requiresCapability(name, false);
        }

        public Builder requiresCapability(String name, boolean optional) throws ProvisioningDescriptionException {
            return this.requiresCapability(CapabilitySpec.fromString(name, optional));
        }

        public Builder requiresCapability(CapabilitySpec cap) {
            this.requiredCaps = CollectionUtils.add(this.requiredCaps, cap);
            return this;
        }

        public FeatureSpec build() throws ProvisioningDescriptionException {
            return new FeatureSpec(this);
        }
    }
}

