/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class FeaturePackDescription {
    private final FeaturePackLocation.FPID fpid;
    private final FeaturePackSpec spec;
    private final Map<String, PackageSpec> packages;
    final List<String> unresolvedLocalPkgs;
    final boolean externalPkgDeps;

    public static Builder builder(FeaturePackSpec.Builder spec) {
        return new Builder(spec.getFPID(), spec);
    }

    private FeaturePackDescription(Builder builder) throws ProvisioningDescriptionException {
        this.fpid = builder.fpid;
        this.spec = builder.spec.build();
        this.packages = CollectionUtils.unmodifiable(builder.packages);
        for (String name : this.spec.getDefaultPackageNames()) {
            if (this.packages.containsKey(name)) continue;
            throw new ProvisioningDescriptionException(Errors.unknownPackage(this.fpid, name));
        }
        List<String> notFound = Collections.emptyList();
        boolean externalPkgDeps = false;
        if (!this.packages.isEmpty()) {
            for (PackageSpec pkg : this.packages.values()) {
                if (pkg.hasLocalPackageDeps()) {
                    for (PackageDependencySpec pkgDep : pkg.getLocalPackageDeps()) {
                        PackageSpec depSpec = this.packages.get(pkgDep.getName());
                        if (depSpec != null) continue;
                        if (notFound.isEmpty()) {
                            notFound = new ArrayList<String>();
                        }
                        notFound.add(pkgDep.getName());
                    }
                    if (!this.spec.hasFeaturePackDeps() && !notFound.isEmpty()) {
                        throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependencies(this.fpid, pkg.getName(), notFound));
                    }
                }
                if (!pkg.hasExternalPackageDeps()) continue;
                for (String origin : pkg.getPackageOrigins()) {
                    try {
                        this.spec.getFeaturePackDep(origin);
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new ProvisioningDescriptionException(Errors.unknownFeaturePackDependencyName(this.fpid, pkg.getName(), origin), e);
                    }
                }
                externalPkgDeps = true;
            }
        }
        this.externalPkgDeps = externalPkgDeps;
        this.unresolvedLocalPkgs = CollectionUtils.unmodifiable(notFound);
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public FeaturePackSpec getSpec() {
        return this.spec;
    }

    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    public boolean hasPackage(String name) {
        return this.packages.containsKey(name);
    }

    public PackageSpec getPackage(String name) {
        return this.packages.get(name);
    }

    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    public Collection<PackageSpec> getPackages() {
        return this.packages.values();
    }

    public static class Builder {
        private final FeaturePackLocation.FPID fpid;
        private final FeaturePackSpec.Builder spec;
        private Map<String, PackageSpec> packages = Collections.emptyMap();

        private Builder(FeaturePackLocation.FPID fpid, FeaturePackSpec.Builder spec) {
            this.fpid = fpid;
            this.spec = spec;
        }

        public Builder addPackage(PackageSpec pkg) {
            this.packages = CollectionUtils.put(this.packages, pkg.getName(), pkg);
            return this;
        }

        public boolean hasPackage(String name) {
            return this.packages.containsKey(name);
        }

        public FeaturePackSpec.Builder getSpecBuilder() {
            return this.spec;
        }

        public FeaturePackDescription build() throws ProvisioningDescriptionException {
            return new FeaturePackDescription(this);
        }
    }
}

