"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityAnalyticsPlugin = void 0;

var _createSecurityAnalyticsCluster = require("./clusters/createSecurityAnalyticsCluster");

var _routes = require("./routes");

var _services = require("./services");

var _LogTypeService = require("./services/LogTypeService");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SecurityAnalyticsPlugin {
  async setup(core) {
    // Create OpenSearch client that aware of SA API endpoints
    const osDriver = (0, _createSecurityAnalyticsCluster.createSecurityAnalyticsCluster)(core); // Initialize services

    const services = {
      detectorsService: new _services.DetectorService(osDriver),
      correlationService: new _services.CorrelationService(osDriver),
      indexService: new _services.IndexService(osDriver),
      findingsService: new _services.FindingsService(osDriver),
      opensearchService: new _services.OpenSearchService(osDriver),
      fieldMappingService: new _services.FieldMappingService(osDriver),
      alertService: new _services.AlertService(osDriver),
      rulesService: new _services.RulesService(osDriver),
      notificationsService: new _services.NotificationsService(osDriver),
      logTypeService: new _LogTypeService.LogTypeService(osDriver)
    }; // Create router

    const router = core.http.createRouter(); // setup routes

    (0, _routes.setupDetectorRoutes)(services, router);
    (0, _routes.setupCorrelationRoutes)(services, router);
    (0, _routes.setupIndexRoutes)(services, router);
    (0, _routes.setupFindingsRoutes)(services, router);
    (0, _routes.setupOpensearchRoutes)(services, router);
    (0, _routes.setupFieldMappingRoutes)(services, router);
    (0, _routes.setupAlertsRoutes)(services, router);
    (0, _routes.setupRulesRoutes)(services, router);
    (0, _routes.setupNotificationsRoutes)(services, router);
    (0, _routes.setupLogTypeRoutes)(services, router);
    return {};
  }

  async start(_core) {
    return {};
  }

}

exports.SecurityAnalyticsPlugin = SecurityAnalyticsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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