"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReport = void 0;

var _constants = require("../utils/constants");

var _savedSearchReportHelper = require("../utils/savedSearchReportHelper");

var _saveReport = require("./saveReport");

var _lodash = _interopRequireDefault(require("lodash"));

var _helpers = require("../utils/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const createReport = async (request, context, report, config, savedReportId) => {
  const isScheduledTask = false; //@ts-ignore

  const logger = context.reporting_plugin.logger; // @ts-ignore

  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request);
  const opensearchClient = context.core.opensearch.legacy.client; // @ts-ignore

  const timezone = request.query.timezone; // @ts-ignore

  const dateFormat = request.query.dateFormat || _constants.DATA_REPORT_CONFIG.excelDateFormat; // @ts-ignore

  const csvSeparator = request.query.csvSeparator || ','; // @ts-ignore

  const allowLeadingWildcards = !!request.query.allowLeadingWildcards;
  const protocol = config.get('osd_server', 'protocol');
  const hostname = config.get('osd_server', 'hostname');
  const port = config.get('osd_server', 'port');
  const basePath = config.osdConfig.get('server', 'basePath');
  let createReportResult;
  let reportId;
  const {
    report_definition: {
      report_params: reportParams
    }
  } = report;
  const {
    report_source: reportSource
  } = reportParams;

  try {
    // create new report instance and set report state to "pending"
    if (savedReportId) {
      reportId = savedReportId;
    } else {
      const opensearchResp = await (0, _saveReport.saveReport)(report, opensearchReportsClient);
      reportId = opensearchResp.reportInstance.id;
    } // generate report


    if (reportSource === _constants.REPORT_TYPE.savedSearch) {
      createReportResult = await (0, _savedSearchReportHelper.createSavedSearchReport)(report, opensearchClient, dateFormat, csvSeparator, allowLeadingWildcards, isScheduledTask, logger);
    } else {
      // report source can only be one of [saved search, visualization, dashboard, notebook]
      // compose url
      const relativeUrl = report.query_url.startsWith(basePath) ? report.query_url : `${basePath}${report.query_url}`;
      const completeQueryUrl = `${protocol}://${hostname}:${port}${relativeUrl}`;

      const extraHeaders = _lodash.default.pick(request.headers, _constants.EXTRA_HEADERS);

      const {
        core_params,
        report_name: reportName,
        report_source: reportSource
      } = reportParams;
      const coreParams = core_params;
      const {
        header,
        footer,
        window_height: windowHeight,
        window_width: windowWidth,
        report_format: reportFormat
      } = coreParams;
      const curTime = new Date();
      const timeCreated = curTime.valueOf();
      const fileName = `${(0, _helpers.getFileName)(reportName, curTime)}.${reportFormat}`;
      return {
        timeCreated,
        dataUrl: '',
        fileName,
        reportId,
        queryUrl: relativeUrl
      };
    } // update report state to "created"
    // TODO: temporarily remove the following
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.created);
    // }

  } catch (error) {
    // update report instance with "error" state
    // TODO: save error detail and display on UI
    // TODO: temporarily disable the following, will add back
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.error);
    // }
    throw error;
  }

  return createReportResult;
};

exports.createReport = createReport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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