"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEventAnalyticsRouter = void 0;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../../common/constants/shared");

var _metrics_helper = require("../../common/metrics/metrics_helper");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const registerEventAnalyticsRouter = ({
  router,
  savedObjectFacet
}) => {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}`,
    validate: {}
  }, async (context, req, res) => {
    var _savedRes$data, _savedRes$data2;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'get', 'count');
    const savedRes = await savedObjectFacet.getSavedObject(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data = savedRes.data) === null || _savedRes$data === void 0 ? void 0 : _savedRes$data.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data2 = savedRes.data) === null || _savedRes$data2 === void 0 ? void 0 : _savedRes$data2.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'get', result);
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectId}`,
    validate: {
      params: _configSchema.schema.object({
        objectId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data3, _savedRes$data4;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'get', 'count');
    const savedRes = await savedObjectFacet.getSavedObjectById(req, req.params.objectId);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data3 = savedRes.data) === null || _savedRes$data3 === void 0 ? void 0 : _savedRes$data3.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data4 = savedRes.data) === null || _savedRes$data4 === void 0 ? void 0 : _savedRes$data4.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'get', result);
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data5;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'create', 'count');
    const savedRes = await savedObjectFacet.createSavedQuery(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data5 = savedRes.data) === null || _savedRes$data5 === void 0 ? void 0 : _savedRes$data5.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'create', result);
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          user_configs: _configSchema.schema.maybe(_configSchema.schema.string()),
          sub_type: _configSchema.schema.maybe(_configSchema.schema.string()),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            label: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data6;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'create', 'count');
    const savedRes = await savedObjectFacet.createSavedVisualization(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data6 = savedRes.data) === null || _savedRes$data6 === void 0 ? void 0 : _savedRes$data6.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'create', result);
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data7;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'update', 'count');
    const savedRes = await savedObjectFacet.updateSavedQuery(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data7 = savedRes.data) === null || _savedRes$data7 === void 0 ? void 0 : _savedRes$data7.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'update', result);
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          user_configs: _configSchema.schema.maybe(_configSchema.schema.string()),
          sub_type: _configSchema.schema.maybe(_configSchema.schema.string()),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            labels: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _updateRes$data;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'update', 'count');
    const updateRes = await savedObjectFacet.updateSavedVisualization(req);
    const result = {
      body: { ...updateRes.data
      }
    };
    if (updateRes.success) return res.ok(result);
    result.statusCode = (updateRes === null || updateRes === void 0 ? void 0 : (_updateRes$data = updateRes.data) === null || _updateRes$data === void 0 ? void 0 : _updateRes$data.statusCode) || 500;
    result.message = (updateRes === null || updateRes === void 0 ? void 0 : updateRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'update', result);
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        index: _configSchema.schema.string(),
        type: _configSchema.schema.string(),
        dsl_type: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data8;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'create', 'count');
    const savedRes = await savedObjectFacet.createSavedTimestamp(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data8 = savedRes.data) === null || _savedRes$data8 === void 0 ? void 0 : _savedRes$data8.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'create', result);
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        objectId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.object({
          name: _configSchema.schema.string(),
          index: _configSchema.schema.string(),
          type: _configSchema.schema.string(),
          dsl_type: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data9;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'update', 'count');
    const savedRes = await savedObjectFacet.updateSavedTimestamp(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data9 = savedRes.data) === null || _savedRes$data9 === void 0 ? void 0 : _savedRes$data9.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'update', result);
    return res.custom(result);
  });
  router.delete({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectIdList}`,
    validate: {
      params: _configSchema.schema.object({
        objectIdList: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _deleteResponse$data;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'delete', 'count');
    const deleteResponse = await savedObjectFacet.deleteSavedObject(req);
    const result = {
      body: { ...deleteResponse.data
      }
    };
    if (deleteResponse.success) return res.ok(result);
    result.statusCode = (deleteResponse === null || deleteResponse === void 0 ? void 0 : (_deleteResponse$data = deleteResponse.data) === null || _deleteResponse$data === void 0 ? void 0 : _deleteResponse$data.statusCode) || 500;
    result.message = (deleteResponse === null || deleteResponse === void 0 ? void 0 : deleteResponse.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'delete', result);
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/addSampleSavedObjects/{sampleRequestor}`,
    validate: {
      params: _configSchema.schema.object({
        sampleRequestor: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data10;

    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'add_samples', 'count');
    const savedRes = await savedObjectFacet.createSampleSavedObjects(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data10 = savedRes.data) === null || _savedRes$data10 === void 0 ? void 0 : _savedRes$data10.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    (0, _metrics_helper.addRequestToMetric)('event_analytics', 'add_samples', result);
    return res.custom(result);
  });
};

exports.registerEventAnalyticsRouter = registerEventAnalyticsRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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