/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.gui;

import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.gui.PrimitiveTreeNode;
import jde.debugger.gui.ReferenceTreeNode;

abstract class LVTreeNode
implements MutableTreeNode,
Protocol {
    protected final String m_name;
    protected final String m_typeName;
    protected Type m_type;
    private DefaultTreeModel m_model;
    private TreeNode m_parent;

    protected LVTreeNode(String name, String typeName, Value val, DefaultTreeModel model) {
        this.m_name = name;
        this.m_typeName = typeName;
        this.m_model = model;
        this.setValue(val, false);
    }

    public static MutableTreeNode makeTreeNode(String name, String typeName, Value val, DefaultTreeModel model) throws JDEException {
        if (val instanceof PrimitiveValue) {
            return new PrimitiveTreeNode(name, typeName, val, model);
        }
        if (val instanceof ObjectReference || val == null) {
            return new ReferenceTreeNode(name, typeName, val, model);
        }
        throw new JDEException("Unknown variable type " + val);
    }

    public static MutableTreeNode makeTreeNode(LocalVariable localVar, Value val, DefaultTreeModel model) throws JDEException {
        return LVTreeNode.makeTreeNode(localVar.name(), localVar.typeName(), val, model);
    }

    public static MutableTreeNode makeTreeNode(Field field, Value val, DefaultTreeModel model) throws JDEException {
        return LVTreeNode.makeTreeNode(field.name(), field.typeName(), val, model);
    }

    public TreeNode getParent() {
        return this.m_parent;
    }

    public void setParent(MutableTreeNode parent) {
        this.m_parent = parent;
    }

    public void remove(int n) {
        throw new IllegalArgumentException("Attempt to remove a node from the local variables tree");
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        throw new IllegalArgumentException("Attempt to remove a node from the local variables tree");
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        throw new IllegalArgumentException("Attempt to insert a node from the local variables tree");
    }

    public void setUserObject(Object object) {
    }

    public void removeFromParent() {
        throw new IllegalArgumentException("Attempt to remove a node from its parent in the local variables tree");
    }

    String getName() {
        return this.m_name;
    }

    String getTypeName() {
        return this.m_typeName;
    }

    public void setValue(Value val) {
        this.setValue(val, true);
    }

    private void setValue(Value val, boolean notify) {
        int oldNumChildren = this.getChildCount();
        this.m_type = val != null ? val.type() : null;
        this.valueChanged(val);
        if (notify) {
            this.handleChildChange(oldNumChildren);
        }
    }

    abstract void valueChanged(Value var1);

    private void handleChildChange(int oldNumChildren) {
        int numChildren = this.getChildCount();
        JDE.debug(64, "handleChildChange: old=" + oldNumChildren + ",new=" + numChildren + ",name=" + this.getName());
        if (numChildren == oldNumChildren) {
            this.m_model.nodeChanged(this);
            JDE.debug(64, "nodeChanged(" + this.getName() + ")");
        } else if (numChildren > oldNumChildren) {
            int[] added = new int[numChildren - oldNumChildren];
            int index = 0;
            while (index < added.length) {
                added[index] = oldNumChildren + index;
                ++index;
            }
            this.m_model.nodesWereInserted(this, added);
            JDE.debug(64, "nodesWereInserted(" + this.getName() + ")");
        } else {
            this.m_model.nodeStructureChanged(this);
            JDE.debug(64, "nodeStructureChanged(" + this.getName() + ")");
        }
    }

    abstract String getValue();

    protected DefaultTreeModel getModel() {
        return this.m_model;
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "m_name=" + this.m_name + "," + "m_typeName=" + this.m_typeName + "," + "m_type=" + this.m_type + "," + "m_model=" + this.m_model + "," + "m_parent=" + this.m_parent;
    }

    public abstract Enumeration children();

    public abstract boolean isLeaf();

    public abstract boolean getAllowsChildren();

    public abstract int getIndex(TreeNode var1);

    public abstract int getChildCount();

    public abstract TreeNode getChildAt(int var1);
}

