/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.Collection;
import java.util.List;
import org.jparsec.ListFactory;
import org.jparsec.ParseContext;
import org.jparsec.Parser;

final class RepeatTimesParser<T>
extends Parser<List<T>> {
    private final Parser<? extends T> parser;
    private final int min;
    private final int max;
    private final ListFactory<T> listFactory;

    RepeatTimesParser(Parser<? extends T> parser, int min, int max) {
        this(parser, min, max, ListFactory.arrayListFactory());
    }

    RepeatTimesParser(Parser<? extends T> parser, int min, int max, ListFactory<T> listFactory) {
        this.parser = parser;
        this.min = min;
        this.max = max;
        this.listFactory = listFactory;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        List<T> result = this.listFactory.newList();
        if (!ctxt.repeat(this.parser, this.min, result)) {
            return false;
        }
        if (this.repeatAtMost(this.max - this.min, result, ctxt)) {
            ctxt.result = result;
            return true;
        }
        return false;
    }

    public String toString() {
        return "times";
    }

    private boolean repeatAtMost(int times, Collection<T> collection, ParseContext ctxt) {
        for (int i = 0; i < times; ++i) {
            int physical = ctxt.at;
            int logical = ctxt.step;
            if (!this.parser.apply(ctxt)) {
                ctxt.setAt(logical, physical);
                return true;
            }
            collection.add(this.parser.getReturn(ctxt));
        }
        return true;
    }
}

