/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.notification.MessageException;
import org.traccar.sms.SmsManager;

public class HttpSmsClient
implements SmsManager {
    private final Client client;
    private final String url;
    private final String authorizationHeader;
    private final String authorization;
    private final String template;
    private final boolean encode;
    private final MediaType mediaType;

    public HttpSmsClient(Config config, Client client) {
        this.client = client;
        this.url = config.getString(Keys.SMS_HTTP_URL);
        this.authorizationHeader = config.getString(Keys.SMS_HTTP_AUTHORIZATION_HEADER);
        if (config.hasKey(Keys.SMS_HTTP_AUTHORIZATION)) {
            this.authorization = config.getString(Keys.SMS_HTTP_AUTHORIZATION);
        } else {
            String user = config.getString(Keys.SMS_HTTP_USER);
            String password = config.getString(Keys.SMS_HTTP_PASSWORD);
            this.authorization = user != null && password != null ? "Basic " + DataConverter.printBase64((user + ":" + password).getBytes(StandardCharsets.UTF_8)) : null;
        }
        this.template = config.getString(Keys.SMS_HTTP_TEMPLATE).trim();
        if (this.template.charAt(0) == '{' || this.template.charAt(0) == '[') {
            this.encode = false;
            this.mediaType = MediaType.APPLICATION_JSON_TYPE;
        } else {
            this.encode = true;
            this.mediaType = MediaType.APPLICATION_FORM_URLENCODED_TYPE;
        }
    }

    private String prepareValue(String value) throws UnsupportedEncodingException {
        return this.encode ? URLEncoder.encode(value, StandardCharsets.UTF_8.name()) : value;
    }

    private String preparePayload(String destAddress, String message) {
        try {
            return this.template.replace("{phone}", this.prepareValue(destAddress)).replace("{message}", this.prepareValue(message.trim()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Invocation.Builder getRequestBuilder() {
        Invocation.Builder builder = this.client.target(this.url).request();
        if (this.authorization != null) {
            builder = builder.header(this.authorizationHeader, (Object)this.authorization);
        }
        return builder;
    }

    @Override
    public void sendMessage(String destAddress, String message, boolean command) throws MessageException {
        try (Response response = this.getRequestBuilder().post(Entity.entity((Object)this.preparePayload(destAddress, message), (MediaType)this.mediaType));){
            if (response.getStatus() / 100 != 2) {
                throw new MessageException((String)response.readEntity(String.class));
            }
        }
    }
}

