/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.schedule.ScheduleTask;

public class TaskHealthCheck
implements ScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHealthCheck.class);
    private final Config config;
    private final Client client;
    private SystemD systemD;
    private boolean enabled;
    private long period;

    @Inject
    public TaskHealthCheck(Config config, Client client) {
        this.config = config;
        this.client = client;
        if (!config.getBoolean(Keys.WEB_DISABLE_HEALTH_CHECK) && System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            try {
                this.systemD = (SystemD)Native.load((String)"systemd", SystemD.class);
                String watchdogTimer = System.getenv("WATCHDOG_USEC");
                if (watchdogTimer != null && !watchdogTimer.isEmpty()) {
                    this.period = Long.parseLong(watchdogTimer) / 1000L * 4L / 5L;
                }
                if (this.period > 0L) {
                    LOGGER.info("Health check enabled with period {}", (Object)this.period);
                    this.enabled = true;
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warn("No systemd support", (Throwable)e);
            }
        }
    }

    private String getUrl() {
        String address = this.config.getString(Keys.WEB_ADDRESS, "localhost");
        int port = this.config.getInteger(Keys.WEB_PORT);
        return "http://" + address + ":" + port + "/api/server";
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        if (this.enabled) {
            executor.scheduleAtFixedRate(this, this.period, this.period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void run() {
        LOGGER.debug("Health check running");
        int status = this.client.target(this.getUrl()).request().get().getStatus();
        if (status == 200) {
            int result = this.systemD.sd_notify(0, "WATCHDOG=1");
            if (result < 0) {
                LOGGER.warn("Health check notify error {}", (Object)result);
            }
        } else {
            LOGGER.warn("Health check failed with status {}", (Object)status);
        }
    }

    static interface SystemD
    extends Library {
        public int sd_notify(int var1, String var2);
    }
}

