/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TramigoProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_COMPACT = 256;
    public static final int MSG_FULL = 254;
    private static final String[] DIRECTIONS = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};

    public TramigoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short protocol = buf.readUnsignedByte();
        boolean legacy = protocol == 128;
        buf.readUnsignedByte();
        int index = legacy ? buf.readUnsignedShort() : buf.readUnsignedShortLE();
        int type = legacy ? buf.readUnsignedShort() : buf.readUnsignedShortLE();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        long id = legacy ? buf.readUnsignedInt() : buf.readUnsignedIntLE();
        buf.readUnsignedInt();
        Position position = new Position(this.getProtocolName());
        position.set("index", index);
        position.setValid(true);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        if (protocol == 1 && (type == 256 || type == 254)) {
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            position.setLatitude((double)buf.readUnsignedIntLE() * 1.0E-7);
            position.setLongitude((double)buf.readUnsignedIntLE() * 1.0E-7);
            position.set("rssi", buf.readUnsignedShortLE());
            position.set("sat", buf.readUnsignedShortLE());
            position.set("satVisible", buf.readUnsignedShortLE());
            position.set("gpsAntennaStatus", buf.readUnsignedShortLE());
            position.setSpeed((double)buf.readUnsignedShortLE() * 0.194384);
            position.setCourse(buf.readUnsignedShortLE());
            position.set("odometer", buf.readUnsignedIntLE());
            position.set("battery", buf.readUnsignedShortLE());
            position.set("charge", buf.readUnsignedShortLE());
            position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
            return position;
        }
        if (legacy) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)("gprs,ack," + index), (Charset)StandardCharsets.US_ASCII), remoteAddress));
            }
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            Pattern pattern = Pattern.compile("(-?\\d+\\.\\d+), (-?\\d+\\.\\d+)");
            Matcher matcher = pattern.matcher(sentence);
            if (!matcher.find()) {
                return null;
            }
            position.setLatitude(Double.parseDouble(matcher.group(1)));
            position.setLongitude(Double.parseDouble(matcher.group(2)));
            pattern = Pattern.compile("([NSWE]{1,2}) with speed (\\d+) km/h");
            matcher = pattern.matcher(sentence);
            if (matcher.find()) {
                for (int i = 0; i < DIRECTIONS.length; ++i) {
                    if (!matcher.group(1).equals(DIRECTIONS[i])) continue;
                    position.setCourse((double)i * 45.0);
                    break;
                }
                position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(matcher.group(2))));
            }
            if (!(matcher = (pattern = Pattern.compile("(\\d{1,2}:\\d{2}(:\\d{2})? \\w{3} \\d{1,2})")).matcher(sentence)).find()) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(matcher.group(2) != null ? "HH:mm:ss MMM d yyyy" : "HH:mm MMM d yyyy", Locale.ENGLISH);
            position.setTime(DateUtil.correctYear(dateFormat.parse(matcher.group(1) + " " + Calendar.getInstance().get(1))));
            if (sentence.contains("Ignition on detected")) {
                position.set("ignition", true);
            } else if (sentence.contains("Ignition off detected")) {
                position.set("ignition", false);
            }
            return position;
        }
        return null;
    }
}

