/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage;

import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchIndexScan
extends TableScanOperator {
    private final OpenSearchClient client;
    private final OpenSearchRequestBuilder requestBuilder;
    private OpenSearchRequest request;
    private Integer querySize;
    private Integer queryCount;
    private Iterator<ExprValue> iterator;

    public OpenSearchIndexScan(OpenSearchClient client, Settings settings, String indexName, Integer maxResultWindow, OpenSearchExprValueFactory exprValueFactory) {
        this(client, settings, new OpenSearchRequest.IndexName(indexName), maxResultWindow, exprValueFactory);
    }

    public OpenSearchIndexScan(OpenSearchClient client, Settings settings, OpenSearchRequest.IndexName indexName, Integer maxResultWindow, OpenSearchExprValueFactory exprValueFactory) {
        this.client = client;
        this.requestBuilder = new OpenSearchRequestBuilder(indexName, maxResultWindow, settings, exprValueFactory);
    }

    public void open() {
        super.open();
        this.querySize = this.requestBuilder.getQuerySize();
        this.request = this.requestBuilder.build();
        this.iterator = Collections.emptyIterator();
        this.queryCount = 0;
        this.fetchNextBatch();
    }

    public boolean hasNext() {
        if (this.queryCount >= this.querySize) {
            this.iterator = Collections.emptyIterator();
        } else if (!this.iterator.hasNext()) {
            this.fetchNextBatch();
        }
        return this.iterator.hasNext();
    }

    public ExprValue next() {
        Integer n = this.queryCount;
        this.queryCount = this.queryCount + 1;
        return this.iterator.next();
    }

    private void fetchNextBatch() {
        OpenSearchResponse response = this.client.search(this.request);
        if (!response.isEmpty()) {
            this.iterator = response.iterator();
        }
    }

    public void close() {
        super.close();
        this.client.cleanup(this.request);
    }

    public String explain() {
        return this.getRequestBuilder().build().toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchIndexScan)) {
            return false;
        }
        OpenSearchIndexScan other = (OpenSearchIndexScan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$querySize = this.querySize;
        Integer other$querySize = other.querySize;
        if (this$querySize == null ? other$querySize != null : !((Object)this$querySize).equals(other$querySize)) {
            return false;
        }
        OpenSearchRequestBuilder this$requestBuilder = this.getRequestBuilder();
        OpenSearchRequestBuilder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !((Object)this$requestBuilder).equals(other$requestBuilder)) {
            return false;
        }
        OpenSearchRequest this$request = this.request;
        OpenSearchRequest other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchIndexScan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $querySize = this.querySize;
        result = result * 59 + ($querySize == null ? 43 : ((Object)$querySize).hashCode());
        OpenSearchRequestBuilder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : ((Object)$requestBuilder).hashCode());
        OpenSearchRequest $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSearchIndexScan(requestBuilder=" + this.getRequestBuilder() + ", request=" + this.request + ", querySize=" + this.querySize + ")";
    }

    @Generated
    public OpenSearchRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }
}

