/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.LeafGeoPointFieldData;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.script.expression.FieldDataBasedDoubleValuesSource;

final class GeoLongitudeValueSource
extends FieldDataBasedDoubleValuesSource {
    GeoLongitudeValueSource(IndexFieldData<?> fieldData) {
        super(fieldData);
    }

    public DoubleValues getValues(LeafReaderContext leaf, DoubleValues scores) {
        LeafGeoPointFieldData leafData = (LeafGeoPointFieldData)this.fieldData.load(leaf);
        final MultiGeoPointValues values = leafData.getGeoPointValues();
        return new DoubleValues(){

            public double doubleValue() throws IOException {
                return values.nextValue().getLon();
            }

            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + this.fieldData.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GeoLongitudeValueSource other = (GeoLongitudeValueSource)((Object)obj);
        return this.fieldData.equals(other.fieldData);
    }

    public String toString() {
        return "lon: field(" + this.fieldData.getFieldName() + ")";
    }
}

