/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.UCaseProps;
import com.ibm.icu.util.ULocale;

public final class CaseMap {
    private static final void appendResult(int c, StringBuilder result) {
        if (c < 0) {
            result.appendCodePoint(~c);
        } else if (c > 31) {
            result.appendCodePoint(c);
        }
    }

    public static String toUpper(ULocale locale, String str) {
        int c;
        int[] locCache;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((locCache = new int[]{UCaseProps.getCaseLocale(locale, null)})[0] == 4) {
            return GreekUpper.toUpper(str, locCache);
        }
        StringContextIterator iter = new StringContextIterator(str);
        StringBuilder result = new StringBuilder(str.length());
        while ((c = iter.nextCaseMapCP()) >= 0) {
            c = UCaseProps.INSTANCE.toFullUpper(c, iter, result, locale, locCache);
            CaseMap.appendResult(c, result);
        }
        return result.toString();
    }

    private static final class GreekUpper {
        private static final int UPPER_MASK = 1023;
        private static final int HAS_VOWEL = 4096;
        private static final int HAS_YPOGEGRAMMENI = 8192;
        private static final int HAS_ACCENT = 16384;
        private static final int HAS_DIALYTIKA = 32768;
        private static final int HAS_COMBINING_DIALYTIKA = 65536;
        private static final int HAS_OTHER_GREEK_DIACRITIC = 131072;
        private static final int HAS_VOWEL_AND_ACCENT = 20480;
        private static final int HAS_VOWEL_AND_ACCENT_AND_DIALYTIKA = 53248;
        private static final int HAS_EITHER_DIALYTIKA = 98304;
        private static final int AFTER_CASED = 1;
        private static final int AFTER_VOWEL_WITH_ACCENT = 2;
        private static final char[] data0370 = new char[]{'\u0370', '\u0370', '\u0372', '\u0372', '\u0000', '\u0000', '\u0376', '\u0376', '\u0000', '\u0000', '\u037a', '\u03fd', '\u03fe', '\u03ff', '\u0000', '\u037f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u5391', '\u0000', '\u5395', '\u5397', '\u5399', '\u0000', '\u539f', '\u0000', '\u53a5', '\u53a9', '\ud399', '\u1391', '\u0392', '\u0393', '\u0394', '\u1395', '\u0396', '\u1397', '\u0398', '\u1399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u139f', '\u03a0', '\u03a1', '\u0000', '\u03a3', '\u03a4', '\u13a5', '\u03a6', '\u03a7', '\u03a8', '\u13a9', '\u9399', '\u93a5', '\u5391', '\u5395', '\u5397', '\u5399', '\ud3a5', '\u1391', '\u0392', '\u0393', '\u0394', '\u1395', '\u0396', '\u1397', '\u0398', '\u1399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u139f', '\u03a0', '\u03a1', '\u03a3', '\u03a3', '\u03a4', '\u13a5', '\u03a6', '\u03a7', '\u03a8', '\u13a9', '\u9399', '\u93a5', '\u539f', '\u53a5', '\u53a9', '\u03cf', '\u0392', '\u0398', '\u03d2', '\u43d2', '\u83d2', '\u03a6', '\u03a0', '\u03cf', '\u03d8', '\u03d8', '\u03da', '\u03da', '\u03dc', '\u03dc', '\u03de', '\u03de', '\u03e0', '\u03e0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u039a', '\u03a1', '\u03f9', '\u037f', '\u03f4', '\u1395', '\u0000', '\u03f7', '\u03f7', '\u03f9', '\u03fa', '\u03fa', '\u03fc', '\u03fd', '\u03fe', '\u03ff'};
        private static final char[] data1F00 = new char[]{'\u1391', '\u1391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u1391', '\u1391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u5391', '\u1395', '\u1395', '\u5395', '\u5395', '\u5395', '\u5395', '\u0000', '\u0000', '\u1395', '\u1395', '\u5395', '\u5395', '\u5395', '\u5395', '\u0000', '\u0000', '\u1397', '\u1397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u1397', '\u1397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u5397', '\u1399', '\u1399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u1399', '\u1399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u5399', '\u139f', '\u139f', '\u539f', '\u539f', '\u539f', '\u539f', '\u0000', '\u0000', '\u139f', '\u139f', '\u539f', '\u539f', '\u539f', '\u539f', '\u0000', '\u0000', '\u13a5', '\u13a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u53a5', '\u0000', '\u13a5', '\u0000', '\u53a5', '\u0000', '\u53a5', '\u0000', '\u53a5', '\u13a9', '\u13a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u13a9', '\u13a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u53a9', '\u5391', '\u5391', '\u5395', '\u5395', '\u5397', '\u5397', '\u5399', '\u5399', '\u539f', '\u539f', '\u53a5', '\u53a5', '\u53a9', '\u53a9', '\u0000', '\u0000', '\u3391', '\u3391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u3391', '\u3391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u7391', '\u3397', '\u3397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u3397', '\u3397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u7397', '\u33a9', '\u33a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u33a9', '\u33a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u73a9', '\u1391', '\u1391', '\u7391', '\u3391', '\u7391', '\u0000', '\u5391', '\u7391', '\u1391', '\u1391', '\u5391', '\u5391', '\u3391', '\u0000', '\u1399', '\u0000', '\u0000', '\u0000', '\u7397', '\u3397', '\u7397', '\u0000', '\u5397', '\u7397', '\u5395', '\u5395', '\u5397', '\u5397', '\u3397', '\u0000', '\u0000', '\u0000', '\u1399', '\u1399', '\ud399', '\ud399', '\u0000', '\u0000', '\u5399', '\ud399', '\u1399', '\u1399', '\u5399', '\u5399', '\u0000', '\u0000', '\u0000', '\u0000', '\u13a5', '\u13a5', '\ud3a5', '\ud3a5', '\u03a1', '\u03a1', '\u53a5', '\ud3a5', '\u13a5', '\u13a5', '\u53a5', '\u53a5', '\u03a1', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u73a9', '\u33a9', '\u73a9', '\u0000', '\u53a9', '\u73a9', '\u539f', '\u539f', '\u53a9', '\u53a9', '\u33a9', '\u0000', '\u0000', '\u0000'};
        private static final char data2126 = '\u13a9';

        private GreekUpper() {
        }

        private static final int getLetterData(int c) {
            if (c < 880 || 8486 < c || 1023 < c && c < 7936) {
                return 0;
            }
            if (c <= 1023) {
                return data0370[c - 880];
            }
            if (c <= 8191) {
                return data1F00[c - 7936];
            }
            if (c == 8486) {
                return 5033;
            }
            return 0;
        }

        private static final int getDiacriticData(int c) {
            switch (c) {
                case 768: 
                case 769: 
                case 770: 
                case 771: 
                case 785: 
                case 834: {
                    return 16384;
                }
                case 776: {
                    return 65536;
                }
                case 836: {
                    return 81920;
                }
                case 837: {
                    return 8192;
                }
                case 772: 
                case 774: 
                case 787: 
                case 788: 
                case 835: {
                    return 131072;
                }
            }
            return 0;
        }

        private static boolean isFollowedByCasedLetter(CharSequence s, int i) {
            while (i < s.length()) {
                int c = Character.codePointAt(s, i);
                int type = UCaseProps.INSTANCE.getTypeOrIgnorable(c);
                if ((type & 4) != 0) continue;
                return type != 0;
            }
            return false;
        }

        private static String toUpper(CharSequence s, int[] locCache) {
            StringBuilder result = new StringBuilder(s.length());
            int state = 0;
            int i = 0;
            while (i < s.length()) {
                int c = Character.codePointAt(s, i);
                int nextIndex = i + Character.charCount(c);
                int nextState = 0;
                int type = UCaseProps.INSTANCE.getTypeOrIgnorable(c);
                if ((type & 4) != 0) {
                    nextState |= state & true;
                } else if (type != 0) {
                    nextState |= 1;
                }
                int data = GreekUpper.getLetterData(c);
                if (data > 0) {
                    int diacriticData;
                    int upper = data & 0x3FF;
                    if ((data & 0x1000) != 0 && (state & 2) != 0 && (upper == 921 || upper == 933)) {
                        data |= 0x8000;
                    }
                    int numYpogegrammeni = 0;
                    if ((data & 0x2000) != 0) {
                        numYpogegrammeni = 1;
                    }
                    while (nextIndex < s.length() && (diacriticData = GreekUpper.getDiacriticData(s.charAt(nextIndex))) != 0) {
                        data |= diacriticData;
                        if ((diacriticData & 0x2000) != 0) {
                            ++numYpogegrammeni;
                        }
                        ++nextIndex;
                    }
                    if ((data & 0xD000) == 20480) {
                        nextState |= 2;
                    }
                    boolean addTonos = false;
                    if (upper == 919 && (data & 0x4000) != 0 && numYpogegrammeni == 0 && (state & 1) == 0 && !GreekUpper.isFollowedByCasedLetter(s, nextIndex)) {
                        if (i == nextIndex) {
                            upper = 905;
                        } else {
                            addTonos = true;
                        }
                    } else if ((data & 0x8000) != 0) {
                        if (upper == 921) {
                            upper = 938;
                            data &= 0xFFFE7FFF;
                        } else if (upper == 933) {
                            upper = 939;
                            data &= 0xFFFE7FFF;
                        }
                    }
                    result.appendCodePoint(upper);
                    if ((data & 0x18000) != 0) {
                        result.append('\u0308');
                    }
                    if (addTonos) {
                        result.append('\u0301');
                    }
                    while (numYpogegrammeni > 0) {
                        result.append('\u0399');
                        --numYpogegrammeni;
                    }
                } else {
                    c = UCaseProps.INSTANCE.toFullUpper(c, null, result, null, locCache);
                    CaseMap.appendResult(c, result);
                }
                i = nextIndex;
                state = nextState;
            }
            return result.toString();
        }
    }

    public static final class StringContextIterator
    implements UCaseProps.ContextIterator {
        protected String s;
        protected int index;
        protected int limit;
        protected int cpStart;
        protected int cpLimit;
        protected int dir;

        public StringContextIterator(String s) {
            this.s = s;
            this.limit = s.length();
            this.index = 0;
            this.cpLimit = 0;
            this.cpStart = 0;
            this.dir = 0;
        }

        public void setLimit(int lim) {
            this.limit = 0 <= lim && lim <= this.s.length() ? lim : this.s.length();
        }

        public void moveToLimit() {
            this.cpStart = this.cpLimit = this.limit;
        }

        public int nextCaseMapCP() {
            this.cpStart = this.cpLimit;
            if (this.cpLimit < this.limit) {
                int c = this.s.codePointAt(this.cpLimit);
                this.cpLimit += Character.charCount(c);
                return c;
            }
            return -1;
        }

        public int getCPStart() {
            return this.cpStart;
        }

        public int getCPLimit() {
            return this.cpLimit;
        }

        @Override
        public void reset(int direction) {
            if (direction > 0) {
                this.dir = 1;
                this.index = this.cpLimit;
            } else if (direction < 0) {
                this.dir = -1;
                this.index = this.cpStart;
            } else {
                this.dir = 0;
                this.index = 0;
            }
        }

        @Override
        public int next() {
            if (this.dir > 0 && this.index < this.s.length()) {
                int c = this.s.codePointAt(this.index);
                this.index += Character.charCount(c);
                return c;
            }
            if (this.dir < 0 && this.index > 0) {
                int c = this.s.codePointBefore(this.index);
                this.index -= Character.charCount(c);
                return c;
            }
            return -1;
        }
    }
}

