/*
 * Decompiled with CFR 0.152.
 */
package kotlin.test;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertContentEqualsImplKt;
import kotlin.test.AssertionsKt;
import kotlin.test.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\b\u001a\u00a4\u0001\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\t0\b2\u001f\u0010\n\u001a\u001b\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0002\b\r2\u0019\u0010\u000e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\b\r2!\u0010\u000f\u001a\u001d\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\u0010\u0011\u001aV\u0010\u0012\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00022\u001b\u0010\u0014\u001a\u0017\u0012\u0004\u0012\u0002H\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\b\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\u0010\u0016\u001ak\u0010\u0017\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00022\b\u0010\u0006\u001a\u0004\u0018\u0001H\u00022\u0019\u0010\u000e\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\b\rH\u0002\u0082\u0002\u0014\n\u0012\b\u0000\u0012\u0002\u0018\u0001\u001a\n\b\u0003\u0010\u00032\u0004\b\u0003\u0010\u0004\u00a2\u0006\u0002\u0010\u0018\u001a,\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u001d"}, d2={"assertArrayContentEquals", "", "T", "message", "", "expected", "actual", "size", "Lkotlin/Function1;", "", "get", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "contentToString", "contentEquals", "", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "assertIterableContentEquals", "typeName", "iterator", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "checkReferenceAndNullEquality", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "elementsDifferMessage", "index", "expectedElement", "actualElement", "kotlin-test"})
public final class AssertContentEqualsImplKt {
    public static final <T> void assertIterableContentEquals(@NotNull String typeName, @Nullable String message, @Nullable T expected, @Nullable T actual, @NotNull Function1<? super T, ? extends Iterator<?>> iterator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        if (AssertContentEqualsImplKt.checkReferenceAndNullEquality(typeName, message, expected, actual, assertIterableContentEquals.1.INSTANCE)) {
            return;
        }
        int index = 0;
        Iterator expectedIt = (Iterator)iterator.invoke(expected);
        Iterator actualIt = (Iterator)iterator.invoke(actual);
        while (expectedIt.hasNext() && actualIt.hasNext()) {
            Object actualElement;
            Object expectedElement = expectedIt.next();
            if (!Intrinsics.areEqual(expectedElement, actualElement = actualIt.next())) {
                AssertionsKt.fail(Intrinsics.stringPlus((String)UtilsKt.messagePrefix(message), (Object)AssertContentEqualsImplKt.elementsDifferMessage(typeName, index, expectedElement, actualElement)));
                throw new KotlinNothingValueException();
            }
            int n = index;
            index = n + 1;
        }
        if (expectedIt.hasNext()) {
            if (!(!actualIt.hasNext())) {
                string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            AssertionsKt.fail(UtilsKt.messagePrefix(message) + typeName + " lengths differ. Expected length is bigger than " + index + ", actual length is " + index + '.');
            throw new KotlinNothingValueException();
        }
        if (actualIt.hasNext()) {
            if (!(!expectedIt.hasNext())) {
                string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            AssertionsKt.fail(UtilsKt.messagePrefix(message) + typeName + " lengths differ. Expected length is " + index + ", actual length is bigger than " + index + '.');
            throw new KotlinNothingValueException();
        }
    }

    public static final <T> void assertArrayContentEquals(@Nullable String message, @Nullable T expected, @Nullable T actual, @NotNull Function1<? super T, Integer> size, @NotNull Function2<? super T, ? super Integer, ? extends Object> get, @NotNull Function1<? super T, String> contentToString, @NotNull Function2<? super T, ? super T, Boolean> contentEquals) {
        int actualSize;
        Intrinsics.checkNotNullParameter(size, (String)"size");
        Intrinsics.checkNotNullParameter(get, (String)"get");
        Intrinsics.checkNotNullParameter(contentToString, (String)"contentToString");
        Intrinsics.checkNotNullParameter(contentEquals, (String)"contentEquals");
        if (((Boolean)contentEquals.invoke(expected, actual)).booleanValue()) {
            return;
        }
        String typeName = "Array";
        if (AssertContentEqualsImplKt.checkReferenceAndNullEquality(typeName, message, expected, actual, contentToString)) {
            return;
        }
        int expectedSize = ((Number)size.invoke(expected)).intValue();
        if (expectedSize != (actualSize = ((Number)size.invoke(actual)).intValue())) {
            String sizesDifferMessage = typeName + " sizes differ. Expected size is " + expectedSize + ", actual size is " + actualSize + '.';
            String toString = "Expected <" + (String)contentToString.invoke(expected) + ">, actual <" + (String)contentToString.invoke(actual) + ">.";
            AssertionsKt.fail(UtilsKt.messagePrefix(message) + sizesDifferMessage + '\n' + toString);
            throw new KotlinNothingValueException();
        }
        int n = 0;
        while (n < expectedSize) {
            Object actualElement;
            int index;
            Object expectedElement;
            if (Intrinsics.areEqual((Object)(expectedElement = get.invoke(expected, (Object)(index = n++))), (Object)(actualElement = get.invoke(actual, (Object)index)))) continue;
            String elementsDifferMessage = AssertContentEqualsImplKt.elementsDifferMessage(typeName, index, expectedElement, actualElement);
            String toString = "Expected <" + (String)contentToString.invoke(expected) + ">, actual <" + (String)contentToString.invoke(actual) + ">.";
            AssertionsKt.fail(UtilsKt.messagePrefix(message) + elementsDifferMessage + '\n' + toString);
            throw new KotlinNothingValueException();
        }
    }

    private static final <T> boolean checkReferenceAndNullEquality(String typeName, String message, T expected, T actual, Function1<? super T, String> contentToString) {
        if (expected == actual) {
            return true;
        }
        if (expected == null) {
            AssertionsKt.fail(UtilsKt.messagePrefix(message) + "Expected <null> " + typeName + ", actual <" + (String)contentToString.invoke(actual) + ">.");
            throw new KotlinNothingValueException();
        }
        if (actual == null) {
            AssertionsKt.fail(UtilsKt.messagePrefix(message) + "Expected non-null " + typeName + " <" + (String)contentToString.invoke(expected) + ">, actual <null>.");
            throw new KotlinNothingValueException();
        }
        return false;
    }

    private static final String elementsDifferMessage(String typeName, int index, Object expectedElement, Object actualElement) {
        return typeName + " elements differ at index " + index + ". Expected element <" + expectedElement + ">, actual element <" + actualElement + ">.";
    }
}

