/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.feature.SearchFeatureDao;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.rest.handler.IndexAnomalyDetectorActionHandler;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.IndexAnomalyDetectorAction;
import org.opensearch.ad.transport.IndexAnomalyDetectorRequest;
import org.opensearch.ad.transport.IndexAnomalyDetectorResponse;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class IndexAnomalyDetectorTransportAction
extends HandledTransportAction<IndexAnomalyDetectorRequest, IndexAnomalyDetectorResponse> {
    private static final Logger LOG = LogManager.getLogger(IndexAnomalyDetectorTransportAction.class);
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final TransportService transportService;
    private final AnomalyDetectionIndices anomalyDetectionIndices;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final ADTaskManager adTaskManager;
    private volatile Boolean filterByEnabled;
    private final SearchFeatureDao searchFeatureDao;
    private final Settings settings;

    @Inject
    public IndexAnomalyDetectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SecurityClientUtil clientUtil, ClusterService clusterService, Settings settings, AnomalyDetectionIndices anomalyDetectionIndices, NamedXContentRegistry xContentRegistry, ADTaskManager adTaskManager, SearchFeatureDao searchFeatureDao) {
        super(IndexAnomalyDetectorAction.NAME, transportService, actionFilters, IndexAnomalyDetectorRequest::new);
        this.client = client;
        this.clientUtil = clientUtil;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.xContentRegistry = xContentRegistry;
        this.adTaskManager = adTaskManager;
        this.searchFeatureDao = searchFeatureDao;
        this.filterByEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
        this.settings = settings;
    }

    protected void doExecute(Task task, IndexAnomalyDetectorRequest request, ActionListener<IndexAnomalyDetectorResponse> actionListener) {
        User user = ParseUtils.getUserContext(this.client);
        String detectorId = request.getDetectorID();
        RestRequest.Method method = request.getMethod();
        String errorMessage = method == RestRequest.Method.PUT ? CommonErrorMessages.FAIL_TO_UPDATE_DETECTOR : CommonErrorMessages.FAIL_TO_CREATE_DETECTOR;
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, errorMessage);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.resolveUserAndExecute(user, detectorId, method, (ActionListener<IndexAnomalyDetectorResponse>)listener, detector -> this.adExecute(request, user, (AnomalyDetector)detector, context, (ActionListener<IndexAnomalyDetectorResponse>)listener));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void resolveUserAndExecute(User requestedUser, String detectorId, RestRequest.Method method, ActionListener<IndexAnomalyDetectorResponse> listener, Consumer<AnomalyDetector> function) {
        try {
            if (this.filterByEnabled.booleanValue() && !ParseUtils.checkFilterByBackendRoles(requestedUser, listener)) {
                return;
            }
            if (method == RestRequest.Method.PUT) {
                boolean filterByBackendRole = requestedUser == null ? false : this.filterByEnabled;
                ParseUtils.getDetector(requestedUser, detectorId, listener, function, this.client, this.clusterService, this.xContentRegistry, filterByBackendRole);
            } else {
                function.accept(null);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void adExecute(IndexAnomalyDetectorRequest request, User user, AnomalyDetector currentDetector, ThreadContext.StoredContext storedContext, ActionListener<IndexAnomalyDetectorResponse> listener) {
        this.anomalyDetectionIndices.update();
        String detectorId = request.getDetectorID();
        long seqNo = request.getSeqNo();
        long primaryTerm = request.getPrimaryTerm();
        WriteRequest.RefreshPolicy refreshPolicy = request.getRefreshPolicy();
        AnomalyDetector detector = request.getDetector();
        RestRequest.Method method = request.getMethod();
        TimeValue requestTimeout = request.getRequestTimeout();
        Integer maxSingleEntityAnomalyDetectors = request.getMaxSingleEntityAnomalyDetectors();
        Integer maxMultiEntityAnomalyDetectors = request.getMaxMultiEntityAnomalyDetectors();
        Integer maxAnomalyFeatures = request.getMaxAnomalyFeatures();
        storedContext.restore();
        this.checkIndicesAndExecute(detector.getIndices(), () -> {
            User detectorUser = currentDetector == null ? user : currentDetector.getUser();
            IndexAnomalyDetectorActionHandler indexAnomalyDetectorActionHandler = new IndexAnomalyDetectorActionHandler(this.clusterService, this.client, this.clientUtil, this.transportService, listener, this.anomalyDetectionIndices, detectorId, seqNo, primaryTerm, refreshPolicy, detector, requestTimeout, maxSingleEntityAnomalyDetectors, maxMultiEntityAnomalyDetectors, maxAnomalyFeatures, method, this.xContentRegistry, detectorUser, this.adTaskManager, this.searchFeatureDao, this.settings);
            indexAnomalyDetectorActionHandler.start();
        }, listener);
    }

    private void checkIndicesAndExecute(List<String> indices, AnomalyDetectorFunction function, ActionListener<IndexAnomalyDetectorResponse> listener) {
        SearchRequest searchRequest = new SearchRequest().indices(indices.toArray(new String[0])).source(new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        this.client.search(searchRequest, ActionListener.wrap(r -> function.execute(), e -> {
            LOG.error(e);
            listener.onFailure(e);
        }));
    }
}

