/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.transport.ADStatsRequest;
import org.opensearch.ad.transport.StatsAnomalyDetectorAction;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestStatsAnomalyDetectorAction
extends BaseRestHandler {
    private static final String STATS_ANOMALY_DETECTOR_ACTION = "stats_anomaly_detector";
    private ADStats adStats;
    private ClusterService clusterService;
    private DiscoveryNodeFilterer nodeFilter;

    public RestStatsAnomalyDetectorAction(ADStats adStats, DiscoveryNodeFilterer nodeFilter) {
        this.adStats = adStats;
        this.nodeFilter = nodeFilter;
    }

    public String getName() {
        return STATS_ANOMALY_DETECTOR_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!EnabledSetting.isADPluginEnabled()) {
            throw new IllegalStateException("AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        ADStatsRequest adStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)StatsAnomalyDetectorAction.INSTANCE, (ActionRequest)adStatsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private ADStatsRequest getRequest(RestRequest request) {
        String nodesIdsStr = request.param("nodeId");
        Set<String> validStats = this.adStats.getStats().keySet();
        ADStatsRequest adStatsRequest = null;
        if (!Strings.isEmpty((CharSequence)nodesIdsStr)) {
            String[] nodeIdsArr = nodesIdsStr.split(",");
            adStatsRequest = new ADStatsRequest(nodeIdsArr);
        } else {
            DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
            adStatsRequest = new ADStatsRequest(dataNodes);
        }
        adStatsRequest.timeout(request.param("timeout"));
        HashSet<String> statsSet = null;
        String statsStr = request.param("stat");
        if (!Strings.isEmpty((CharSequence)statsStr)) {
            statsSet = new HashSet<String>(Arrays.asList(statsStr.split(",")));
        }
        if (statsSet == null) {
            adStatsRequest.addAll(validStats);
        } else if (statsSet.size() == 1 && statsSet.contains("_all")) {
            adStatsRequest.addAll(validStats);
        } else {
            if (statsSet.contains("_all")) {
                throw new IllegalArgumentException("Request " + request.path() + " contains _all and individual stats");
            }
            TreeSet<String> invalidStats = new TreeSet<String>();
            for (String stat : statsSet) {
                if (validStats.contains(stat)) {
                    adStatsRequest.addStat(stat);
                    continue;
                }
                invalidStats.add(stat);
            }
            if (!invalidStats.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidStats, adStatsRequest.getStatsToBeRetrieved(), "stat"));
            }
        }
        return adStatsRequest;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/{nodeId}/stats/", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/{nodeId}/stats/"), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/{nodeId}/stats/{stat}", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/{nodeId}/stats/{stat}"), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/stats/", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/stats/"), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_anomaly_detection/stats/{stat}", RestRequest.Method.GET, "/_opendistro/_anomaly_detection/stats/{stat}"));
    }
}

