/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.indices;

import java.util.function.Supplier;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.util.ThrowingSupplierWrapper;

public enum ADIndex {
    RESULT(".opendistro-anomaly-results", true, ThrowingSupplierWrapper.throwingSupplierWrapper(AnomalyDetectionIndices::getAnomalyResultMappings)),
    CONFIG(".opendistro-anomaly-detectors", false, ThrowingSupplierWrapper.throwingSupplierWrapper(AnomalyDetectionIndices::getAnomalyDetectorMappings)),
    JOB(".opendistro-anomaly-detector-jobs", false, ThrowingSupplierWrapper.throwingSupplierWrapper(AnomalyDetectionIndices::getAnomalyDetectorJobMappings)),
    CHECKPOINT(".opendistro-anomaly-checkpoints", false, ThrowingSupplierWrapper.throwingSupplierWrapper(AnomalyDetectionIndices::getCheckpointMappings)),
    STATE(".opendistro-anomaly-detection-state", false, ThrowingSupplierWrapper.throwingSupplierWrapper(AnomalyDetectionIndices::getDetectionStateMappings));

    private final String indexName;
    private final boolean alias;
    private final String mapping;

    private ADIndex(String name, boolean alias, Supplier<String> mappingSupplier) {
        this.indexName = name;
        this.alias = alias;
        this.mapping = mappingSupplier.get();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public String getMapping() {
        return this.mapping;
    }
}

