/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.rca.persistence.Persistable;
import org.opensearch.performanceanalyzer.rca.persistence.actions.PersistedAction;
import org.opensearch.performanceanalyzer.rest.MetricsHandler;

public class QueryActionRequestHandler
extends MetricsHandler
implements HttpHandler {
    public static final String ACTION_SET_JSON_NAME = "LastSuggestedActionSet";
    private static final Logger LOG = LogManager.getLogger(QueryActionRequestHandler.class);
    private Persistable persistable;
    private AppContext appContext;
    JsonParser jsonParser;

    public QueryActionRequestHandler(AppContext appContext) {
        this.appContext = appContext;
        this.jsonParser = new JsonParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (requestMethod.equalsIgnoreCase("GET")) {
            LOG.debug("Action Query handler called.");
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            try {
                QueryActionRequestHandler queryActionRequestHandler = this;
                synchronized (queryActionRequestHandler) {
                    String query = exchange.getRequestURI().getQuery();
                    this.handleActionRequest(exchange);
                }
            }
            catch (InvalidParameterException e) {
                LOG.error(() -> new ParameterizedMessage("QueryException {} ExceptionCode: {}.", (Object)e.toString(), (Object)StatExceptionCode.REQUEST_ERROR.toString()), (Throwable)e);
                String response = "{\"error\":\"" + e.getMessage() + "\"}";
                this.sendResponse(exchange, response, 400);
            }
            catch (Exception e) {
                LOG.error(() -> new ParameterizedMessage("QueryException {} ExceptionCode: {}.", (Object)e.toString(), (Object)StatExceptionCode.REQUEST_ERROR.toString()), (Throwable)e);
                String response = "{\"error\":\"" + e.toString() + "\"}";
                this.sendResponse(exchange, response, 500);
            }
        } else {
            exchange.sendResponseHeaders(404, -1L);
        }
        exchange.close();
    }

    private void handleActionRequest(HttpExchange exchange) throws IOException {
        if (!this.validNodeRole()) {
            JsonObject errResponse = new JsonObject();
            errResponse.addProperty("error", "Node being queried is not elected cluster_manager.");
            this.sendResponse(exchange, errResponse.toString(), 400);
            return;
        }
        String response = this.getActionData(this.persistable).toString();
        this.sendResponse(exchange, response, 200);
    }

    private JsonElement getActionData(Persistable persistable) {
        LOG.debug("Action: in getActionData");
        JsonObject result = new JsonObject();
        if (persistable != null) {
            try {
                List<PersistedAction> actionSet = persistable.readAllForMaxField(PersistedAction.class, "timestamp", Long.class);
                JsonArray response = new JsonArray();
                if (actionSet != null) {
                    for (PersistedAction action : actionSet) {
                        response.add(action.toJson(this.jsonParser));
                    }
                    result.add(ACTION_SET_JSON_NAME, (JsonElement)response);
                } else {
                    result.add(ACTION_SET_JSON_NAME, (JsonElement)new JsonArray());
                }
            }
            catch (Exception e) {
                LOG.error("Fail to query DB, message : {}", (Object)e.getMessage());
                result.add("error", (JsonElement)this.jsonParser.parse("Fail to query db").getAsJsonObject());
            }
        }
        return result;
    }

    public void sendResponse(HttpExchange exchange, String response, int status) throws IOException {
        try {
            OutputStream os = exchange.getResponseBody();
            exchange.sendResponseHeaders(status, response.length());
            os.write(response.getBytes());
        }
        catch (Exception e) {
            response = e.toString();
            exchange.sendResponseHeaders(500, response.length());
        }
    }

    public synchronized void setPersistable(Persistable persistable) {
        this.persistable = persistable;
    }

    private boolean validNodeRole() {
        return this.appContext.getMyInstanceDetails().getIsClusterManager();
    }
}

