/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.CalendarLookup;

class DateTimeFormatterUtil {
    private static final int SUFFIX_SPECIAL_START_TH = 11;
    private static final int SUFFIX_SPECIAL_END_TH = 13;
    private static final String SUFFIX_SPECIAL_TH = "th";
    private static final String NANO_SEC_FORMAT = "'%06d'";
    private static final Map<Integer, String> SUFFIX_CONVERTER = ImmutableMap.builder().put((Object)1, (Object)"st").put((Object)2, (Object)"nd").put((Object)3, (Object)"rd").build();
    private static final Map<String, DateTimeFormatHandler> DATE_HANDLERS = ImmutableMap.builder().put((Object)"%a", date -> "EEE").put((Object)"%b", date -> "LLL").put((Object)"%c", date -> "MM").put((Object)"%d", date -> "dd").put((Object)"%e", date -> "d").put((Object)"%H", date -> "HH").put((Object)"%h", date -> "hh").put((Object)"%I", date -> "hh").put((Object)"%i", date -> "mm").put((Object)"%j", date -> "DDD").put((Object)"%k", date -> "H").put((Object)"%l", date -> "h").put((Object)"%p", date -> "a").put((Object)"%M", date -> "LLLL").put((Object)"%m", date -> "MM").put((Object)"%r", date -> "hh:mm:ss a").put((Object)"%S", date -> "ss").put((Object)"%s", date -> "ss").put((Object)"%T", date -> "HH:mm:ss").put((Object)"%W", date -> "EEEE").put((Object)"%Y", date -> "yyyy").put((Object)"%y", date -> "yy").put((Object)"%D", date -> String.format("'%d%s'", date.getDayOfMonth(), DateTimeFormatterUtil.getSuffix(date.getDayOfMonth()))).put((Object)"%f", date -> String.format(NANO_SEC_FORMAT, date.getNano() / 1000)).put((Object)"%w", date -> String.format("'%d'", date.getDayOfWeek().getValue())).put((Object)"%U", date -> String.format("'%d'", CalendarLookup.getWeekNumber(0, date.toLocalDate()))).put((Object)"%u", date -> String.format("'%d'", CalendarLookup.getWeekNumber(1, date.toLocalDate()))).put((Object)"%V", date -> String.format("'%d'", CalendarLookup.getWeekNumber(2, date.toLocalDate()))).put((Object)"%v", date -> String.format("'%d'", CalendarLookup.getWeekNumber(3, date.toLocalDate()))).put((Object)"%X", date -> String.format("'%d'", CalendarLookup.getYearNumber(2, date.toLocalDate()))).put((Object)"%x", date -> String.format("'%d'", CalendarLookup.getYearNumber(3, date.toLocalDate()))).build();
    private static final Map<String, DateTimeFormatHandler> TIME_HANDLERS = ImmutableMap.builder().put((Object)"%a", date -> null).put((Object)"%b", date -> null).put((Object)"%c", date -> "0").put((Object)"%d", date -> "00").put((Object)"%e", date -> "0").put((Object)"%H", date -> "HH").put((Object)"%h", date -> "hh").put((Object)"%I", date -> "hh").put((Object)"%i", date -> "mm").put((Object)"%j", date -> null).put((Object)"%k", date -> "H").put((Object)"%l", date -> "h").put((Object)"%p", date -> "a").put((Object)"%M", date -> null).put((Object)"%m", date -> "00").put((Object)"%r", date -> "hh:mm:ss a").put((Object)"%S", date -> "ss").put((Object)"%s", date -> "ss").put((Object)"%T", date -> "HH:mm:ss").put((Object)"%W", date -> null).put((Object)"%Y", date -> "0000").put((Object)"%y", date -> "00").put((Object)"%D", date -> null).put((Object)"%f", date -> String.format(NANO_SEC_FORMAT, date.getNano() / 1000)).put((Object)"%w", date -> null).put((Object)"%U", date -> null).put((Object)"%u", date -> null).put((Object)"%V", date -> null).put((Object)"%v", date -> null).put((Object)"%X", date -> null).put((Object)"%x", date -> null).build();
    private static final Pattern pattern = Pattern.compile("%.");
    private static final Pattern CHARACTERS_WITH_NO_MOD_LITERAL_BEHIND_PATTERN = Pattern.compile("(?<!%)[a-zA-Z&&[^aydmshiHIMYDSEL]]+");
    private static final String MOD_LITERAL = "%";

    private DateTimeFormatterUtil() {
    }

    static ExprValue getFormattedString(ExprValue formatExpr, Map<String, DateTimeFormatHandler> handler, LocalDateTime datetime) {
        StringBuffer cleanFormat = new StringBuffer();
        Matcher m = CHARACTERS_WITH_NO_MOD_LITERAL_BEHIND_PATTERN.matcher(formatExpr.stringValue());
        while (m.find()) {
            m.appendReplacement(cleanFormat, String.format("'%s'", m.group()));
        }
        m.appendTail(cleanFormat);
        Matcher matcher = pattern.matcher(cleanFormat.toString());
        StringBuffer format = new StringBuffer();
        try {
            while (matcher.find()) {
                matcher.appendReplacement(format, handler.getOrDefault(matcher.group(), d -> String.format("'%s'", matcher.group().replaceFirst(MOD_LITERAL, ""))).getFormat(datetime));
            }
        }
        catch (Exception e) {
            return ExprNullValue.of();
        }
        matcher.appendTail(format);
        return new ExprStringValue(datetime.format(DateTimeFormatter.ofPattern(format.toString(), Locale.ENGLISH)));
    }

    static ExprValue getFormattedDate(ExprValue dateExpr, ExprValue formatExpr) {
        LocalDateTime date = dateExpr.datetimeValue();
        return DateTimeFormatterUtil.getFormattedString(formatExpr, DATE_HANDLERS, date);
    }

    static ExprValue getFormattedDateOfToday(ExprValue formatExpr, ExprValue time, Clock current) {
        LocalDateTime date = LocalDateTime.of(LocalDate.now(current), time.timeValue());
        return DateTimeFormatterUtil.getFormattedString(formatExpr, DATE_HANDLERS, date);
    }

    static ExprValue getFormattedTime(ExprValue timeExpr, ExprValue formatExpr) {
        LocalDateTime time = LocalDateTime.of(LocalDate.now(), timeExpr.timeValue());
        return DateTimeFormatterUtil.getFormattedString(formatExpr, TIME_HANDLERS, time);
    }

    private static String getSuffix(int val) {
        if (11 <= val && val <= 13) {
            return SUFFIX_SPECIAL_TH;
        }
        return SUFFIX_CONVERTER.getOrDefault(val % 10, SUFFIX_SPECIAL_TH);
    }

    static interface DateTimeFormatHandler {
        public String getFormat(LocalDateTime var1);
    }
}

