/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprIntervalValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprMissingValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.ExpressionEvaluationException;

public final class ExprValueUtils {
    public static final ExprValue LITERAL_TRUE = ExprBooleanValue.of(true);
    public static final ExprValue LITERAL_FALSE = ExprBooleanValue.of(false);
    public static final ExprValue LITERAL_NULL = ExprNullValue.of();
    public static final ExprValue LITERAL_MISSING = ExprMissingValue.of();

    public static ExprValue booleanValue(Boolean value) {
        return value != false ? LITERAL_TRUE : LITERAL_FALSE;
    }

    public static ExprValue byteValue(Byte value) {
        return new ExprByteValue(value);
    }

    public static ExprValue shortValue(Short value) {
        return new ExprShortValue(value);
    }

    public static ExprValue integerValue(Integer value) {
        return new ExprIntegerValue(value);
    }

    public static ExprValue doubleValue(Double value) {
        return new ExprDoubleValue(value);
    }

    public static ExprValue floatValue(Float value) {
        return new ExprFloatValue(value);
    }

    public static ExprValue longValue(Long value) {
        return new ExprLongValue(value);
    }

    public static ExprValue stringValue(String value) {
        return new ExprStringValue(value);
    }

    public static ExprValue intervalValue(TemporalAmount value) {
        return new ExprIntervalValue(value);
    }

    public static ExprValue dateValue(LocalDate value) {
        return new ExprDateValue(value);
    }

    public static ExprValue datetimeValue(LocalDateTime value) {
        return new ExprDatetimeValue(value);
    }

    public static ExprValue timeValue(LocalTime value) {
        return new ExprTimeValue(value);
    }

    public static ExprValue timestampValue(Instant value) {
        return new ExprTimestampValue(value);
    }

    public static ExprValue tupleValue(Map<String, Object> map) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        map.forEach((k, v) -> valueMap.put((String)k, v instanceof ExprValue ? (ExprValue)v : ExprValueUtils.fromObjectValue(v)));
        return new ExprTupleValue(valueMap);
    }

    public static ExprValue collectionValue(List<Object> list) {
        ArrayList<ExprValue> valueList = new ArrayList<ExprValue>();
        list.forEach(o -> valueList.add(ExprValueUtils.fromObjectValue(o)));
        return new ExprCollectionValue(valueList);
    }

    public static ExprValue missingValue() {
        return ExprMissingValue.of();
    }

    public static ExprValue nullValue() {
        return ExprNullValue.of();
    }

    public static ExprValue fromObjectValue(Object o) {
        if (null == o) {
            return LITERAL_NULL;
        }
        if (o instanceof Map) {
            return ExprValueUtils.tupleValue((Map)o);
        }
        if (o instanceof List) {
            return ExprValueUtils.collectionValue((List)o);
        }
        if (o instanceof Byte) {
            return ExprValueUtils.byteValue((Byte)o);
        }
        if (o instanceof Short) {
            return ExprValueUtils.shortValue((Short)o);
        }
        if (o instanceof Integer) {
            return ExprValueUtils.integerValue((Integer)o);
        }
        if (o instanceof Long) {
            return ExprValueUtils.longValue((Long)o);
        }
        if (o instanceof Boolean) {
            return ExprValueUtils.booleanValue((Boolean)o);
        }
        if (o instanceof Double) {
            return ExprValueUtils.doubleValue((Double)o);
        }
        if (o instanceof String) {
            return ExprValueUtils.stringValue((String)o);
        }
        if (o instanceof Float) {
            return ExprValueUtils.floatValue((Float)o);
        }
        if (o instanceof LocalDate) {
            return ExprValueUtils.dateValue((LocalDate)o);
        }
        if (o instanceof LocalDateTime) {
            return ExprValueUtils.datetimeValue((LocalDateTime)o);
        }
        if (o instanceof LocalTime) {
            return ExprValueUtils.timeValue((LocalTime)o);
        }
        if (o instanceof Instant) {
            return ExprValueUtils.timestampValue((Instant)o);
        }
        if (o instanceof TemporalAmount) {
            return ExprValueUtils.intervalValue((TemporalAmount)o);
        }
        throw new ExpressionEvaluationException("unsupported object " + o.getClass());
    }

    public static ExprValue fromObjectValue(Object o, ExprCoreType type) {
        switch (type) {
            case TIMESTAMP: {
                return new ExprTimestampValue((String)o);
            }
            case DATE: {
                return new ExprDateValue((String)o);
            }
            case TIME: {
                return new ExprTimeValue((String)o);
            }
            case DATETIME: {
                return new ExprDatetimeValue((String)o);
            }
        }
        return ExprValueUtils.fromObjectValue(o);
    }

    public static Byte getByteValue(ExprValue exprValue) {
        return exprValue.byteValue();
    }

    public static Short getShortValue(ExprValue exprValue) {
        return exprValue.shortValue();
    }

    public static Integer getIntegerValue(ExprValue exprValue) {
        return exprValue.integerValue();
    }

    public static Double getDoubleValue(ExprValue exprValue) {
        return exprValue.doubleValue();
    }

    public static Long getLongValue(ExprValue exprValue) {
        return exprValue.longValue();
    }

    public static Float getFloatValue(ExprValue exprValue) {
        return exprValue.floatValue();
    }

    public static String getStringValue(ExprValue exprValue) {
        return exprValue.stringValue();
    }

    public static List<ExprValue> getCollectionValue(ExprValue exprValue) {
        return exprValue.collectionValue();
    }

    public static Map<String, ExprValue> getTupleValue(ExprValue exprValue) {
        return exprValue.tupleValue();
    }

    public static Boolean getBooleanValue(ExprValue exprValue) {
        return exprValue.booleanValue();
    }

    @Generated
    private ExprValueUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

