/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.queries;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DisMaxQueryBuilder;
import org.opensearch.index.query.FieldMaskingSpanQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.SpanContainingQueryBuilder;
import org.opensearch.index.query.SpanFirstQueryBuilder;
import org.opensearch.index.query.SpanMultiTermQueryBuilder;
import org.opensearch.index.query.SpanNearQueryBuilder;
import org.opensearch.index.query.SpanNotQueryBuilder;
import org.opensearch.index.query.SpanOrQueryBuilder;
import org.opensearch.index.query.SpanWithinQueryBuilder;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;

public abstract class QueryBuilderTraverser {
    public static boolean exists(QueryBuilder queryBuilder, Predicate<QueryBuilder> predicate) {
        Exists traverser = new Exists(predicate);
        return traverser.check(queryBuilder);
    }

    public static QueryBuilder find(QueryBuilder queryBuilder, Predicate<QueryBuilder> predicate) {
        Exists traverser = new Exists(predicate);
        if (traverser.check(queryBuilder)) {
            return traverser.matched;
        }
        return null;
    }

    public static Set<QueryBuilder> findAll(QueryBuilder queryBuilder, Predicate<QueryBuilder> predicate) {
        Complete traverser = new Complete(predicate);
        traverser.check(queryBuilder);
        return traverser.matched;
    }

    public boolean check(String query, NamedXContentRegistry namedXContentRegistry) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(namedXContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, query);
        QueryBuilder queryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        return this.check(queryBuilder);
    }

    public abstract boolean check(QueryBuilder var1);

    public abstract boolean check(List<? extends QueryBuilder> var1);

    public static class Exists
    extends QueryBuilderTraverser {
        private final Predicate<QueryBuilder> predicate;
        private QueryBuilder matched;

        public Exists(Predicate<QueryBuilder> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean check(QueryBuilder queryBuilder) {
            if (queryBuilder == null) {
                return false;
            }
            if (this.predicate.test(queryBuilder)) {
                this.matched = queryBuilder;
                return true;
            }
            if (queryBuilder instanceof BoolQueryBuilder) {
                BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                return this.check(boolQueryBuilder.must()) || this.check(boolQueryBuilder.mustNot()) || this.check(boolQueryBuilder.should()) || this.check(boolQueryBuilder.filter());
            }
            if (queryBuilder instanceof BoostingQueryBuilder) {
                BoostingQueryBuilder boostingQueryBuilder = (BoostingQueryBuilder)queryBuilder;
                return this.check(boostingQueryBuilder.positiveQuery()) || this.check(boostingQueryBuilder.negativeQuery());
            }
            if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                ConstantScoreQueryBuilder constantScoreQueryBuilder = (ConstantScoreQueryBuilder)queryBuilder;
                return this.check(constantScoreQueryBuilder.innerQuery());
            }
            if (queryBuilder instanceof DisMaxQueryBuilder) {
                DisMaxQueryBuilder disMaxQueryBuilder = (DisMaxQueryBuilder)queryBuilder;
                return this.check(disMaxQueryBuilder.innerQueries());
            }
            if (queryBuilder instanceof FieldMaskingSpanQueryBuilder) {
                FieldMaskingSpanQueryBuilder fieldMaskingSpanQueryBuilder = (FieldMaskingSpanQueryBuilder)queryBuilder;
                return this.check((QueryBuilder)fieldMaskingSpanQueryBuilder.innerQuery());
            }
            if (queryBuilder instanceof FunctionScoreQueryBuilder) {
                FunctionScoreQueryBuilder functionScoreQueryBuilder = (FunctionScoreQueryBuilder)queryBuilder;
                return this.check(functionScoreQueryBuilder.query());
            }
            if (queryBuilder instanceof NestedQueryBuilder) {
                NestedQueryBuilder nestedQueryBuilder = (NestedQueryBuilder)queryBuilder;
                return this.check(nestedQueryBuilder.query());
            }
            if (queryBuilder instanceof SpanContainingQueryBuilder) {
                SpanContainingQueryBuilder spanContainingQueryBuilder = (SpanContainingQueryBuilder)queryBuilder;
                return this.check((QueryBuilder)spanContainingQueryBuilder.bigQuery()) || this.check((QueryBuilder)spanContainingQueryBuilder.littleQuery());
            }
            if (queryBuilder instanceof SpanFirstQueryBuilder) {
                SpanFirstQueryBuilder spanFirstQueryBuilder = (SpanFirstQueryBuilder)queryBuilder;
                return this.check((QueryBuilder)spanFirstQueryBuilder.innerQuery());
            }
            if (queryBuilder instanceof SpanMultiTermQueryBuilder) {
                SpanMultiTermQueryBuilder spanMultiTermQueryBuilder = (SpanMultiTermQueryBuilder)queryBuilder;
                return this.check((QueryBuilder)spanMultiTermQueryBuilder.innerQuery());
            }
            if (queryBuilder instanceof SpanNearQueryBuilder) {
                SpanNearQueryBuilder spanNearQueryBuilder = (SpanNearQueryBuilder)queryBuilder;
                return this.check(spanNearQueryBuilder.clauses());
            }
            if (queryBuilder instanceof SpanNotQueryBuilder) {
                SpanNotQueryBuilder spanNotQueryBuilder = (SpanNotQueryBuilder)queryBuilder;
                return this.check((QueryBuilder)spanNotQueryBuilder.excludeQuery()) || this.check((QueryBuilder)spanNotQueryBuilder.includeQuery());
            }
            if (queryBuilder instanceof SpanOrQueryBuilder) {
                SpanOrQueryBuilder spanOrQueryBuilder = (SpanOrQueryBuilder)queryBuilder;
                return this.check(spanOrQueryBuilder.clauses());
            }
            if (queryBuilder instanceof SpanWithinQueryBuilder) {
                SpanWithinQueryBuilder spanWithinQueryBuilder = (SpanWithinQueryBuilder)queryBuilder;
                return this.check((QueryBuilder)spanWithinQueryBuilder.bigQuery()) || this.check((QueryBuilder)spanWithinQueryBuilder.littleQuery());
            }
            return false;
        }

        @Override
        public boolean check(List<? extends QueryBuilder> queryBuilders) {
            for (QueryBuilder queryBuilder : queryBuilders) {
                if (!this.check(queryBuilder)) continue;
                return true;
            }
            return false;
        }

        public QueryBuilder getMatched() {
            return this.matched;
        }
    }

    public static class Complete
    extends QueryBuilderTraverser {
        private final Predicate<QueryBuilder> predicate;
        private Set<QueryBuilder> matched = new HashSet<QueryBuilder>();

        public Complete(Predicate<QueryBuilder> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean check(QueryBuilder queryBuilder) {
            if (queryBuilder == null) {
                return true;
            }
            boolean matched = true;
            if (queryBuilder instanceof BoolQueryBuilder) {
                BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                matched = this.check(boolQueryBuilder.must()) & this.check(boolQueryBuilder.mustNot()) & this.check(boolQueryBuilder.should()) & this.check(boolQueryBuilder.filter());
            } else if (queryBuilder instanceof BoostingQueryBuilder) {
                BoostingQueryBuilder boostingQueryBuilder = (BoostingQueryBuilder)queryBuilder;
                matched = this.check(boostingQueryBuilder.positiveQuery()) & this.check(boostingQueryBuilder.negativeQuery());
            } else if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                ConstantScoreQueryBuilder constantScoreQueryBuilder = (ConstantScoreQueryBuilder)queryBuilder;
                matched = this.check(constantScoreQueryBuilder.innerQuery());
            } else if (queryBuilder instanceof DisMaxQueryBuilder) {
                DisMaxQueryBuilder disMaxQueryBuilder = (DisMaxQueryBuilder)queryBuilder;
                matched = this.check(disMaxQueryBuilder.innerQueries());
            } else if (queryBuilder instanceof FieldMaskingSpanQueryBuilder) {
                FieldMaskingSpanQueryBuilder fieldMaskingSpanQueryBuilder = (FieldMaskingSpanQueryBuilder)queryBuilder;
                matched = this.check((QueryBuilder)fieldMaskingSpanQueryBuilder.innerQuery());
            } else if (queryBuilder instanceof FunctionScoreQueryBuilder) {
                FunctionScoreQueryBuilder functionScoreQueryBuilder = (FunctionScoreQueryBuilder)queryBuilder;
                matched = this.check(functionScoreQueryBuilder.query());
            } else if (queryBuilder instanceof NestedQueryBuilder) {
                NestedQueryBuilder nestedQueryBuilder = (NestedQueryBuilder)queryBuilder;
                matched = this.check(nestedQueryBuilder.query());
            } else if (queryBuilder instanceof SpanContainingQueryBuilder) {
                SpanContainingQueryBuilder spanContainingQueryBuilder = (SpanContainingQueryBuilder)queryBuilder;
                matched = this.check((QueryBuilder)spanContainingQueryBuilder.bigQuery()) & this.check((QueryBuilder)spanContainingQueryBuilder.littleQuery());
            } else if (queryBuilder instanceof SpanFirstQueryBuilder) {
                SpanFirstQueryBuilder spanFirstQueryBuilder = (SpanFirstQueryBuilder)queryBuilder;
                matched = this.check((QueryBuilder)spanFirstQueryBuilder.innerQuery());
            } else if (queryBuilder instanceof SpanMultiTermQueryBuilder) {
                SpanMultiTermQueryBuilder spanMultiTermQueryBuilder = (SpanMultiTermQueryBuilder)queryBuilder;
                matched = this.check((QueryBuilder)spanMultiTermQueryBuilder.innerQuery());
            } else if (queryBuilder instanceof SpanNearQueryBuilder) {
                SpanNearQueryBuilder spanNearQueryBuilder = (SpanNearQueryBuilder)queryBuilder;
                matched = this.check(spanNearQueryBuilder.clauses());
            } else if (queryBuilder instanceof SpanNotQueryBuilder) {
                SpanNotQueryBuilder spanNotQueryBuilder = (SpanNotQueryBuilder)queryBuilder;
                matched = this.check((QueryBuilder)spanNotQueryBuilder.excludeQuery()) & this.check((QueryBuilder)spanNotQueryBuilder.includeQuery());
            } else if (queryBuilder instanceof SpanOrQueryBuilder) {
                SpanOrQueryBuilder spanOrQueryBuilder = (SpanOrQueryBuilder)queryBuilder;
                matched = this.check(spanOrQueryBuilder.clauses());
            } else if (queryBuilder instanceof SpanWithinQueryBuilder) {
                SpanWithinQueryBuilder spanWithinQueryBuilder = (SpanWithinQueryBuilder)queryBuilder;
                matched = this.check((QueryBuilder)spanWithinQueryBuilder.bigQuery()) & this.check((QueryBuilder)spanWithinQueryBuilder.littleQuery());
            }
            if (this.predicate.test(queryBuilder)) {
                this.matched.add(queryBuilder);
                return matched;
            }
            return false;
        }

        @Override
        public boolean check(List<? extends QueryBuilder> queryBuilders) {
            boolean matched = true;
            for (QueryBuilder queryBuilder : queryBuilders) {
                matched &= this.check(queryBuilder);
            }
            return matched;
        }

        public Set<QueryBuilder> getMatched() {
            return this.matched;
        }
    }
}

