/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auditlog.impl.AuditCategory;
import org.opensearch.security.dlic.rest.validation.AbstractConfigurationValidator;

public class AuditValidator
extends AbstractConfigurationValidator {
    private static final Set<AuditCategory> DISABLED_REST_CATEGORIES = ImmutableSet.of((Object)((Object)AuditCategory.BAD_HEADERS), (Object)((Object)AuditCategory.SSL_EXCEPTION), (Object)((Object)AuditCategory.AUTHENTICATED), (Object)((Object)AuditCategory.FAILED_LOGIN), (Object)((Object)AuditCategory.GRANTED_PRIVILEGES), (Object)((Object)AuditCategory.MISSING_PRIVILEGES), (Object[])new AuditCategory[0]);
    private static final Set<AuditCategory> DISABLED_TRANSPORT_CATEGORIES = ImmutableSet.of((Object)((Object)AuditCategory.BAD_HEADERS), (Object)((Object)AuditCategory.SSL_EXCEPTION), (Object)((Object)AuditCategory.AUTHENTICATED), (Object)((Object)AuditCategory.FAILED_LOGIN), (Object)((Object)AuditCategory.GRANTED_PRIVILEGES), (Object)((Object)AuditCategory.MISSING_PRIVILEGES), (Object[])new AuditCategory[]{AuditCategory.INDEX_EVENT, AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT});

    public AuditValidator(RestRequest request, BytesReference ref, Settings opensearchSettings, Object ... param) {
        super(request, ref, opensearchSettings, param);
        this.payloadMandatory = true;
        this.allowedKeys.put("enabled", AbstractConfigurationValidator.DataType.BOOLEAN);
        this.allowedKeys.put("audit", AbstractConfigurationValidator.DataType.OBJECT);
        this.allowedKeys.put("compliance", AbstractConfigurationValidator.DataType.OBJECT);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if ((this.request.method() == RestRequest.Method.PUT || this.request.method() == RestRequest.Method.PATCH) && this.content != null && this.content.length() > 0) {
            try {
                AuditConfig auditConfig = DefaultObjectMapper.readTree(this.getContentAsNode(), AuditConfig.class);
                AuditConfig.Filter filter = auditConfig.getFilter();
                if (!DISABLED_REST_CATEGORIES.containsAll(filter.getDisabledRestCategories())) {
                    throw new IllegalArgumentException("Invalid REST categories passed in the request");
                }
                if (!DISABLED_TRANSPORT_CATEGORIES.containsAll(filter.getDisabledTransportCategories())) {
                    throw new IllegalArgumentException("Invalid transport categories passed in the request");
                }
            }
            catch (Exception e) {
                this.errorType = AbstractConfigurationValidator.ErrorType.BODY_NOT_PARSEABLE;
                this.log.error("Invalid content passed in the request", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

