/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.search.asynchronous.id.AsynchronousSearchId;
import org.opensearch.search.asynchronous.request.DeleteAsynchronousSearchRequest;
import org.opensearch.search.asynchronous.response.AcknowledgedResponse;
import org.opensearch.search.asynchronous.service.AsynchronousSearchService;
import org.opensearch.search.asynchronous.transport.TransportAsynchronousSearchRoutingAction;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportDeleteAsynchronousSearchAction
extends TransportAsynchronousSearchRoutingAction<DeleteAsynchronousSearchRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAsynchronousSearchRoutingAction.class);
    private final AsynchronousSearchService asynchronousSearchService;

    @Inject
    public TransportDeleteAsynchronousSearchAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AsynchronousSearchService asynchronousSearchService, Client client) {
        super(transportService, clusterService, threadPool, client, "cluster:admin/opendistro/asynchronous_search/delete", actionFilters, asynchronousSearchService, DeleteAsynchronousSearchRequest::new, AcknowledgedResponse::new);
        this.asynchronousSearchService = asynchronousSearchService;
    }

    @Override
    public void handleRequest(AsynchronousSearchId asynchronousSearchId, DeleteAsynchronousSearchRequest request, ActionListener<AcknowledgedResponse> listener, User user) {
        try {
            this.asynchronousSearchService.freeContext(request.getId(), asynchronousSearchId.getAsynchronousSearchContextId(), user, (ActionListener<Boolean>)ActionListener.wrap(complete -> listener.onResponse((Object)new AcknowledgedResponse((boolean)complete)), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("Unable to delete asynchronous search [{}]", (Object)request.getId()), (Throwable)e);
            listener.onFailure(e);
        }
    }
}

