/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.metrics.MetricsRestUtil;
import org.opensearch.performanceanalyzer.rca.Version;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;
import org.opensearch.performanceanalyzer.rca.framework.util.SQLiteQueryUtils;
import org.opensearch.performanceanalyzer.rca.persistence.Persistable;
import org.opensearch.performanceanalyzer.rest.MetricsHandler;

public class QueryRcaRequestHandler
extends MetricsHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(QueryRcaRequestHandler.class);
    private static final String DUMP_ALL = "all";
    private static final String VERSION_PARAM = "v";
    private static final String LOCAL_PARAM = "local";
    private static final String VERSION_RESPONSE_PROPERTY = "version";
    public static final String NAME_PARAM = "name";
    private Persistable persistable;
    private MetricsRestUtil metricsRestUtil;
    private AppContext appContext;

    public QueryRcaRequestHandler(AppContext appContext) {
        this.appContext = appContext;
        this.metricsRestUtil = new MetricsRestUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (requestMethod.equalsIgnoreCase("GET")) {
            LOG.debug("RCA Query handler called.");
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            try {
                QueryRcaRequestHandler queryRcaRequestHandler = this;
                synchronized (queryRcaRequestHandler) {
                    String query = exchange.getRequestURI().getQuery();
                    if (query != null && query.equalsIgnoreCase(VERSION_PARAM)) {
                        this.sendResponse(exchange, this.getVersion(), 200);
                        return;
                    }
                    if (query != null && query.equals(DUMP_ALL)) {
                        this.sendResponse(exchange, this.dumpAllRcaTables(), 200);
                    } else {
                        Map<String, String> params = this.getParamsMap(query);
                        if (this.isLocalTemperatureProfileRequest(params)) {
                            this.handleLocalRcaRequest(params, exchange);
                        } else {
                            this.handleClusterRcaRequest(params, exchange);
                        }
                    }
                }
            }
            catch (InvalidParameterException e) {
                LOG.error(() -> new ParameterizedMessage("QueryException {} ExceptionCode: {}.", (Object)e.toString(), (Object)StatExceptionCode.REQUEST_ERROR.toString()), (Throwable)e);
                String response = "{\"error\":\"" + e.getMessage() + "\"}";
                this.sendResponse(exchange, response, 400);
            }
            catch (Exception e) {
                LOG.error(() -> new ParameterizedMessage("QueryException {} ExceptionCode: {}.", (Object)e.toString(), (Object)StatExceptionCode.REQUEST_ERROR.toString()), (Throwable)e);
                String response = "{\"error\":\"" + e.toString() + "\"}";
                this.sendResponse(exchange, response, 500);
            }
        } else {
            exchange.sendResponseHeaders(404, -1L);
        }
        exchange.close();
    }

    private void handleClusterRcaRequest(Map<String, String> params, HttpExchange exchange) throws IOException {
        if (!this.validNodeRole()) {
            JsonObject errResponse = new JsonObject();
            errResponse.addProperty("error", "Node being queried is not elected cluster_manager.");
            this.sendResponse(exchange, errResponse.toString(), 400);
            return;
        }
        List<String> rcaList = this.metricsRestUtil.parseArrayParam(params, NAME_PARAM, true);
        if (rcaList.isEmpty()) {
            rcaList = this.persistable.getAllPersistedRcas();
        } else if (!this.validParams(rcaList)) {
            JsonObject errResponse = new JsonObject();
            JsonArray errReason = new JsonArray();
            SQLiteQueryUtils.getClusterLevelRca().forEach(arg_0 -> ((JsonArray)errReason).add(arg_0));
            errResponse.addProperty("error", "Invalid RCA.");
            errResponse.add("valid_cluster_rca", (JsonElement)errReason);
            this.sendResponse(exchange, errResponse.toString(), 400);
            return;
        }
        String response = this.getRcaData(this.persistable, rcaList).toString();
        this.sendResponse(exchange, response, 200);
    }

    private boolean isLocalTemperatureProfileRequest(Map<String, String> params) {
        List<String> temperatureProfileRcas = SQLiteQueryUtils.getTemperatureProfileRcas();
        if (params.containsKey(LOCAL_PARAM)) {
            if (!Boolean.parseBoolean(params.get(LOCAL_PARAM))) {
                return false;
            }
            String requestedRca = params.get(NAME_PARAM);
            return temperatureProfileRcas.contains(requestedRca);
        }
        return false;
    }

    private void handleLocalRcaRequest(Map<String, String> params, HttpExchange exchange) throws IOException {
        String rcaRequested = params.get(NAME_PARAM);
        if (rcaRequested == null || rcaRequested.isEmpty()) {
            JsonObject errorResponse = new JsonObject();
            errorResponse.addProperty("error", "name parameter is empty or null");
            this.sendResponse(exchange, errorResponse.toString(), 400);
            return;
        }
        try {
            if (Stats.getInstance().getMutedGraphNodes().contains(rcaRequested)) {
                JsonObject errorResponse = new JsonObject();
                StringBuilder builder = new StringBuilder();
                builder.append("The Rca '").append(rcaRequested).append("' is muted. Consider removing it from the rca.conf's 'muted-rcas' list");
                errorResponse.addProperty("error", builder.toString());
                this.sendResponse(exchange, errorResponse.toString(), 400);
            } else {
                String response = this.getTemperatureProfileRca(this.persistable, rcaRequested).toString();
                this.sendResponse(exchange, response, 200);
            }
        }
        catch (Exception ex) {
            JsonObject errorResponse = new JsonObject();
            errorResponse.addProperty("error", ex.getMessage());
            this.sendResponse(exchange, errorResponse.toString(), 400);
        }
    }

    private boolean validParams(List<String> rcaList) {
        return rcaList.stream().allMatch(SQLiteQueryUtils::isClusterLevelRca);
    }

    private boolean validNodeRole() {
        return this.appContext.getMyInstanceDetails().getIsClusterManager();
    }

    private JsonElement getRcaData(Persistable persistable, List<String> rcaList) {
        LOG.debug("RCA: in getRcaData");
        JsonObject jsonObject = new JsonObject();
        if (persistable != null) {
            rcaList.forEach(rca -> jsonObject.add(rca, persistable.read((String)rca)));
        }
        return jsonObject;
    }

    private JsonElement getTemperatureProfileRca(Persistable persistable, String rca) {
        JsonObject responseJson = new JsonObject();
        if (persistable != null) {
            responseJson.add(rca, persistable.read(rca));
        }
        return responseJson;
    }

    private String dumpAllRcaTables() {
        String jsonResponse = "";
        if (this.persistable != null) {
            jsonResponse = this.persistable.read();
        }
        return jsonResponse;
    }

    public void sendResponse(HttpExchange exchange, String response, int status) throws IOException {
        try (OutputStream os = exchange.getResponseBody();){
            exchange.sendResponseHeaders(status, response.length());
            os.write(response.getBytes());
        }
        catch (Exception e) {
            response = e.toString();
            exchange.sendResponseHeaders(500, response.length());
        }
    }

    public synchronized void setPersistable(Persistable persistable) {
        this.persistable = persistable;
    }

    public String getVersion() {
        JsonObject versionObject = new JsonObject();
        versionObject.addProperty(VERSION_RESPONSE_PROPERTY, Version.getRcaVersion());
        return versionObject.toString();
    }
}

