/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.collectors.StatExceptionCode;
import org.opensearch.performanceanalyzer.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.EventProcessor;
import org.opensearch.performanceanalyzer.reader.MemoryDBSnapshot;
import org.opensearch.performanceanalyzer.reader.MetricProperties;
import org.opensearch.performanceanalyzer.reader.MetricPropertiesConfig;
import org.opensearch.performanceanalyzer.reader_writer_shared.Event;
import org.opensearch.performanceanalyzer.util.JsonConverter;
import org.opensearch.performanceanalyzer.util.JsonPathNotFoundException;

public class NodeMetricsEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(NodeMetricsEventProcessor.class);
    private Map<AllMetrics.MetricName, MemoryDBSnapshot> metricsSnapshotMap;
    private Map<AllMetrics.MetricName, BatchBindStep> metricsBatchBindMap;
    private long startTime;
    private long endTime;
    private AllMetrics.MetricName lastUpdatedMetric;
    private Map<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>> nodeMetricsMap;

    private NodeMetricsEventProcessor(Map<AllMetrics.MetricName, MemoryDBSnapshot> metricsSnapshotMap) {
        this.metricsSnapshotMap = metricsSnapshotMap;
        this.metricsBatchBindMap = new HashMap<AllMetrics.MetricName, BatchBindStep>();
    }

    static NodeMetricsEventProcessor buildNodeMetricEventsProcessor(long currTimestamp, Connection conn, Map<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>> nodeMetricsMap) throws Exception {
        HashMap<AllMetrics.MetricName, MemoryDBSnapshot> metricSnapshotMap = new HashMap<AllMetrics.MetricName, MemoryDBSnapshot>();
        for (AllMetrics.MetricName metric : AllMetrics.MetricName.values()) {
            NavigableMap<Long, MemoryDBSnapshot> currMetricMap = nodeMetricsMap.get((Object)metric);
            MemoryDBSnapshot currSnap = (MemoryDBSnapshot)currMetricMap.get(currTimestamp);
            if (currSnap == null) {
                currSnap = new MemoryDBSnapshot(conn, metric, currTimestamp);
                currMetricMap.put(currTimestamp, currSnap);
            }
            metricSnapshotMap.put(metric, currSnap);
        }
        NodeMetricsEventProcessor eventProcessor = new NodeMetricsEventProcessor(metricSnapshotMap);
        eventProcessor.setNodeMetricsMap(nodeMetricsMap);
        return eventProcessor;
    }

    void setNodeMetricsMap(Map<AllMetrics.MetricName, NavigableMap<Long, MemoryDBSnapshot>> nodeMetricsMap) {
        this.nodeMetricsMap = nodeMetricsMap;
    }

    @Override
    public void initializeProcessing(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        for (AllMetrics.MetricName metric : AllMetrics.MetricName.values()) {
            MemoryDBSnapshot dbSnap = this.metricsSnapshotMap.get((Object)metric);
            this.metricsBatchBindMap.put(metric, dbSnap.startBatchPut());
        }
    }

    @Override
    public void finalizeProcessing() {
        for (AllMetrics.MetricName metric : AllMetrics.MetricName.values()) {
            BatchBindStep batchHandle = this.metricsBatchBindMap.get((Object)metric);
            MemoryDBSnapshot dbSnap = this.metricsSnapshotMap.get((Object)metric);
            if (batchHandle == null || batchHandle.size() <= 0) continue;
            batchHandle.execute();
            NavigableMap<Long, MemoryDBSnapshot> currMap = this.nodeMetricsMap.get((Object)metric);
            currMap.put(dbSnap.getLastUpdatedTime(), dbSnap);
        }
    }

    @Override
    public boolean shouldProcessEvent(Event event) {
        for (String metric : MetricPropertiesConfig.getInstance().getMetricPathMap().values()) {
            if (!event.key.contains(metric)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void commitBatchIfRequired() {
        BatchBindStep handle;
        if (this.lastUpdatedMetric != null && (handle = this.metricsBatchBindMap.get((Object)this.lastUpdatedMetric)).size() > 500) {
            handle.execute();
            this.metricsBatchBindMap.put(this.lastUpdatedMetric, this.metricsSnapshotMap.get((Object)this.lastUpdatedMetric).startBatchPut());
        }
    }

    @Override
    public void processEvent(Event nodeMetric) {
        MetricProperties currParser;
        BatchBindStep batchHandler;
        String key = nodeMetric.key.split(File.separatorChar == '\\' ? "\\\\" : File.separator)[0];
        AllMetrics.MetricName name = MetricPropertiesConfig.getInstance().getEventKeyToMetricNameMap().get(key);
        MemoryDBSnapshot snap = this.metricsSnapshotMap.get((Object)name);
        if (this.processEvent(nodeMetric, snap, this.startTime, batchHandler = this.metricsBatchBindMap.computeIfAbsent(name, k -> snap.startBatchPut()), currParser = MetricPropertiesConfig.getInstance().getProperty(name))) {
            this.lastUpdatedMetric = name;
        }
    }

    private boolean processEvent(Event event, MemoryDBSnapshot snap, long startTime, BatchBindStep batchHandle, MetricProperties metricProperties) {
        String[] lines = event.value.split(System.getProperty("line.separator"));
        long lastModifiedTime = 0L;
        try {
            lastModifiedTime = JsonConverter.getLongValue(lines[0], "current_time");
        }
        catch (JsonPathNotFoundException ex) {
            LOG.warn(String.format("Fail to get last modified time of %s ExceptionCode: %s", event.key, StatExceptionCode.JSON_PARSER_ERROR.toString()), (Throwable)ex);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
        catch (JsonProcessingException ex) {
            LOG.warn(String.format("Malformed json (%s) ExceptionCode: %s", lines[0], StatExceptionCode.JSON_PARSER_ERROR.toString()), (Throwable)ex);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
        catch (IOException ex) {
            LOG.warn(String.format("I/O exception processing metric %s with value: %s.%sExceptionCode: %s", event.key, lines[0], File.separator, StatExceptionCode.JSON_PARSER_ERROR.toString()), (Throwable)ex);
            StatsCollector.instance().logException(StatExceptionCode.JSON_PARSER_ERROR);
            return false;
        }
        if (snap.getLastUpdatedTime() < lastModifiedTime) {
            snap.setLastUpdatedTime(lastModifiedTime);
        }
        String[] derivedDimension = metricProperties.getHandler().processExtraDimensions(event.key);
        int numMetrics = derivedDimension.length + metricProperties.getDirectDimensionsSize() + metricProperties.getMetadataSize();
        Object[] templateMetricVals = new Object[numMetrics];
        int valIndex = 0;
        for (String s : derivedDimension) {
            templateMetricVals[valIndex] = s;
            ++valIndex;
        }
        boolean processed = false;
        for (int lineNum = 1; lineNum < lines.length; ++lineNum) {
            processed = metricProperties.processJsonLine(lines[lineNum], batchHandle, templateMetricVals) || processed;
        }
        return processed;
    }
}

