/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.stats.eval.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.opensearch.performanceanalyzer.rca.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.IStatistic;
import org.opensearch.performanceanalyzer.rca.stats.eval.impl.vals.AggregateValue;

public class Count
implements IStatistic<AggregateValue> {
    private AtomicLong counter = new AtomicLong(0L);
    private boolean empty = true;

    @Override
    public Statistics type() {
        return Statistics.COUNT;
    }

    @Override
    public void calculate(String key, Number value) {
        this.counter.incrementAndGet();
        this.empty = false;
    }

    @Override
    public List<AggregateValue> get() {
        return Collections.singletonList(new AggregateValue(this.counter, this.type()));
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }
}

