/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.DecisionMakerConsts;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.decisionmaker.actions.SuppressibleAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;
import org.opensearch.performanceanalyzer.rca.store.rca.util.NodeConfigCacheReaderUtil;

public class ModifyCacheMaxSizeAction
extends SuppressibleAction {
    private static final Logger LOG = LogManager.getLogger(ModifyCacheMaxSizeAction.class);
    public static final String NAME = "ModifyCacheMaxSize";
    private final NodeKey node;
    private final ResourceEnum cacheType;
    private final long desiredCacheMaxSizeInBytes;
    private final long currentCacheMaxSizeInBytes;
    private final long coolOffPeriodInMillis;
    private final boolean canUpdate;

    public ModifyCacheMaxSizeAction(NodeKey node, ResourceEnum cacheType, AppContext appContext, long desiredCacheMaxSizeInBytes, long currentCacheMaxSizeInBytes, long coolOffPeriodInMillis, boolean canUpdate) {
        super(appContext);
        this.node = node;
        this.cacheType = cacheType;
        this.desiredCacheMaxSizeInBytes = desiredCacheMaxSizeInBytes;
        this.currentCacheMaxSizeInBytes = currentCacheMaxSizeInBytes;
        this.coolOffPeriodInMillis = coolOffPeriodInMillis;
        this.canUpdate = canUpdate;
    }

    public static Builder newBuilder(NodeKey node, ResourceEnum cacheType, AppContext appContext, RcaConf conf) {
        return new Builder(node, cacheType, appContext, conf);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public boolean canUpdate() {
        return this.canUpdate && this.desiredCacheMaxSizeInBytes != this.currentCacheMaxSizeInBytes;
    }

    @Override
    public long coolOffPeriodInMillis() {
        return this.coolOffPeriodInMillis;
    }

    @Override
    public List<NodeKey> impactedNodes() {
        return Collections.singletonList(this.node);
    }

    @Override
    public Map<NodeKey, ImpactVector> impact() {
        ImpactVector impactVector = new ImpactVector();
        if (this.desiredCacheMaxSizeInBytes > this.currentCacheMaxSizeInBytes) {
            impactVector.increasesPressure(ImpactVector.Dimension.HEAP);
        } else if (this.desiredCacheMaxSizeInBytes < this.currentCacheMaxSizeInBytes) {
            impactVector.decreasesPressure(ImpactVector.Dimension.HEAP);
        }
        return Collections.singletonMap(this.node, impactVector);
    }

    @Override
    public String summary() {
        Summary summary = new Summary(this.node.getNodeId().toString(), this.node.getHostAddress().toString(), this.cacheType.getNumber(), this.desiredCacheMaxSizeInBytes, this.currentCacheMaxSizeInBytes, this.coolOffPeriodInMillis, this.canUpdate);
        return summary.toJson();
    }

    public static ModifyCacheMaxSizeAction fromSummary(String jsonRepr, AppContext appContext) {
        JsonObject jsonObject = DecisionMakerConsts.JSON_PARSER.parse(jsonRepr).getAsJsonObject();
        NodeKey node = new NodeKey(new InstanceDetails.Id(jsonObject.get("Id").getAsString()), new InstanceDetails.Ip(jsonObject.get("Ip").getAsString()));
        ResourceEnum cacheType = ResourceEnum.forNumber(jsonObject.get("resource").getAsInt());
        long desiredCacheMaxSizeInBytes = jsonObject.get("desiredCacheMaxSizeInBytes").getAsLong();
        long currentCacheMaxSizeInBytes = jsonObject.get("currentCacheMaxSizeInBytes").getAsLong();
        long coolOffPeriodInMillis = jsonObject.get("coolOffPeriodInMillis").getAsLong();
        boolean canUpdate = jsonObject.get("canUpdate").getAsBoolean();
        return new ModifyCacheMaxSizeAction(node, cacheType, appContext, desiredCacheMaxSizeInBytes, currentCacheMaxSizeInBytes, coolOffPeriodInMillis, canUpdate);
    }

    public String toString() {
        return this.summary();
    }

    public long getCurrentCacheMaxSizeInBytes() {
        return this.currentCacheMaxSizeInBytes;
    }

    public long getDesiredCacheMaxSizeInBytes() {
        return this.desiredCacheMaxSizeInBytes;
    }

    public ResourceEnum getCacheType() {
        return this.cacheType;
    }

    public static long getThresholdInBytes(double threshold, long heapSize) {
        return (long)(threshold * (double)heapSize);
    }

    public static final class Builder {
        public static final long DEFAULT_COOL_OFF_PERIOD_IN_MILLIS = 300000L;
        public static final boolean DEFAULT_IS_INCREASE = true;
        public static final boolean DEFAULT_CAN_UPDATE = true;
        private final ResourceEnum cacheType;
        private final NodeKey node;
        private final AppContext appContext;
        private final RcaConf rcaConf;
        private double stepSizeInPercent;
        private boolean isIncrease;
        private boolean canUpdate;
        private long coolOffPeriodInMillis;
        private Long currentCacheMaxSizeInBytes;
        private Long desiredCacheMaxSizeInBytes;
        private Long heapMaxSizeInBytes;
        private final long upperBoundInBytes;
        private final long lowerBoundInBytes;

        private Builder(NodeKey node, ResourceEnum cacheType, AppContext appContext, RcaConf conf) {
            this.node = node;
            this.cacheType = cacheType;
            this.appContext = appContext;
            this.rcaConf = conf;
            this.coolOffPeriodInMillis = 300000L;
            this.isIncrease = true;
            this.canUpdate = true;
            this.currentCacheMaxSizeInBytes = NodeConfigCacheReaderUtil.readCacheMaxSizeInBytes(appContext.getNodeConfigCache(), node, cacheType);
            this.heapMaxSizeInBytes = NodeConfigCacheReaderUtil.readHeapMaxSizeInBytes(appContext.getNodeConfigCache(), node);
            this.desiredCacheMaxSizeInBytes = null;
            CacheActionConfig cacheActionConfig = new CacheActionConfig(this.rcaConf);
            double upperBoundThreshold = cacheActionConfig.getThresholdConfig(cacheType).upperBound();
            double lowerBoundThreshold = cacheActionConfig.getThresholdConfig(cacheType).lowerBound();
            this.stepSizeInPercent = cacheActionConfig.getStepSize(cacheType);
            if (this.heapMaxSizeInBytes != null) {
                this.upperBoundInBytes = ModifyCacheMaxSizeAction.getThresholdInBytes(upperBoundThreshold, this.heapMaxSizeInBytes);
                this.lowerBoundInBytes = ModifyCacheMaxSizeAction.getThresholdInBytes(lowerBoundThreshold, this.heapMaxSizeInBytes);
            } else {
                this.upperBoundInBytes = 0L;
                this.lowerBoundInBytes = 0L;
            }
        }

        public Builder coolOffPeriod(long coolOffPeriodInMillis) {
            this.coolOffPeriodInMillis = coolOffPeriodInMillis;
            return this;
        }

        public Builder increase(boolean isIncrease) {
            this.isIncrease = isIncrease;
            return this;
        }

        public Builder setDesiredCacheMaxSizeToMin() {
            this.desiredCacheMaxSizeInBytes = this.lowerBoundInBytes;
            return this;
        }

        public Builder setDesiredCacheMaxSizeToMax() {
            this.desiredCacheMaxSizeInBytes = this.upperBoundInBytes;
            return this;
        }

        public Builder stepSizeInPercent(double stepSizeInPercent) {
            this.stepSizeInPercent = stepSizeInPercent;
            return this;
        }

        public ModifyCacheMaxSizeAction build() {
            if (this.currentCacheMaxSizeInBytes == null || this.heapMaxSizeInBytes == null) {
                LOG.error("Action: Fail to read cache max size or heap max size from node config cache. Return an non-actionable action");
                return new ModifyCacheMaxSizeAction(this.node, this.cacheType, this.appContext, -1L, -1L, this.coolOffPeriodInMillis, false);
            }
            if (this.currentCacheMaxSizeInBytes == -1L) {
                this.currentCacheMaxSizeInBytes = this.heapMaxSizeInBytes;
            }
            long stepSizeInBytes = (long)(this.stepSizeInPercent * (double)this.heapMaxSizeInBytes.longValue());
            if (this.desiredCacheMaxSizeInBytes == null) {
                this.desiredCacheMaxSizeInBytes = this.isIncrease ? this.currentCacheMaxSizeInBytes + stepSizeInBytes : this.currentCacheMaxSizeInBytes - stepSizeInBytes;
            }
            this.desiredCacheMaxSizeInBytes = Math.max(Math.min(this.desiredCacheMaxSizeInBytes, this.upperBoundInBytes), this.lowerBoundInBytes);
            return new ModifyCacheMaxSizeAction(this.node, this.cacheType, this.appContext, this.desiredCacheMaxSizeInBytes, this.currentCacheMaxSizeInBytes, this.coolOffPeriodInMillis, this.canUpdate);
        }
    }

    public static class Summary {
        public static final String ID = "Id";
        public static final String IP = "Ip";
        public static final String RESOURCE = "resource";
        public static final String DESIRED_MAX_SIZE = "desiredCacheMaxSizeInBytes";
        public static final String CURRENT_MAX_SIZE = "currentCacheMaxSizeInBytes";
        public static final String COOL_OFF_PERIOD = "coolOffPeriodInMillis";
        public static final String CAN_UPDATE = "canUpdate";
        @SerializedName(value="Id")
        private String id;
        @SerializedName(value="Ip")
        private String ip;
        @SerializedName(value="resource")
        private int resource;
        @SerializedName(value="desiredCacheMaxSizeInBytes")
        private long desiredCacheMaxSizeInBytes;
        @SerializedName(value="currentCacheMaxSizeInBytes")
        private long currentCacheMaxSizeInBytes;
        @SerializedName(value="coolOffPeriodInMillis")
        private long coolOffPeriodInMillis;
        @SerializedName(value="canUpdate")
        private boolean canUpdate;

        public Summary(String id, String ip, int resource, long desiredCacheMaxSizeInBytes, long currentCacheMaxSizeInBytes, long coolOffPeriodInMillis, boolean canUpdate) {
            this.id = id;
            this.ip = ip;
            this.resource = resource;
            this.desiredCacheMaxSizeInBytes = desiredCacheMaxSizeInBytes;
            this.currentCacheMaxSizeInBytes = currentCacheMaxSizeInBytes;
            this.coolOffPeriodInMillis = coolOffPeriodInMillis;
            this.canUpdate = canUpdate;
        }

        public String toJson() {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            return gson.toJson((Object)this);
        }

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public ResourceEnum getResource() {
            return ResourceEnum.forNumber(this.resource);
        }

        public long getCurrentCacheMaxSizeInBytes() {
            return this.currentCacheMaxSizeInBytes;
        }

        public long getDesiredCacheMaxSizeInBytes() {
            return this.desiredCacheMaxSizeInBytes;
        }

        public long getCoolOffPeriodInMillis() {
            return this.coolOffPeriodInMillis;
        }

        public boolean getCanUpdate() {
            return this.canUpdate;
        }
    }
}

